/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ranker.local;

import com.intellij.internal.ml.ModelMetadataReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/completion/ml/ranker/local/ZipModelMetadataReader;", "Lcom/intellij/internal/ml/ModelMetadataReader;", "zipFile", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "allKnown", "", "binaryFeatures", "categoricalFeatures", "extractVersion", "featureOrderDirect", "", "floatFeatures", "getSupportedLanguages", "resourceContent", "fileName", "tryGetResourceAsStream", "Ljava/io/InputStream;", "intellij.completionMlRanking"})
public final class ZipModelMetadataReader
implements ModelMetadataReader {
    private final ZipFile zipFile;

    @NotNull
    public String binaryFeatures() {
        return this.resourceContent("binary.json");
    }

    @NotNull
    public String floatFeatures() {
        return this.resourceContent("float.json");
    }

    @NotNull
    public String categoricalFeatures() {
        return this.resourceContent("categorical.json");
    }

    @NotNull
    public String allKnown() {
        return this.resourceContent("all_features.json");
    }

    @NotNull
    public List<String> featureOrderDirect() {
        return StringsKt.lines((CharSequence)this.resourceContent("features_order.txt"));
    }

    @Nullable
    public String extractVersion() {
        return null;
    }

    @NotNull
    public final List<String> getSupportedLanguages() {
        return StringsKt.lines((CharSequence)this.resourceContent("languages.txt"));
    }

    @Nullable
    public final InputStream tryGetResourceAsStream(@NotNull String fileName) {
        Object v3;
        block2: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile.entries()");
            Enumeration<? extends ZipEntry> enumeration2 = enumeration;
            boolean bl = false;
            Sequence $this$firstOrNull$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ZipEntry it = (ZipEntry)element$iv;
                boolean bl2 = false;
                ZipEntry zipEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
                String string = zipEntry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!StringsKt.endsWith$default((String)string, (String)fileName, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        ZipEntry zipEntry = v3;
        if (zipEntry == null) {
            return null;
        }
        ZipEntry entry = zipEntry;
        return this.zipFile.getInputStream(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String resourceContent(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        InputStream stream = this.tryGetResourceAsStream(fileName);
        if (stream == null) {
            throw (Throwable)new IllegalStateException("Can't find necessary '" + fileName + "' resource in zip file");
        }
        Closeable closeable = stream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object = closeable;
        int n = 0;
        object = new InputStreamReader((InputStream)object, charset);
        n = 8192;
        boolean bl2 = false;
        closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl4 = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    public ZipModelMetadataReader(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        this.zipFile = zipFile;
    }
}

