/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class XPathParser
implements PsiParser {
    private static final boolean DBG_MODE = Boolean.getBoolean(XPathParser.class.getName() + ".debug") || ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            XPathParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            XPathParser.$$$reportNull$$$0(1);
        }
        builder.setDebugMode(DBG_MODE);
        PsiBuilder.Marker rootMarker = builder.mark();
        if (!builder.eof()) {
            boolean avt = false;
            if (builder.getTokenType() == XPathTokenTypes.LBRACE) {
                builder.advanceLexer();
                avt = true;
            }
            if (!this.parseExpr(builder)) {
                builder.error(XPathBundle.message("parsing.error.xpath.expression.expected", new Object[0]));
            }
            if (avt) {
                XPathParser.checkMatches(builder, XPathTokenTypes.RBRACE, XPathBundle.message("parsing.error.closing.brace.expected", new Object[0]));
            }
            XPathParser.consumeBadTokens(builder, TokenSet.EMPTY);
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            XPathParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    protected boolean parsePrimaryExpr(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == XPathTokenTypes.DOLLAR) {
            XPathParser.parseVariable(builder);
        } else if (tokenType == XPathTokenTypes.LPAREN) {
            this.parseParenthesizedExpr(builder);
        } else if (tokenType == XPathTokenTypes.STRING_LITERAL) {
            XPathParser.parseLiteral(builder);
        } else if (tokenType == XPathTokenTypes.NUMBER) {
            XPathParser.parseNumber(builder);
        } else if (tokenType == XPathTokenTypes.FUNCTION_NAME || tokenType == XPathTokenTypes.EXT_PREFIX) {
            this.parseFunction(builder);
        } else {
            return false;
        }
        return true;
    }

    private void parseParenthesizedExpr(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (!this.parseParenExpr(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        XPathParser.checkMatches(builder, XPathTokenTypes.RPAREN, XPathBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
        marker.done(XPathElementTypes.PARENTHESIZED_EXPR);
    }

    protected boolean parseParenExpr(PsiBuilder builder) {
        return this.parseExpr(builder);
    }

    protected boolean parseFunction(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == XPathTokenTypes.FUNCTION_NAME || tokenType == XPathTokenTypes.EXT_PREFIX) {
            PsiBuilder.Marker func = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() == XPathTokenTypes.COL) {
                builder.advanceLexer();
                XPathParser.checkMatches(builder, XPathTokenTypes.FUNCTION_NAME, XPathBundle.message("parsing.error.function.name.expected", new Object[0]));
            }
            this.parseArgumentList(builder);
            func.done(XPathElementTypes.FUNCTION_CALL);
            return true;
        }
        return false;
    }

    protected void parseArgumentList(PsiBuilder builder) {
        XPathParser.checkMatches(builder, XPathTokenTypes.LPAREN, XPathBundle.message("parsing.error.opening.parenthesis.expected", new Object[0]));
        if (builder.getTokenType() != XPathTokenTypes.RPAREN && !this.parseArgument(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        while (builder.getTokenType() == XPathTokenTypes.COMMA) {
            builder.advanceLexer();
            if (this.parseArgument(builder)) continue;
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        XPathParser.checkMatches(builder, XPathTokenTypes.RPAREN, XPathBundle.message("parsing.error.closing.parenthesis.expected", new Object[0]));
    }

    protected boolean parseArgument(PsiBuilder builder) {
        return this.parseExpr(builder);
    }

    private static void parseNumber(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(XPathElementTypes.NUMBER);
    }

    private static void parseLiteral(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(XPathElementTypes.STRING);
    }

    private static void parseVariable(PsiBuilder builder) {
        XPathParser.parseVariable(builder, XPathElementTypes.VARIABLE_REFERENCE);
    }

    protected static void parseVariable(PsiBuilder builder, IElementType elementType) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == XPathTokenTypes.VARIABLE_PREFIX) {
            builder.advanceLexer();
            XPathParser.checkMatches(builder, XPathTokenTypes.COL, XPathBundle.message("parsing.error.colon.expected", new Object[0]));
        }
        XPathParser.checkMatches(builder, XPathTokenTypes.VARIABLE_NAME, XPathBundle.message("parsing.error.variable.expected", new Object[0]));
        marker.done(elementType);
    }

    protected boolean parseExpr(PsiBuilder builder) {
        return this.parseOrExpr(builder);
    }

    protected boolean parseOrExpr(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseAndExpression(builder)) {
            expr.drop();
            return false;
        }
        while (builder.getTokenType() == XPathTokenTypes.OR) {
            XPathParser.makeToken(builder);
            if (!this.parseAndExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseAndExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseEqualityExpression(builder)) {
            expr.drop();
            return false;
        }
        while (builder.getTokenType() == XPathTokenTypes.AND) {
            XPathParser.makeToken(builder);
            if (!this.parseEqualityExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseEqualityExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseRelationalExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.EQUALITY_OPS.contains(builder.getTokenType())) {
            XPathParser.makeToken(builder);
            if (!this.parseRelationalExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseRelationalExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseAdditiveExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.REL_OPS.contains(builder.getTokenType())) {
            XPathParser.makeToken(builder);
            if (!this.parseAdditiveExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseAdditiveExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseMultiplicativeExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.ADD_OPS.contains(builder.getTokenType())) {
            XPathParser.makeToken(builder);
            if (!this.parseMultiplicativeExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseMultiplicativeExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parseUnaryExpression(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.MUL_OPS.contains(builder.getTokenType())) {
            XPathParser.makeToken(builder);
            if (!this.parseUnaryExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parseUnaryExpression(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.MINUS) {
            PsiBuilder.Marker expr = builder.mark();
            builder.advanceLexer();
            if (!this.parseUnionExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        return this.parseUnionExpression(builder);
    }

    protected boolean parseUnionExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parsePathExpression(builder)) {
            expr.drop();
            return false;
        }
        while (this.unionOps().contains(builder.getTokenType())) {
            XPathParser.makeToken(builder);
            if (!this.parsePathExpression(builder)) {
                builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
            }
            expr.done(XPathElementTypes.BINARY_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected TokenSet unionOps() {
        return TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.UNION});
    }

    protected boolean parsePathExpression(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseLocationPath(builder, false, new PsiBuilder.Marker[0]) && !this.parseAbsoluteLocationPath(builder)) {
            PsiBuilder.Marker m2 = builder.mark();
            if (!this.parseFilterExpression(builder)) {
                m2.drop();
                marker.drop();
                return false;
            }
            if (XPathTokenTypes.PATH_OPS.contains(builder.getTokenType())) {
                XPathParser.makeToken(builder);
                if (!this.parseLocationPath(builder, false, m2)) {
                    builder.error(XPathBundle.message("parsing.error.location.path.expected", new Object[0]));
                }
                marker.done(XPathElementTypes.LOCATION_PATH);
            } else {
                m2.drop();
                marker.drop();
            }
        } else {
            marker.done(XPathElementTypes.LOCATION_PATH);
        }
        return true;
    }

    protected static void makeToken(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.done(tokenType);
    }

    private boolean parseLocationPath(PsiBuilder builder, boolean isAbsolute, PsiBuilder.Marker ... m) {
        PsiBuilder.Marker marker;
        assert (m.length <= 1);
        PsiBuilder.Marker marker2 = marker = m.length == 1 ? m[0] : builder.mark();
        if (isAbsolute) {
            XPathParser.makeToken(builder);
            if (builder.getTokenType() == null) {
                marker.done(XPathElementTypes.STEP);
                return true;
            }
        }
        if (!this.parseStep(builder)) {
            marker.drop();
            return false;
        }
        marker.done(XPathElementTypes.STEP);
        marker = marker.precede();
        if (XPathTokenTypes.PATH_OPS.contains(builder.getTokenType())) {
            do {
                XPathParser.makeToken(builder);
                if (!this.parseStep(builder)) {
                    builder.error(XPathBundle.message("parsing.error.location.step.expected", new Object[0]));
                }
                marker.done(XPathElementTypes.STEP);
                marker = marker.precede();
            } while (XPathTokenTypes.PATH_OPS.contains(builder.getTokenType()));
        }
        marker.drop();
        return true;
    }

    private boolean parseStep(PsiBuilder builder) {
        if (this.parseAxisSpecifier(builder)) {
            if (!this.parseNodeTest(builder)) {
                builder.error(XPathBundle.message("parsing.error.node.test.expected", new Object[0]));
            }
            while (builder.getTokenType() == XPathTokenTypes.LBRACKET) {
                this.parsePredicate(builder);
            }
            return true;
        }
        return XPathParser.parseAbbreviatedStep(builder);
    }

    private static boolean parseAbbreviatedStep(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.DOT || builder.getTokenType() == XPathTokenTypes.DOTDOT) {
            XPathParser.makeToken(builder);
            return true;
        }
        return false;
    }

    protected boolean parseNodeTest(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseNameTest(builder) && !this.parseNodeType(builder)) {
            marker.drop();
            return false;
        }
        marker.done(XPathElementTypes.NODE_TEST);
        return true;
    }

    protected boolean parseNodeType(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.NODE_TYPE) {
            PsiBuilder.Marker m = builder.mark();
            builder.advanceLexer();
            this.parseArgumentList(builder);
            m.done(XPathElementTypes.NODE_TYPE);
            return true;
        }
        return false;
    }

    protected boolean parseNameTest(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.STAR) {
            return this.parseWildcard(builder);
        }
        if (builder.getTokenType() == XPathTokenTypes.NCNAME) {
            builder.advanceLexer();
            if (builder.getTokenType() == XPathTokenTypes.COL) {
                builder.advanceLexer();
                if (builder.getTokenType() != XPathTokenTypes.STAR) {
                    if (builder.getTokenType() != XPathTokenTypes.NCNAME) {
                        builder.error(XPathBundle.message("parsing.error.star.or.ncname.expected", new Object[0]));
                    } else {
                        builder.advanceLexer();
                    }
                } else {
                    builder.advanceLexer();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean parseWildcard(PsiBuilder builder) {
        builder.advanceLexer();
        return true;
    }

    private boolean parseAxisSpecifier(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType tokenType = builder.getTokenType();
        if (XPathTokenTypes.AXIS.contains(tokenType)) {
            builder.advanceLexer();
            XPathParser.checkMatches(builder, XPathTokenTypes.COLCOL, XPathBundle.message("parsing.error.double.colon.expected", new Object[0]));
        } else if (tokenType == XPathTokenTypes.AT) {
            builder.advanceLexer();
        } else {
            if (tokenType == XPathTokenTypes.DOT || tokenType == XPathTokenTypes.DOTDOT) {
                marker.drop();
                return false;
            }
            PsiBuilder.Marker m = builder.mark();
            boolean b = this.parseNodeTest(builder);
            m.rollbackTo();
            if (!b) {
                marker.drop();
                return false;
            }
        }
        marker.done(XPathElementTypes.AXIS_SPECIFIER);
        return true;
    }

    private boolean parseFilterExpression(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        if (!this.parsePrimaryExpr(builder)) {
            expr.drop();
            return false;
        }
        while (XPathTokenTypes.LBRACKET == builder.getTokenType()) {
            this.parsePredicate(builder);
            expr.done(XPathElementTypes.FILTER_EXPRESSION);
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    protected boolean parsePredicate(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() != XPathTokenTypes.LBRACKET) {
            marker.drop();
            return false;
        }
        builder.advanceLexer();
        if (!this.parseExpr(builder)) {
            builder.error(XPathBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        XPathParser.checkMatches(builder, XPathTokenTypes.RBRACKET, XPathBundle.message("parsing.error.closing.bracket.expected", new Object[0]));
        marker.done(XPathElementTypes.PREDICATE);
        return true;
    }

    private boolean parseAbsoluteLocationPath(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.PATH) {
            this.parseLocationPath(builder, true, new PsiBuilder.Marker[0]);
            return true;
        }
        return this.parseAbbreviatedAbsoluteLocationPath(builder);
    }

    private boolean parseAbbreviatedAbsoluteLocationPath(PsiBuilder builder) {
        if (builder.getTokenType() == XPathTokenTypes.ANY_PATH) {
            if (!this.parseLocationPath(builder, true, new PsiBuilder.Marker[0])) {
                builder.error(XPathBundle.message("parsing.error.location.path.expected", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static void consumeBadTokens(PsiBuilder builder, TokenSet nextAccepted) {
        if (nextAccepted.getTypes().length == 0 && builder.eof()) {
            return;
        }
        if (!nextAccepted.contains(builder.getTokenType())) {
            builder.error(XPathBundle.message("parsing.error.unexpected.token", new Object[0]));
            do {
                if (builder.eof()) {
                    builder.error(XPathBundle.message("parsing.error.unexpected.end.file", new Object[0]));
                    break;
                }
                builder.advanceLexer();
            } while (!nextAccepted.contains(builder.getTokenType()));
        }
    }

    protected static void checkMatches(PsiBuilder builder, IElementType token, @NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            XPathParser.$$$reportNull$$$0(3);
        }
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
        } else {
            builder.error(message);
        }
    }

    protected static void checkMatches(PsiBuilder builder, TokenSet tokens, @NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            XPathParser.$$$reportNull$$$0(4);
        }
        if (tokens.contains(builder.getTokenType())) {
            builder.advanceLexer();
        } else {
            builder.error(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/XPathParser";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/XPathParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

