/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

public abstract class BaseVariableAnalyzer {
    protected final Instruction[] myInstructions;
    protected final MultiMap<Instruction, Instruction> myForwardMap;
    protected final MultiMap<Instruction, Instruction> myBackwardMap;
    protected final DfaValueFactory myFactory;

    public BaseVariableAnalyzer(ControlFlow flow) {
        this.myFactory = flow.getFactory();
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private List<Instruction> getSuccessors(Instruction ins) {
        return IntStreamEx.of((int[])ins.getSuccessorIndexes()).elements((Object[])this.myInstructions).toList();
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next : this.myForwardMap.get((Object)instruction)) {
                result.putValue((Object)next, (Object)instruction);
            }
        }
        return result;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next)) {
                        result.putValue((Object)instruction, (Object)next);
                        continue block1;
                    }
                    if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next = this.myInstructions[next.getIndex() + 1];
                }
            }
        }
        return result;
    }

    protected abstract boolean isInterestingInstruction(Instruction var1);

    protected boolean runDfa(boolean forward, BiFunction<? super Instruction, ? super BitSet, ? extends BitSet> handleState) {
        List entryPoints = forward ? List.of(this.myInstructions[0]) : (List)((StreamEx)StreamEx.of((Object[])this.myInstructions).select(ControlTransferInstruction.class).filter(cti -> cti.getTransfer().getTarget().getPossibleTargets().length == 0)).collect(Collectors.toList());
        ArrayDeque<InstructionState> queue = new ArrayDeque<InstructionState>(10);
        for (Instruction i : entryPoints) {
            queue.addLast(new InstructionState(i, new BitSet()));
        }
        int limit = this.myForwardMap.size() * 100;
        HashMap<BitSet, IntSet> processed2 = new HashMap<BitSet, IntSet>();
        int steps = 0;
        while (!queue.isEmpty()) {
            if (steps > limit) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)((Object)queue.removeFirst());
            Instruction instruction = (Instruction)state.first;
            Collection nextInstructions = forward ? this.myForwardMap.get((Object)instruction) : this.myBackwardMap.get((Object)instruction);
            BitSet nextVars = handleState.apply(instruction, (BitSet)state.second);
            for (Instruction next : nextInstructions) {
                int index;
                IntSet instructionSet = processed2.computeIfAbsent(nextVars, k -> new IntOpenHashSet());
                if (instructionSet.contains(index = next.getIndex() + 1)) continue;
                instructionSet.add(index);
                queue.addLast(new InstructionState(next, nextVars));
                ++steps;
            }
        }
        return true;
    }

    private static class InstructionState
    extends Pair<Instruction, BitSet> {
        InstructionState(Instruction first, BitSet second) {
            super((Object)first, (Object)second);
        }
    }
}

