/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DfaRelation
extends DfaCondition {
    @NotNull
    private final DfaValue myLeftOperand;
    @NotNull
    private final DfaValue myRightOperand;
    @NotNull
    private final RelationType myRelation;

    @Override
    @NotNull
    public DfaRelation negate() {
        return new DfaRelation(this.myLeftOperand, this.myRightOperand, this.myRelation.getNegated());
    }

    private DfaRelation(@NotNull DfaValue leftOperand, @NotNull DfaValue rightOperand, @NotNull RelationType relationType) {
        if (leftOperand == null) {
            DfaRelation.$$$reportNull$$$0(0);
        }
        if (rightOperand == null) {
            DfaRelation.$$$reportNull$$$0(1);
        }
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(2);
        }
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
        this.myRelation = relationType;
    }

    @NotNull
    public DfaValue getLeftOperand() {
        DfaValue dfaValue = this.myLeftOperand;
        if (dfaValue == null) {
            DfaRelation.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @NotNull
    public DfaValue getRightOperand() {
        DfaValue dfaValue = this.myRightOperand;
        if (dfaValue == null) {
            DfaRelation.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    @Override
    public boolean isUnknown() {
        return this.myLeftOperand instanceof DfaTypeValue && this.myRightOperand instanceof DfaTypeValue;
    }

    public static DfaRelation createRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaRelation.$$$reportNull$$$0(5);
        }
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(6);
        }
        if (dfaRight == null) {
            DfaRelation.$$$reportNull$$$0(7);
        }
        if ((dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaWrappedValue || dfaLeft instanceof DfaBinOpValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaWrappedValue || dfaRight instanceof DfaBinOpValue) && (!(dfaLeft instanceof DfaVariableValue) && !(dfaLeft instanceof DfaWrappedValue) && !(dfaLeft instanceof DfaBinOpValue) || dfaRight instanceof DfaBinOpValue && !(dfaLeft instanceof DfaBinOpValue))) {
            RelationType flipped = relationType.getFlipped();
            return flipped == null ? null : new DfaRelation(dfaRight, dfaLeft, flipped);
        }
        return new DfaRelation(dfaLeft, dfaRight, relationType);
    }

    public boolean isEquality() {
        return this.myRelation == RelationType.EQ;
    }

    public boolean isNonEquality() {
        return this.myRelation == RelationType.NE || this.myRelation == RelationType.GT || this.myRelation == RelationType.LT;
    }

    @NotNull
    public RelationType getRelation() {
        RelationType relationType = this.myRelation;
        if (relationType == null) {
            DfaRelation.$$$reportNull$$$0(8);
        }
        return relationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfaRelation relation = (DfaRelation)o;
        return this.myLeftOperand == relation.myLeftOperand && this.myRightOperand == relation.myRightOperand && this.myRelation == relation.myRelation;
    }

    public int hashCode() {
        int result = 31 + this.myLeftOperand.hashCode();
        result = 31 * result + this.myRightOperand.hashCode();
        result = 31 * result + this.myRelation.hashCode();
        return result;
    }

    @NonNls
    public String toString() {
        return this.myLeftOperand + " " + this.myRelation + " " + this.myRightOperand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaRelation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaRelation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftOperand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightOperand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRelation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

