/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public class ListEditForm {
    JPanel contentPanel;
    ListTable table;

    public ListEditForm(@NlsContexts.ColumnName String title, List<String> stringList) {
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.contentPanel = this.setupActions(ToolbarDecorator.createDecorator(this.table)).createPanel();
    }

    public ListEditForm(@NlsContexts.ColumnName String title, @NlsContexts.Label String label, List<String> stringList) {
        this.table = new ListTable(new ListWrappingTableModel(stringList, title));
        this.table.setTableHeader(null);
        this.contentPanel = this.setupActions(ToolbarDecorator.createDecorator(this.table)).setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel();
        this.contentPanel = UI.PanelFactory.panel(this.contentPanel).withLabel(label).moveLabelOnTop().resizeY(true).createPanel();
        this.contentPanel.setMinimumSize(InspectionOptionsPanel.getMinimumListSize());
    }

    @NotNull
    private ToolbarDecorator setupActions(@NotNull ToolbarDecorator decorator) {
        if (decorator == null) {
            ListEditForm.$$$reportNull$$$0(0);
        }
        ToolbarDecorator toolbarDecorator = decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListWrappingTableModel tableModel = ListEditForm.this.table.getModel();
                tableModel.addRow();
                EventQueue.invokeLater(() -> {
                    int lastRowIndex = tableModel.getRowCount() - 1;
                    Rectangle rectangle = ListEditForm.this.table.getCellRect(lastRowIndex, 0, true);
                    ListEditForm.this.table.scrollRectToVisible(rectangle);
                    ListEditForm.this.table.editCellAt(lastRowIndex, 0);
                    ListSelectionModel selectionModel = ListEditForm.this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(lastRowIndex, lastRowIndex);
                    TableCellEditor editor = ListEditForm.this.table.getCellEditor();
                    Component component = editor.getTableCellEditorComponent(ListEditForm.this.table, null, true, lastRowIndex, 0);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component, true));
                });
            }
        }).setRemoveAction(button -> TableUtil.removeSelectedItems((JTable)this.table)).disableUpDownActions();
        if (toolbarDecorator == null) {
            ListEditForm.$$$reportNull$$$0(1);
        }
        return toolbarDecorator;
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/ListEditForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/ListEditForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setupActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupActions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

