/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsContexts;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class WizardInputField<T extends JComponent> {
    private final String myId;
    private final String myDefaultValue;

    protected WizardInputField(String id, String defaultValue) {
        this.myId = id;
        this.myDefaultValue = defaultValue;
    }

    public String getId() {
        return this.myId;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @NlsContexts.Label
    public abstract String getLabel();

    public abstract T getComponent();

    public abstract String getValue();

    public Map<String, String> getValues() {
        return Collections.singletonMap(this.getId(), this.getValue());
    }

    public boolean validate() throws ConfigurationException {
        return true;
    }

    @Nullable
    public static ProjectTemplateParameterFactory getFactoryById(@NotNull String id) {
        if (id == null) {
            WizardInputField.$$$reportNull$$$0(0);
        }
        for (ProjectTemplateParameterFactory extension : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
            if (!extension.getParameterId().equals(id)) continue;
            return extension;
        }
        return null;
    }

    public void addToSettings(SettingsStep settingsStep) {
        T component = this.getComponent();
        if (component != null) {
            settingsStep.addSettingsField(this.getLabel(), (JComponent)component);
        }
    }

    public boolean acceptFile(File file) {
        return true;
    }

    @TestOnly
    public void setValue(String value2) {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/util/projectWizard/WizardInputField", "getFactoryById"));
    }
}

