/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionUtil {
    private static final Logger LOG = Logger.getInstance(ActionUtil.class);
    public static final Key<Boolean> ALLOW_PlAIN_LETTER_SHORTCUTS = Key.create((String)"ALLOW_PlAIN_LETTER_SHORTCUTS");
    private static final Key<Boolean> WAS_ENABLED_BEFORE_DUMB = Key.create((String)"WAS_ENABLED_BEFORE_DUMB");
    @ApiStatus.Internal
    public static final Key<Boolean> WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = Key.create((String)"WOULD_BE_ENABLED_IF_NOT_DUMB_MODE");
    private static final Key<Boolean> WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = Key.create((String)"WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE");

    private ActionUtil() {
    }

    public static void showDumbModeWarning(@Nullable Project project, AnActionEvent ... events) {
        if (events == null) {
            ActionUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            String s = event.getPresentation().getText();
            if (!StringUtil.isNotEmpty((String)s)) continue;
            actionNames.add(s);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Showing dumb mode warning for " + Arrays.asList(events), new Throwable());
        }
        if (project == null) {
            return;
        }
        DumbService.getInstance(project).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    @NlsContexts.PopupContent
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        if (actionNames == null) {
            ActionUtil.$$$reportNull$$$0(1);
        }
        Object message = actionNames.isEmpty() ? ActionUtil.getUnavailableMessage("This action", false) : (actionNames.size() == 1 ? ActionUtil.getUnavailableMessage("'" + actionNames.get(0) + "'", false) : ActionUtil.getUnavailableMessage("None of the following actions", true) + ": " + StringUtil.join(actionNames, (String)", "));
        String string = message;
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsContexts.PopupContent
    public static String getUnavailableMessage(@NotNull String action2, boolean plural) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(3);
        }
        if (plural) {
            String string = IdeBundle.message("popup.content.actions.not.available.while.updating.indices", action2, ApplicationNamesInfo.getInstance().getProductName());
            if (string == null) {
                ActionUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = IdeBundle.message("popup.content.action.not.available.while.updating.indices", action2, ApplicationNamesInfo.getInstance().getProductName());
        if (string == null) {
            ActionUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action2, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(6);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(7);
        }
        Presentation presentation = e.getPresentation();
        if (LightEdit.owns(e.getProject()) && !LightEdit.isActionCompatible(action2)) {
            presentation.setEnabledAndVisible(false);
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, false);
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, false);
            return false;
        }
        Boolean wasEnabledBefore = presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean allowed = !(dumbMode && !action2.isDumbAware() || Registry.is((String)"actionSystem.honor.modal.context") && isInModalContext && !action2.isEnabledInModalContext());
        action2.applyTextOverride(e);
        try {
            ThrowableRunnable runnable = () -> {
                e.setInjectedContext(action2.isInInjectedContext());
                if (beforeActionPerformed) {
                    action2.beforeActionPerformedUpdate(e);
                } else {
                    action2.update(e);
                }
                if (!e.getPresentation().isEnabled() && e.isInInjectedContext()) {
                    e.setInjectedContext(false);
                    if (beforeActionPerformed) {
                        action2.beforeActionPerformedUpdate(e);
                    } else {
                        action2.update(e);
                    }
                }
            };
            boolean isLikeUpdate = !beforeActionPerformed && Registry.is((String)"actionSystem.update.actions.async");
            try (AccessToken ignore = SlowOperations.allowSlowOperations(isLikeUpdate ? "action.update" : "action.perform");){
                runnable.run();
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, !allowed && presentation.isEnabled());
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, !allowed && presentation.isVisible());
        }
        catch (IndexNotReadyException e1) {
            if (!allowed) {
                boolean bl = true;
                return bl;
            }
            throw e1;
        }
        finally {
            if (!allowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean performDumbAwareUpdate(@NotNull AnAction action2, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(9);
        }
        return ActionUtil.performDumbAwareUpdate(false, action2, e, beforeActionPerformed);
    }

    public static <T> T underModalProgress(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        if (project == null) {
            ActionUtil.$$$reportNull$$$0(10);
        }
        if (progressTitle == null) {
            ActionUtil.$$$reportNull$$$0(11);
        }
        if (computable == null) {
            ActionUtil.$$$reportNull$$$0(12);
        }
        DumbService dumbService = DumbService.getInstance(project);
        boolean useAlternativeResolve = dumbService.isAlternativeResolveEnabled();
        ThrowableComputable inReadAction = () -> ApplicationManager.getApplication().runReadAction(computable);
        ThrowableComputable prioritizedRunnable = () -> ProgressManager.getInstance().computePrioritized(inReadAction);
        ThrowableComputable process = useAlternativeResolve ? () -> dumbService.computeWithAlternativeResolveEnabled(prioritizedRunnable) : prioritizedRunnable;
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(process, progressTitle, true, project);
    }

    public static boolean isDumbMode(@Nullable Project project) {
        if (project != null) {
            return DumbService.getInstance(project).isDumb();
        }
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(openProject).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(@NotNull AnAction action2, @NotNull AnActionEvent e, boolean visibilityMatters) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(14);
        }
        ActionUtil.performDumbAwareUpdate(false, action2, e, true);
        Project project = e.getProject();
        if (project != null && DumbService.getInstance(project).isDumb() && !action2.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(project, e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    @Deprecated
    public static void performActionDumbAwareWithCallbacks(@NotNull AnAction action2, @NotNull AnActionEvent e, @NotNull DataContext context) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(15);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            ActionUtil.$$$reportNull$$$0(17);
        }
        LOG.assertTrue(e.getDataContext() == context, (Object)"event context does not match the argument");
        ActionUtil.performActionDumbAwareWithCallbacks(action2, e);
    }

    public static void performActionDumbAwareWithCallbacks(@NotNull AnAction action2, @NotNull AnActionEvent e) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(18);
        }
        if (e == null) {
            ActionUtil.$$$reportNull$$$0(19);
        }
        ActionUtil.performDumbAwareWithCallbacks(action2, e, () -> action2.actionPerformed(e));
    }

    public static void performDumbAwareWithCallbacks(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull Runnable performRunnable) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(20);
        }
        if (event == null) {
            ActionUtil.$$$reportNull$$$0(21);
        }
        if (performRunnable == null) {
            ActionUtil.$$$reportNull$$$0(22);
        }
        Project project = event.getProject();
        IndexNotReadyException indexError = null;
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        manager.fireBeforeActionPerformed(action2, event);
        Component component = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component != null && !UIUtil.isShowing((Component)component) && !"TouchBarGeneral".equals(event.getPlace())) {
            String id = StringUtil.notNullize((String)event.getActionManager().getId(action2), (String)action2.getClass().getName());
            LOG.warn("Action is not performed because target component is not showing: action=" + id + ", component=" + component.getClass().getName());
            manager.fireAfterActionPerformed(action2, event, AnActionResult.IGNORED);
            return;
        }
        AnActionResult result = null;
        try (AccessToken ignore = SlowOperations.allowSlowOperations("action.perform");){
            performRunnable.run();
            result = AnActionResult.PERFORMED;
        }
        catch (IndexNotReadyException ex) {
            indexError = ex;
            result = AnActionResult.failed(ex);
        }
        catch (Error | RuntimeException ex) {
            result = AnActionResult.failed(ex);
            throw ex;
        }
        finally {
            if (result == null) {
                result = AnActionResult.failed(new Throwable());
            }
            manager.fireAfterActionPerformed(action2, event, result);
        }
        if (indexError != null) {
            LOG.info((Throwable)indexError);
            ActionUtil.showDumbModeWarning(project, event);
        }
    }

    @Deprecated
    public static void performActionDumbAware(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(23);
        }
        if (event == null) {
            ActionUtil.$$$reportNull$$$0(24);
        }
        Project project = event.getProject();
        try {
            action2.actionPerformed(event);
        }
        catch (IndexNotReadyException ex) {
            LOG.info((Throwable)ex);
            ActionUtil.showDumbModeWarning(project, event);
        }
    }

    @NotNull
    public static AnActionEvent createEmptyEvent() {
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext("unknown", null, dataId -> null);
        if (anActionEvent == null) {
            ActionUtil.$$$reportNull$$$0(25);
        }
        return anActionEvent;
    }

    public static void sortAlphabetically(@NotNull List<? extends AnAction> list) {
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(26);
        }
        list.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplateText()), (Comparable)((Object)o2.getTemplateText())));
    }

    public static void moveActionTo(@NotNull List<AnAction> list, @NotNull String actionText, @NotNull String targetActionText, boolean before) {
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(27);
        }
        if (actionText == null) {
            ActionUtil.$$$reportNull$$$0(28);
        }
        if (targetActionText == null) {
            ActionUtil.$$$reportNull$$$0(29);
        }
        if (Objects.equals(actionText, targetActionText)) {
            return;
        }
        int actionIndex = -1;
        int targetIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            AnAction action2 = list.get(i);
            if (actionIndex == -1 && Objects.equals(actionText, action2.getTemplateText())) {
                actionIndex = i;
            }
            if (targetIndex == -1 && Objects.equals(targetActionText, action2.getTemplateText())) {
                targetIndex = i;
            }
            if (actionIndex == -1 || targetIndex == -1) continue;
            if (actionIndex < targetIndex) {
                --targetIndex;
            }
            AnAction anAction = list.remove(actionIndex);
            list.add(before ? targetIndex : targetIndex + 1, anAction);
            return;
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(30);
        }
        List list = ContainerUtil.notNullize((List)((List)ComponentUtil.getClientProperty((JComponent)component, AnAction.ACTIONS_KEY)));
        if (list == null) {
            ActionUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    public static void clearActions(@NotNull JComponent component) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(32);
        }
        ComponentUtil.putClientProperty((JComponent)component, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        if (to == null) {
            ActionUtil.$$$reportNull$$$0(33);
        }
        if (from == null) {
            ActionUtil.$$$reportNull$$$0(34);
        }
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component, @NotNull ActionListener action2, @NotNull ShortcutSet shortcuts) {
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(35);
        }
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(36);
        }
        if (shortcuts == null) {
            ActionUtil.$$$reportNull$$$0(37);
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component.registerKeyboardAction(action2, first, 2);
        }
    }

    public static boolean recursiveContainsAction(@NotNull ActionGroup group, @NotNull AnAction action2) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(38);
        }
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(39);
        }
        return ActionUtil.anyActionFromGroupMatches(group, true, Predicate.isEqual(action2));
    }

    public static boolean anyActionFromGroupMatches(@NotNull ActionGroup group, boolean processPopupSubGroups, @NotNull Predicate<? super AnAction> condition) {
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(40);
        }
        if (condition == null) {
            ActionUtil.$$$reportNull$$$0(41);
        }
        for (AnAction child : group.getChildren(null)) {
            if (condition.test(child)) {
                return true;
            }
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (!processPopupSubGroups && childGroup.isPopup() || !ActionUtil.anyActionFromGroupMatches(childGroup, processPopupSubGroups, condition)) continue;
            return true;
        }
        return false;
    }

    public static AnAction copyFrom(@NotNull AnAction action2, @NotNull @NonNls String actionId) {
        AnAction from;
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(42);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(43);
        }
        if ((from = ActionManager.getInstance().getAction(actionId)) != null) {
            action2.copyFrom(from);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action2, actionId);
        return action2;
    }

    public static AnAction mergeFrom(@NotNull AnAction action2, @NotNull String actionId) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(44);
        }
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(45);
        }
        AnAction a1 = action2;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getIcon(), (Object)p2.getIcon()));
        p1.setDisabledIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getDisabledIcon(), (Object)p2.getDisabledIcon()));
        p1.setSelectedIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getSelectedIcon(), (Object)p2.getSelectedIcon()));
        p1.setHoveredIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()));
        if (StringUtil.isEmpty((String)p1.getText())) {
            p1.setTextWithMnemonic(p2.getTextWithPossibleMnemonic());
        }
        p1.setDescription((String)ObjectUtils.chooseNotNull((Object)p1.getDescription(), (Object)p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action2, actionId);
        return a1;
    }

    public static void invokeAction(@NotNull AnAction action2, @NotNull Component component, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(46);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(47);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(48);
        }
        ActionUtil.invokeAction(action2, DataManager.getInstance().getDataContext(component), place, inputEvent, onDone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAction(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        Presentation presentation;
        AnActionEvent event;
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(49);
        }
        if (dataContext == null) {
            ActionUtil.$$$reportNull$$$0(50);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(51);
        }
        if (ActionUtil.lastUpdateAndCheckDumb(action2, event = new AnActionEvent(inputEvent, dataContext, place, presentation = action2.getTemplatePresentation().clone(), ActionManager.getInstance(), 0), true)) {
            try {
                ActionUtil.performActionDumbAwareWithCallbacks(action2, event);
            }
            finally {
                if (onDone != null) {
                    onDone.run();
                }
            }
        }
    }

    @NotNull
    public static ActionListener createActionListener(@NotNull String actionId, @NotNull Component component, @NotNull String place) {
        if (actionId == null) {
            ActionUtil.$$$reportNull$$$0(52);
        }
        if (component == null) {
            ActionUtil.$$$reportNull$$$0(53);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(54);
        }
        ActionListener actionListener = e -> {
            AnAction action2 = ActionUtil.getAction(actionId);
            if (action2 == null) {
                return;
            }
            ActionUtil.invokeAction(action2, component, place, null, null);
        };
        if (actionListener == null) {
            ActionUtil.$$$reportNull$$$0(55);
        }
        return actionListener;
    }

    @Nullable
    public static ShortcutSet getMnemonicAsShortcut(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionUtil.$$$reportNull$$$0(56);
        }
        return KeymapUtil.getMnemonicAsShortcut(action2.getTemplatePresentation().getMnemonic());
    }

    @ApiStatus.Experimental
    @NotNull
    public static ShortcutSet getShortcutSet(@NotNull @NonNls String id) {
        AnAction action2;
        if (id == null) {
            ActionUtil.$$$reportNull$$$0(57);
        }
        ShortcutSet shortcutSet = (action2 = ActionUtil.getAction(id)) == null ? CustomShortcutSet.EMPTY : action2.getShortcutSet();
        if (shortcutSet == null) {
            ActionUtil.$$$reportNull$$$0(58);
        }
        return shortcutSet;
    }

    @ApiStatus.Experimental
    @Nullable
    public static AnAction getAction(@NotNull @NonNls String id) {
        AnAction action2;
        if (id == null) {
            ActionUtil.$$$reportNull$$$0(59);
        }
        if ((action2 = ActionManager.getInstance().getAction(id)) == null) {
            LOG.warn("Can not find action by id " + id);
        }
        return action2;
    }

    @ApiStatus.Experimental
    @Nullable
    public static ActionGroup getActionGroup(@NotNull @NonNls String id) {
        AnAction action2;
        if (id == null) {
            ActionUtil.$$$reportNull$$$0(60);
        }
        if ((action2 = ActionUtil.getAction(id)) instanceof ActionGroup) {
            return (ActionGroup)action2;
        }
        return action2 == null ? null : new DefaultActionGroup(Collections.singletonList(action2));
    }

    @ApiStatus.Experimental
    @Nullable
    public static ActionGroup getActionGroup(String ... ids) {
        if (ids == null) {
            ActionUtil.$$$reportNull$$$0(61);
        }
        if (ids.length == 1) {
            return ActionUtil.getActionGroup(ids[0]);
        }
        List actions = ContainerUtil.mapNotNull((Object[])ids, ActionUtil::getAction);
        return actions.isEmpty() ? null : new DefaultActionGroup(actions);
    }

    @ApiStatus.Experimental
    @NotNull
    public static JComponent createToolbarComponent(@NotNull JComponent target, @NotNull @NonNls String place, @NotNull ActionGroup group, boolean horizontal) {
        if (target == null) {
            ActionUtil.$$$reportNull$$$0(62);
        }
        if (place == null) {
            ActionUtil.$$$reportNull$$$0(63);
        }
        if (group == null) {
            ActionUtil.$$$reportNull$$$0(64);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(place, group, horizontal);
        toolbar.setTargetComponent(target);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            ActionUtil.$$$reportNull$$$0(65);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 25: 
            case 31: 
            case 55: 
            case 58: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 25: 
            case 31: 
            case 55: 
            case 58: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 25: 
            case 31: 
            case 55: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 36: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performRunnable";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetActionText";
                break;
            }
            case 30: 
            case 32: 
            case 35: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 38: 
            case 40: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 43: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 48: 
            case 51: 
            case 54: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 57: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyEvent";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListener";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutSet";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeWarning";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionUnavailableMessage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 25: 
            case 31: 
            case 55: 
            case 58: 
            case 65: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performDumbAwareUpdate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "underModalProgress";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lastUpdateAndCheckDumb";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "performActionDumbAwareWithCallbacks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "performDumbAwareWithCallbacks";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "performActionDumbAware";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sortAlphabetically";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "moveActionTo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "clearActions";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyRegisteredShortcuts";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerForEveryKeyboardShortcut";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "recursiveContainsAction";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "anyActionFromGroupMatches";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mergeFrom";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createActionListener";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicAsShortcut";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutSet";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getActionGroup";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 25: 
            case 31: 
            case 55: 
            case 58: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

