/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.Property;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    @NotNull
    private final Map<ExternalSystemSourceType, String> compileOutputPaths;
    @NotNull
    private final Map<ExternalSystemSourceType, String> externalCompilerOutputPaths;
    @Nullable
    private Map<String, String> properties;
    @NotNull
    private final String id;
    @NotNull
    private final String moduleTypeId;
    @NotNull
    private final String externalConfigPath;
    @NotNull
    private final String moduleFileDirectoryPath;
    @Nullable
    private String group;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @NotNull
    private List<File> artifacts;
    private String @Nullable [] ideModuleGroup;
    @Nullable
    private String sourceCompatibility;
    @Nullable
    private String targetCompatibility;
    @Nullable
    private String sdkName;
    private boolean isSetSourceCompatibility;
    private boolean isSetTargetCompatibility;
    private boolean isSetSdkName;
    @Nullable
    private String productionModuleId;
    @NotNull
    private String moduleName;
    @Property(allowedTypes={LibraryData.class, ProjectId.class})
    @Nullable
    private ProjectCoordinate publication;
    private boolean inheritProjectCompileOutputPath;
    private boolean useExternalCompilerOutput;

    @PropertyMapping(value={"id", "owner", "moduleTypeId", "externalName", "moduleFileDirectoryPath", "externalConfigPath"})
    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String moduleTypeId, @NotNull String externalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            ModuleData.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            ModuleData.$$$reportNull$$$0(1);
        }
        if (moduleTypeId == null) {
            ModuleData.$$$reportNull$$$0(2);
        }
        if (externalName == null) {
            ModuleData.$$$reportNull$$$0(3);
        }
        if (moduleFileDirectoryPath == null) {
            ModuleData.$$$reportNull$$$0(4);
        }
        if (externalConfigPath == null) {
            ModuleData.$$$reportNull$$$0(5);
        }
        super(owner, externalName, externalName.replaceAll("(/|\\\\)", "_"));
        this.compileOutputPaths = new HashMap<ExternalSystemSourceType, String>();
        this.externalCompilerOutputPaths = new HashMap<ExternalSystemSourceType, String>();
        this.isSetSourceCompatibility = false;
        this.isSetTargetCompatibility = false;
        this.isSetSdkName = false;
        this.inheritProjectCompileOutputPath = true;
        this.id = id;
        this.moduleTypeId = moduleTypeId;
        this.externalConfigPath = externalConfigPath;
        this.artifacts = Collections.emptyList();
        this.moduleFileDirectoryPath = moduleFileDirectoryPath;
        this.moduleName = externalName;
    }

    protected ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        if (id == null) {
            ModuleData.$$$reportNull$$$0(6);
        }
        if (owner == null) {
            ModuleData.$$$reportNull$$$0(7);
        }
        if (typeId == null) {
            ModuleData.$$$reportNull$$$0(8);
        }
        if (externalName == null) {
            ModuleData.$$$reportNull$$$0(9);
        }
        if (internalName == null) {
            ModuleData.$$$reportNull$$$0(10);
        }
        if (moduleFileDirectoryPath == null) {
            ModuleData.$$$reportNull$$$0(11);
        }
        if (externalConfigPath == null) {
            ModuleData.$$$reportNull$$$0(12);
        }
        super(owner, externalName, internalName);
        this.compileOutputPaths = new HashMap<ExternalSystemSourceType, String>();
        this.externalCompilerOutputPaths = new HashMap<ExternalSystemSourceType, String>();
        this.isSetSourceCompatibility = false;
        this.isSetTargetCompatibility = false;
        this.isSetSdkName = false;
        this.inheritProjectCompileOutputPath = true;
        this.id = id;
        this.moduleTypeId = typeId;
        this.externalConfigPath = externalConfigPath;
        this.artifacts = Collections.emptyList();
        this.moduleFileDirectoryPath = moduleFileDirectoryPath;
        this.moduleName = externalName;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.id;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getModuleTypeId() {
        String string = this.moduleTypeId;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.externalConfigPath;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getModuleFileDirectoryPath() {
        String string = this.moduleFileDirectoryPath;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public String getProductionModuleId() {
        return this.productionModuleId;
    }

    public void setProductionModuleId(@Nullable String productionModuleId) {
        this.productionModuleId = productionModuleId;
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.inheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.inheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(17);
        }
        return this.useExternalCompilerOutput && this.externalCompilerOutputPaths != null ? this.externalCompilerOutputPaths.get(type) : this.compileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(18);
        }
        ModuleData.updatePath(this.compileOutputPaths, type, path2);
    }

    public void setExternalCompilerOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(19);
        }
        ModuleData.updatePath(this.externalCompilerOutputPaths, type, path2);
    }

    public void useExternalCompilerOutput(boolean useExternalCompilerOutput) {
        this.useExternalCompilerOutput = useExternalCompilerOutput;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    @Nullable
    public ProjectCoordinate getPublication() {
        return this.publication;
    }

    public void setPublication(@Nullable ProjectCoordinate publication) {
        this.publication = publication;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        List<File> list = this.artifacts;
        if (list == null) {
            ModuleData.$$$reportNull$$$0(20);
        }
        return list;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        if (artifacts == null) {
            ModuleData.$$$reportNull$$$0(21);
        }
        this.artifacts = artifacts;
    }

    public String @Nullable [] getIdeModuleGroup() {
        return this.ideModuleGroup;
    }

    public void setIdeModuleGroup(String @Nullable [] ideModuleGroup) {
        this.ideModuleGroup = ideModuleGroup;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.isSetSourceCompatibility = true;
        this.sourceCompatibility = sourceCompatibility;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.isSetTargetCompatibility = true;
        this.targetCompatibility = targetCompatibility;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public String getSdkName() {
        return this.sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void setSdkName(@Nullable String sdkName) {
        this.isSetSdkName = true;
        this.sdkName = sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetSourceCompatibility(@Nullable String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetTargetCompatibility(@Nullable String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public void internalSetSdkName(@Nullable String sdkName) {
        this.sdkName = sdkName;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetSourceCompatibility() {
        return this.isSetSourceCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetTargetCompatibility() {
        return this.isSetTargetCompatibility;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public boolean isSetSdkName() {
        return this.isSetSdkName;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public void setProperty(String key, String value2) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value2);
    }

    @NotNull
    public String getModuleName() {
        String string = this.moduleName;
        if (string == null) {
            ModuleData.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void setModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleData.$$$reportNull$$$0(23);
        }
        this.moduleName = moduleName;
    }

    @Nullable
    public String getIdeGrouping() {
        if (this.ideModuleGroup != null) {
            return StringUtil.join((String[])this.ideModuleGroup, (String)".");
        }
        return this.getInternalName();
    }

    @Nullable
    public String getIdeParentGrouping() {
        if (this.ideModuleGroup != null) {
            return StringUtil.nullize((String)StringUtil.join((String[])((String[])ArrayUtil.remove((Object[])this.ideModuleGroup, (int)(this.ideModuleGroup.length - 1))), (String)"."));
        }
        String name = this.getInternalName();
        int i = name.lastIndexOf("." + this.moduleName);
        if (i > -1) {
            return name.substring(0, i);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.externalConfigPath.equals(that.externalConfigPath)) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (!this.moduleTypeId.equals(that.moduleTypeId)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return !(this.sdkName != null ? !this.sdkName.equals(that.sdkName) : that.sdkName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.externalConfigPath.hashCode();
        result = 31 * result + this.moduleTypeId.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.sdkName != null ? this.sdkName.hashCode() : 0);
        return result;
    }

    @NlsSafe
    public String toString() {
        return this.getId();
    }

    private static void updatePath(Map<ExternalSystemSourceType, String> paths, @NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (type == null) {
            ModuleData.$$$reportNull$$$0(24);
        }
        if (paths == null) {
            return;
        }
        if (path2 == null) {
            paths.remove(type);
            return;
        }
        paths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeId";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileDirectoryPath";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalConfigPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/ModuleData";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/ModuleData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTypeId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedExternalProjectPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileDirectoryPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifacts";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCompileOutputPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setCompileOutputPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setExternalCompilerOutputPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setArtifacts";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setModuleName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updatePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

