/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public class GroupSettingsBuilder<T>
implements CompositeSettingsBuilder<T> {
    private final SettingsEditorGroup<T> myGroup;
    private JComponent myComponent;

    public GroupSettingsBuilder(SettingsEditorGroup<T> group) {
        this.myGroup = group;
    }

    @Override
    @NotNull
    public Collection<SettingsEditor<T>> getEditors() {
        ArrayList<SettingsEditor<T>> result = new ArrayList<SettingsEditor<T>>();
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        for (int i = 0; i < editors.size(); ++i) {
            result.add((SettingsEditor)editors.get(i).getSecond());
        }
        ArrayList<SettingsEditor<T>> arrayList = result;
        if (arrayList == null) {
            GroupSettingsBuilder.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public JComponent createCompoundEditor() {
        if (this.myComponent == null) {
            this.myComponent = this.doCreateComponent();
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            GroupSettingsBuilder.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private JComponent doCreateComponent() {
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        if (editors.size() == 0) {
            return new JPanel();
        }
        if (editors.size() == 1) {
            return ((SettingsEditor)editors.get(0).getSecond()).getComponent();
        }
        JBTabbedPane tabs = new JBTabbedPane();
        for (int i = 0; i < editors.size(); ++i) {
            Pair<@NlsContexts.TabTitle String, SettingsEditor<T>> pair = editors.get(i);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)((SettingsEditor)pair.getSecond()).getComponent(), "Center");
            tabs.add((String)pair.getFirst(), panel2);
        }
        tabs.putClientProperty("JTabbedPane.hasFullBorder", Boolean.TRUE);
        return tabs;
    }

    public void selectEditor(String tabName) {
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        if (this.myComponent != null && editors.size() > 1) {
            for (int i = 0; i < editors.size(); ++i) {
                Pair<String, SettingsEditor<T>> pair = editors.get(i);
                if (!StringUtil.equals((CharSequence)tabName, (CharSequence)((CharSequence)pair.getFirst()))) continue;
                ((JTabbedPane)this.myComponent).setSelectedIndex(i);
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/options/GroupSettingsBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompoundEditor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

