/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType
implements SdkTypeId {
    public static final ExtensionPointName<SdkType> EP_NAME = new ExtensionPointName("com.intellij.sdkType");
    private static final Comparator<Sdk> ALPHABETICAL_COMPARATOR = (sdk1, sdk2) -> StringUtil.compare((String)sdk1.getName(), (String)sdk2.getName(), (boolean)true);
    private final String myName;

    public SdkType(@NotNull String name) {
        if (name == null) {
            SdkType.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @Nullable
    public abstract String suggestHomePath();

    @NotNull
    public Collection<String> suggestHomePaths() {
        String home = this.suggestHomePath();
        List<String> list = home != null ? Collections.singletonList(home) : Collections.emptyList();
        if (list == null) {
            SdkType.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isRelevantForFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SdkType.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SdkType.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(4);
        }
        String string = homePath;
        if (string == null) {
            SdkType.$$$reportNull$$$0(5);
        }
        return string;
    }

    public abstract boolean isValidSdkHome(@NotNull String var1);

    public String getInvalidHomeMessage(@NotNull String path2) {
        if (path2 == null) {
            SdkType.$$$reportNull$$$0(6);
        }
        return new File(path2).isDirectory() ? ProjectBundle.message("sdk.configure.home.invalid.error", this.getPresentableName()) : ProjectBundle.message("sdk.configure.home.file.invalid.error", this.getPresentableName());
    }

    @Override
    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        String homePath;
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(7);
        }
        return (homePath = sdk.getHomePath()) == null ? null : this.getVersionString(homePath);
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    @NotNull
    public abstract String suggestSdkName(@Nullable String var1, @NotNull String var2);

    @NotNull
    public Comparator<Sdk> getComparator() {
        Comparator<Sdk> comparator = ALPHABETICAL_COMPARATOR;
        if (comparator == null) {
            SdkType.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(9);
        }
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(10);
        }
        this.setupSdkPaths(sdk);
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(11);
        }
    }

    @Nullable
    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel var1, @NotNull SdkModificator var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Element additional) {
        if (additional == null) {
            SdkType.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        if (currentSdk == null) {
            SdkType.$$$reportNull$$$0(13);
        }
        if (additional == null) {
            SdkType.$$$reportNull$$$0(14);
        }
        return this.loadAdditionalData(additional);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SdkType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.jdks";
    }

    @Deprecated
    public Icon getIconForAddAction() {
        return this.getIcon();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            @Override
            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = SdkType.this.getInvalidHomeMessage(selectedPath);
                    throw new Exception(message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/projectRoots/SdkType$1", "validateSelectedFiles"));
            }
        };
        descriptor.setTitle(ProjectBundle.message("sdk.configure.home.title", this.getPresentableName()));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            SdkType.$$$reportNull$$$0(16);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    @NlsContexts.Label
    public String getHomeFieldLabel() {
        String string = ProjectBundle.message("sdk.configure.type.home.path", this.getPresentableName());
        if (string == null) {
            SdkType.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return null;
    }

    public static SdkType @NotNull [] getAllTypes() {
        SdkType[] sdkTypeArray = (SdkType[])EP_NAME.getExtensions();
        if (sdkTypeArray == null) {
            SdkType.$$$reportNull$$$0(19);
        }
        return sdkTypeArray;
    }

    @Nullable
    public static SdkType findByName(@Nullable String sdkName) {
        if (sdkName == null) {
            return null;
        }
        for (SdkType sdkType : SdkType.getAllTypes()) {
            if (!Comparing.strEqual((String)sdkType.getName(), (String)sdkName)) continue;
            return sdkType;
        }
        return null;
    }

    @NotNull
    public static <T extends SdkType> T findInstance(@NotNull Class<T> sdkTypeClass) {
        if (sdkTypeClass == null) {
            SdkType.$$$reportNull$$$0(20);
        }
        for (SdkType sdkType : EP_NAME.getExtensionList()) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            SdkType sdkType2 = (SdkType)sdkTypeClass.cast(sdkType);
            if (sdkType2 == null) {
                SdkType.$$$reportNull$$$0(21);
            }
            return (T)sdkType2;
        }
        throw new IllegalArgumentException("Unknown SDk type: " + sdkTypeClass);
    }

    public SdkType getDependencyType() {
        return null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            SdkType.$$$reportNull$$$0(22);
        }
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(23);
        }
        if (parentComponent == null) {
            SdkType.$$$reportNull$$$0(24);
        }
        if (sdkCreatedCallback == null) {
            SdkType.$$$reportNull$$$0(25);
        }
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        VirtualFile homeDir;
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(26);
        }
        return (homeDir = sdk.getHomeDirectory()) != null && homeDir.isValid();
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(27);
        }
        String string = homePath.getPath();
        if (string == null) {
            SdkType.$$$reportNull$$$0(28);
        }
        return string;
    }

    public boolean allowCreationByUser() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstance";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidHomeMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

