/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceSetBase<T extends PsiReference> {
    public static final char DOT_SEPARATOR = '.';
    private final NotNullLazyValue<List<T>> myReferences;
    private final PsiElement myElement;
    private final char mySeparator;

    public ReferenceSetBase(@NotNull PsiElement element) {
        if (element == null) {
            ReferenceSetBase.$$$reportNull$$$0(0);
        }
        this(element, ElementManipulators.getOffsetInElement(element));
    }

    public ReferenceSetBase(@NotNull PsiElement element, int offset) {
        if (element == null) {
            ReferenceSetBase.$$$reportNull$$$0(1);
        }
        this(ElementManipulators.getValueText(element), element, offset, '.');
    }

    public ReferenceSetBase(String text2, @NotNull PsiElement element, int offset, char separator) {
        if (element == null) {
            ReferenceSetBase.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.mySeparator = separator;
        this.myReferences = NotNullLazyValue.lazy(() -> this.parse(text2, offset));
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    protected List<T> parse(String str, int offset) {
        int next;
        ArrayList<T> references = new ArrayList<T>();
        int current = -1;
        int index = 0;
        do {
            TextRange range2;
            if ((range2 = new TextRange(offset + current + 1, offset + ((next = this.findNextSeparator(str, current)) >= 0 ? next : str.length()))).isEmpty() && Character.isWhitespace(this.mySeparator)) continue;
            references.addAll(this.createReferences(range2, index++));
        } while ((current = next) >= 0);
        ArrayList<T> arrayList = references;
        if (arrayList == null) {
            ReferenceSetBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected int findNextSeparator(String str, int current) {
        int next = str.indexOf(this.mySeparator, current + 1);
        return next;
    }

    @Nullable
    protected T createReference(TextRange range2, int index) {
        return null;
    }

    protected List<T> createReferences(TextRange range2, int index) {
        T reference = this.createReference(range2, index);
        return reference == null ? Collections.emptyList() : Collections.singletonList(reference);
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public List<T> getReferences() {
        return (List)this.myReferences.getValue();
    }

    public PsiReference @NotNull [] getPsiReferences() {
        PsiReference[] psiReferenceArray = this.getReferences().toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            ReferenceSetBase.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    public T getReference(int index) {
        return (T)((PsiReference)this.getReferences().get(index));
    }

    @Nullable
    public T getLastReference() {
        return this.getReferences().isEmpty() ? null : (T)this.getReference(this.getReferences().size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ReferenceSetBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ReferenceSetBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

