/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;

public abstract class GroupedElementsRenderer
implements Accessible {
    protected SeparatorWithText mySeparatorComponent = this.createSeparator();
    protected JComponent myComponent;
    protected MyComponent myRendererComponent = new MyComponent();
    protected ErrorLabel myTextLabel;

    protected abstract JComponent createItemComponent();

    public GroupedElementsRenderer() {
        this.myComponent = this.createItemComponent();
        this.layout();
    }

    protected abstract void layout();

    protected SeparatorWithText createSeparator() {
        return new SeparatorWithText();
    }

    protected final JComponent configureComponent(@NlsContexts.ListItem String text2, @NlsContexts.Tooltip String tooltip, Icon icon2, Icon disabledIcon, boolean isSelected, boolean hasSeparatorAbove, @NlsContexts.Separator String separatorTextAbove, int preferredForcedWidth) {
        this.mySeparatorComponent.setVisible(hasSeparatorAbove);
        this.mySeparatorComponent.setCaption(separatorTextAbove);
        this.mySeparatorComponent.setMinimumWidth(preferredForcedWidth);
        this.myTextLabel.setText(text2);
        this.myRendererComponent.setToolTipText(tooltip);
        AccessibleContextUtil.setName((Component)this.myRendererComponent, (Component)this.myTextLabel);
        AccessibleContextUtil.setDescription((Component)this.myRendererComponent, (Component)this.myTextLabel);
        this.setComponentIcon(icon2, disabledIcon);
        this.setSelected(this.myComponent, isSelected);
        this.setSelected(this.myTextLabel, isSelected);
        this.myRendererComponent.setPreferredWidth(preferredForcedWidth);
        return this.myRendererComponent;
    }

    protected void setComponentIcon(Icon icon2, Icon disabledIcon) {
        this.myTextLabel.setIcon(icon2);
        this.myTextLabel.setDisabledIcon(disabledIcon);
        this.myTextLabel.setIconTextGap(JBUI.CurrentTheme.ActionsList.elementIconGap());
    }

    protected final void setSelected(JComponent aComponent) {
        this.setSelected(aComponent, true);
    }

    protected final void setDeselected(JComponent aComponent) {
        this.setSelected(aComponent, false);
    }

    protected final void setSelected(JComponent aComponent, boolean selected) {
        UIUtil.setBackgroundRecursively((Component)aComponent, (Color)(selected ? this.getSelectionBackground() : this.getBackground()));
        this.setForegroundSelected(aComponent, selected);
    }

    protected final void setForegroundSelected(JComponent aComponent, boolean selected) {
        aComponent.setForeground(selected ? this.getSelectionForeground() : this.getForeground());
    }

    protected void setSeparatorFont(Font font) {
        this.mySeparatorComponent.setFont(font);
    }

    protected abstract Color getSelectionBackground();

    protected abstract Color getSelectionForeground();

    protected abstract Color getBackground();

    protected abstract Color getForeground();

    protected Border getDefaultItemComponentBorder() {
        return GroupedElementsRenderer.getBorder();
    }

    private static Border getBorder() {
        return new EmptyBorder(JBUI.CurrentTheme.ActionsList.cellPadding());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.myRendererComponent.getAccessibleContext();
    }

    protected class MyComponent
    extends OpaquePanel {
        private int myPrefWidth;

        public MyComponent() {
            super((LayoutManager)new BorderLayout(), GroupedElementsRenderer.this.getBackground());
            this.myPrefWidth = -1;
        }

        public void setPreferredWidth(int minWidth) {
            this.myPrefWidth = minWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.myPrefWidth == -1 ? size.width : this.myPrefWidth;
            return size;
        }
    }

    public static abstract class Tree
    extends GroupedElementsRenderer
    implements TreeCellRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            this.myRendererComponent.add((Component)this.myComponent, "West");
        }

        @Override
        protected Color getSelectionBackground() {
            return UIUtil.getTreeSelectionBackground();
        }

        @Override
        protected Color getSelectionForeground() {
            return UIUtil.getTreeSelectionForeground();
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getTreeBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getTreeForeground();
        }
    }

    public static abstract class List
    extends GroupedElementsRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            NonOpaquePanel centerComponent = new NonOpaquePanel(this.myComponent){

                @Override
                public Dimension getPreferredSize() {
                    return UIUtil.updateListRowHeight((Dimension)super.getPreferredSize());
                }
            };
            this.myRendererComponent.add((Component)centerComponent, "Center");
        }

        @Override
        protected final Color getSelectionBackground() {
            return UIUtil.getListSelectionBackground((boolean)true);
        }

        @Override
        protected final Color getSelectionForeground() {
            return UIUtil.getListSelectionForeground((boolean)true);
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getListBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getListForeground();
        }
    }
}

