/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\b\b\u0001\u0010\n\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bB!\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/components/AnActionLink;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ui/components/ActionLink;", "text", "", "anAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Ljava/lang/String;Lcom/intellij/openapi/actionSystem/AnAction;)V", "place", "(Lcom/intellij/openapi/actionSystem/AnAction;Ljava/lang/String;)V", "actionId", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Lcom/intellij/openapi/actionSystem/AnAction;Ljava/lang/String;)V", "dataProvider", "getDataProvider", "()Lcom/intellij/openapi/actionSystem/DataProvider;", "setDataProvider", "(Lcom/intellij/openapi/actionSystem/DataProvider;)V", "getData", "", "Lorg/jetbrains/annotations/Nullable;", "dataId", "intellij.platform.ide"})
public class AnActionLink
extends ActionLink
implements DataProvider {
    @Nullable
    private DataProvider dataProvider;

    @Nullable
    public final DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@Nullable DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
            Component component = SwingUtilities.getRoot(this);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"SwingUtilities.getRoot(this)");
            Point point = component.getLocationOnScreen();
            object = new Rectangle(point.x, point.y, this.getWidth(), this.getHeight());
        } else if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            object = SwingUtilities.convertPoint(this, 0, this.getHeight(), UIUtil.getRootPane((Component)this));
        } else {
            DataProvider dataProvider = this.dataProvider;
            object = dataProvider != null ? dataProvider.getData(dataId) : null;
        }
        return object;
    }

    public AnActionLink(@Nls @NotNull String text2, final @NotNull AnAction anAction, final @NonNls @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)anAction, (String)"anAction");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        super(text2, (Function1<? super ActionEvent, Unit>)((Function1)new Function1<ActionEvent, Unit>(){

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = it.getSource();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.components.AnActionLink");
                }
                ActionUtil.invokeAction(anAction, (AnActionLink)object, place, null, null);
            }
        }));
        AnAction anAction2 = anAction;
        if (!(anAction2 instanceof DataProvider)) {
            anAction2 = null;
        }
        this.dataProvider = (DataProvider)anAction2;
    }

    public AnActionLink(@Nls @NotNull String text2, @NotNull AnAction anAction) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)anAction, (String)"anAction");
        this(text2, anAction, "unknown");
    }

    public AnActionLink(@NotNull AnAction anAction, @NonNls @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)anAction, (String)"anAction");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        String string = anAction.getTemplateText();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"anAction.templateText ?: \"\"");
        this(string, anAction, place);
    }

    public AnActionLink(@NonNls @NotNull String actionId, @NonNls @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstance().getAction(actionId)");
        this(anAction, place);
    }
}

