/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dualView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.dualView.DualTreeElement;
import com.intellij.ui.dualView.TableCellRendererWrapper;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableView
extends TreeTable
implements SelectionProvider {
    private static final Logger LOG = Logger.getInstance(TreeTableView.class);

    public TreeTableView(ListTreeTableModelOnColumns treeTableModel) {
        super(treeTableModel);
        this.setRootVisible(false);
        this.setTreeCellRenderer(new TreeCellRenderer(){
            private final TreeCellRenderer myBaseRenderer = new HighlightableCellRenderer();

            @Override
            public Component getTreeCellRendererComponent(JTree tree1, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent result = (JComponent)this.myBaseRenderer.getTreeCellRendererComponent(tree1, value2, selected, expanded, leaf, row, hasFocus);
                result.setOpaque(!selected);
                return result;
            }
        });
        this.setSizes();
    }

    @Override
    public void setTableModel(TreeTableModel treeTableModel) {
        super.setTableModel(treeTableModel);
        LOG.assertTrue(treeTableModel instanceof SortableColumnModel);
    }

    private void setSizes() {
        ColumnInfo[] columns = ((ListTreeTableModelOnColumns)this.getTableModel()).getColumns();
        for (int i = 0; i < columns.length; ++i) {
            ColumnInfo columnInfo = columns[i];
            TableColumn column = this.getColumnModel().getColumn(i);
            if (columnInfo.getWidth(this) > 0) {
                int width = columnInfo.getWidth(this);
                column.setMaxWidth(width);
                column.setMinWidth(width);
                continue;
            }
            String preferredValue = columnInfo.getPreferredStringValue();
            if (preferredValue == null) continue;
            int width = this.getFontMetrics(this.getFont()).stringWidth(preferredValue) + columnInfo.getAdditionalWidth();
            column.setPreferredWidth(width);
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.getColumnInfo(column).getEditor(this.getRowElement(row));
        return editor == null ? super.getCellEditor(row, column) : editor;
    }

    @Override
    public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
        return new TreeTableCellRenderer(this, this.getTree()){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent component = (JComponent)super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                component.setOpaque(isSelected);
                return component;
            }
        };
    }

    ListTreeTableModelOnColumns getTreeViewModel() {
        return (ListTreeTableModelOnColumns)this.getTableModel();
    }

    public List<DualTreeElement> getFlattenItems() {
        List items = this.getTreeViewModel().getItems();
        return ContainerUtil.findAll((Collection)items, object -> object.shouldBeInTheFlatView());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.getColumnInfo(column).getRenderer(this.getRowElement(row));
        TableCellRenderer baseRenderer = renderer == null ? super.getCellRenderer(row, column) : renderer;
        return new CellRendererWrapper(baseRenderer);
    }

    protected Object getRowElement(int row) {
        return this.getTree().getPathForRow(row).getLastPathComponent();
    }

    protected final ColumnInfo<Object, ?> getColumnInfo(int column) {
        return this.getTreeViewModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
    }

    public List getItems() {
        return this.getTreeViewModel().getItems();
    }

    @Override
    public List getSelection() {
        TreeTableTree tree = this.getTree();
        if (tree == null) {
            return Collections.emptyList();
        }
        int[] rows = this.getSelectedRows();
        ArrayList<Object> result = new ArrayList<Object>();
        for (int row : rows) {
            TreePath pathForRow = tree.getPathForRow(row);
            if (pathForRow == null) continue;
            result.add(pathForRow.getLastPathComponent());
        }
        return result;
    }

    @Override
    public void addSelection(Object item) {
        this.getTree().setExpandsSelectedPaths(true);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)item;
        this.addSelectedPath(new TreePath(treeNode.getPath()));
    }

    public static class CellRendererWrapper
    implements TableCellRendererWrapper {
        @NotNull
        private final TableCellRenderer myBaseRenderer;

        public CellRendererWrapper(@NotNull TableCellRenderer baseRenderer) {
            if (baseRenderer == null) {
                CellRendererWrapper.$$$reportNull$$$0(0);
            }
            this.myBaseRenderer = baseRenderer;
        }

        @Override
        @NotNull
        public TableCellRenderer getBaseRenderer() {
            TableCellRenderer tableCellRenderer = this.myBaseRenderer;
            if (tableCellRenderer == null) {
                CellRendererWrapper.$$$reportNull$$$0(1);
            }
            return tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent rendererComponent = (JComponent)this.myBaseRenderer.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            if (isSelected) {
                rendererComponent.setBackground(table.getSelectionBackground());
                rendererComponent.setForeground(table.getSelectionForeground());
            } else {
                Color bg = table.getBackground();
                rendererComponent.setBackground(bg);
                rendererComponent.setForeground(table.getForeground());
            }
            rendererComponent.setOpaque(isSelected);
            return rendererComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseRenderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/dualView/TreeTableView$CellRendererWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/dualView/TreeTableView$CellRendererWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

