/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scroll;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LatchingScroll {
    private final List<MyScrollEvent> myScrollEvents = new LinkedList<MyScrollEvent>();

    public boolean shouldBeIgnored(MouseWheelEvent event) {
        JScrollPane source = (JScrollPane)event.getSource();
        if (UIUtil.isClientPropertyTrue((Object)LatchingScroll.getViewportView(source), JBScrollPane.IGNORE_SCROLL_LATCHING)) {
            return false;
        }
        this.myScrollEvents.add(new MyScrollEvent(event.getWhen(), event.getPreciseWheelRotation(), event.isShiftDown()));
        double xs = 0.0;
        double ys = 0.0;
        Iterator<MyScrollEvent> iterator = this.myScrollEvents.iterator();
        while (iterator.hasNext()) {
            MyScrollEvent se = iterator.next();
            if (se.getWhen() + LatchingScroll.getExpireAfter() < event.getWhen()) {
                iterator.remove();
                continue;
            }
            if (se.isHorizontal()) {
                xs += Math.abs(se.getRotation());
                continue;
            }
            ys += Math.abs(se.getRotation());
        }
        double angle = Math.toDegrees(Math.atan(Math.abs(ys / xs)));
        boolean isHorizontal = event.isShiftDown();
        double thatAngle = LatchingScroll.getAngle();
        return angle <= thatAngle && !isHorizontal || angle >= 90.0 - thatAngle && isHorizontal;
    }

    @Nullable
    private static Component getViewportView(@NotNull JScrollPane pane) {
        JViewport viewport;
        if (pane == null) {
            LatchingScroll.$$$reportNull$$$0(0);
        }
        if ((viewport = pane.getViewport()) != null) {
            return viewport.getView();
        }
        return null;
    }

    private static long getExpireAfter() {
        return Math.max(Registry.intValue((String)"idea.latching.scrolling.time"), 0);
    }

    private static double getAngle() {
        return Math.min(Math.max(Registry.doubleValue((String)"idea.latching.scrolling.angle"), 0.0), 45.0);
    }

    public static boolean isEnabled() {
        return Registry.is((String)"idea.latching.scrolling.enabled", (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/intellij/ui/scroll/LatchingScroll", "getViewportView"));
    }

    private static class MyScrollEvent {
        private final long myWhen;
        private final double myRotation;
        private final boolean isMyHorizontal;

        private MyScrollEvent(long when, double rotation, boolean isHorizontal) {
            this.myWhen = when;
            this.myRotation = rotation;
            this.isMyHorizontal = isHorizontal;
        }

        private long getWhen() {
            return this.myWhen;
        }

        private double getRotation() {
            return this.myRotation;
        }

        private boolean isHorizontal() {
            return this.isMyHorizontal;
        }
    }
}

