/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleRowLayout
extends TabLayout {
    final JBTabsImpl myTabs;
    public SingleRowPassInfo myLastSingRowLayout;
    private final SingleRowLayoutStrategy myTop;
    private final SingleRowLayoutStrategy myLeft;
    private final SingleRowLayoutStrategy myBottom;
    private final SingleRowLayoutStrategy myRight;

    @Override
    public boolean isSideComponentOnTabs() {
        return this.getStrategy().isSideComponentOnTabs();
    }

    @Override
    public ShapeTransform createShapeTransform(Rectangle labelRec) {
        return this.getStrategy().createShapeTransform(labelRec);
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            SingleRowLayout.$$$reportNull$$$0(0);
        }
        return this.getStrategy().isDragOut(tabLabel, deltaX, deltaY);
    }

    public SingleRowLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
        this.myTop = new SingleRowLayoutStrategy.Top(this);
        this.myLeft = new SingleRowLayoutStrategy.Left(this);
        this.myBottom = new SingleRowLayoutStrategy.Bottom(this);
        this.myRight = new SingleRowLayoutStrategy.Right(this);
    }

    SingleRowLayoutStrategy getStrategy() {
        switch (this.myTabs.getPresentation().getTabsPosition()) {
            case top: {
                return this.myTop;
            }
            case left: {
                return this.myLeft;
            }
            case bottom: {
                return this.myBottom;
            }
            case right: {
                return this.myRight;
            }
        }
        return null;
    }

    protected boolean checkLayoutLabels(SingleRowPassInfo data) {
        boolean layoutLabels = true;
        if (!this.myTabs.myForcedRelayout && this.myLastSingRowLayout != null && this.myLastSingRowLayout.contentCount == this.myTabs.getTabCount() && this.myLastSingRowLayout.layoutSize.equals(this.myTabs.getSize()) && this.myLastSingRowLayout.scrollOffset == this.getScrollOffset()) {
            for (TabInfo each : data.myVisibleInfos) {
                TabLabel eachLabel = this.myTabs.myInfo2Label.get(each);
                if (!eachLabel.isValid()) {
                    layoutLabels = true;
                    break;
                }
                if (this.myTabs.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    int getScrollOffset() {
        return 0;
    }

    public void scroll(int units) {
    }

    public int getScrollUnitIncrement() {
        return 0;
    }

    public void scrollSelectionInView() {
    }

    public LayoutPassInfo layoutSingleRow(List<TabInfo> visibleInfos) {
        SingleRowPassInfo data = new SingleRowPassInfo(this, visibleInfos);
        boolean shouldLayoutLabels = this.checkLayoutLabels(data);
        if (!shouldLayoutLabels) {
            data = this.myLastSingRowLayout;
        }
        TabInfo selected = this.myTabs.getSelectedInfo();
        this.prepareLayoutPassInfo(data, selected);
        this.myTabs.resetLayout(shouldLayoutLabels || this.myTabs.isHideTabs());
        if (shouldLayoutLabels && !this.myTabs.isHideTabs()) {
            this.recomputeToLayout(data);
            data.position = this.getStrategy().getStartPosition(data) - this.getScrollOffset();
            this.layoutTitle(data);
            data.position = data.position + (this.myTabs.isHorizontalTabs() ? data.titleRect.width : data.titleRect.height);
            this.layoutLabels(data);
            this.layoutMoreButton(data);
        }
        if (selected != null) {
            data.comp = new WeakReference<JComponent>(selected.getComponent());
            this.getStrategy().layoutComp(data);
        }
        data.tabRectangle = new Rectangle();
        if (data.toLayout.size() > 0) {
            TabLabel firstLabel = this.myTabs.myInfo2Label.get(data.toLayout.get(0));
            TabLabel lastLabel = this.findLastVisibleLabel(data);
            if (firstLabel != null && lastLabel != null) {
                data.tabRectangle.x = firstLabel.getBounds().x;
                data.tabRectangle.y = firstLabel.getBounds().y;
                data.tabRectangle.width = (int)lastLabel.getBounds().getMaxX() - data.tabRectangle.x;
                data.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data.tabRectangle.y;
            }
        }
        this.myLastSingRowLayout = data;
        return data;
    }

    @Nullable
    protected TabLabel findLastVisibleLabel(SingleRowPassInfo data) {
        return this.myTabs.myInfo2Label.get(data.toLayout.get(data.toLayout.size() - 1));
    }

    protected void prepareLayoutPassInfo(SingleRowPassInfo data, TabInfo selected) {
        JBTabsImpl.Toolbar selectedToolbar;
        data.insets = this.myTabs.getLayoutInsets();
        if (this.myTabs.isHorizontalTabs()) {
            data.insets.left += this.myTabs.getFirstTabOffset();
        }
        data.hToolbar = new WeakReference<Object>(((selectedToolbar = this.myTabs.myInfo2Toolbar.get(selected)) != null && this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.vToolbar = new WeakReference<Object>((selectedToolbar != null && !this.myTabs.myHorizontalSide && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data.toFitLength = this.getStrategy().getToFitLength(data);
    }

    protected void layoutTitle(SingleRowPassInfo data) {
        data.titleRect = this.getStrategy().getTitleRect(data);
    }

    protected void layoutMoreButton(SingleRowPassInfo data) {
        if (data.toDrop.size() > 0) {
            data.moreRect = this.getStrategy().getMoreRect(data);
        }
    }

    protected void layoutLabels(SingleRowPassInfo data) {
        boolean layoutStopped = false;
        for (TabInfo eachInfo : data.toLayout) {
            TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
            if (layoutStopped) {
                Rectangle rec = this.getStrategy().getLayoutRect(data, 0, 0);
                this.myTabs.layout(label, rec);
                continue;
            }
            Dimension eachSize = label.getPreferredSize();
            int length = this.getStrategy().getLengthIncrement(eachSize);
            boolean continueLayout = this.applyTabLayout(data, label, length);
            data.position = this.getStrategy().getMaxPosition(label.getBounds());
            data.position += this.myTabs.getTabHGap();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length) {
        Rectangle rec = this.getStrategy().getLayoutRect(data, data.position, length);
        this.myTabs.layout(label, rec);
        label.setAlignmentToCenter(this.myTabs.isEditorTabs() && this.getStrategy().isToCenterTextWhenStretched());
        return true;
    }

    protected abstract void recomputeToLayout(SingleRowPassInfo var1);

    protected void calculateRequiredLength(SingleRowPassInfo data) {
        for (TabInfo eachInfo : data.myVisibleInfos) {
            data.requiredLength += this.getRequiredLength(eachInfo);
            if (this.myTabs.getTabsPosition().isSide()) {
                --data.requiredLength;
            }
            data.toLayout.add(eachInfo);
        }
    }

    protected int getRequiredLength(TabInfo eachInfo) {
        TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
        return this.getStrategy().getLengthIncrement(label != null ? label.getPreferredSize() : new Dimension()) + (this.myTabs.isEditorTabs() ? this.myTabs.getTabHGap() : 0);
    }

    public boolean isTabHidden(TabInfo tabInfo) {
        return this.myLastSingRowLayout != null && this.myLastSingRowLayout.toDrop.contains(tabInfo);
    }

    @Override
    public int getDropIndexFor(Point point) {
        if (this.myLastSingRowLayout == null) {
            return -1;
        }
        int result = -1;
        Component c = this.myTabs.getComponentAt(point);
        if (c instanceof JBTabsImpl) {
            for (int i = 0; i < this.myLastSingRowLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabLabel first = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i));
                TabLabel second = this.myTabs.myInfo2Label.get(this.myLastSingRowLayout.myVisibleInfos.get(i + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean horizontal = this.getStrategy() instanceof SingleRowLayoutStrategy.Horizontal;
                if (horizontal) {
                    between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                } else {
                    boolean bl = between = firstBounds.getMaxY() < (double)point.y && secondBounds.getY() > (double)point.y && firstBounds.x < point.x && secondBounds.getMaxX() > (double)point.x;
                }
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastSingRowLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i = 0; i <= index; ++i) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i))) continue;
                    --index;
                    break;
                }
                result = index;
            } else if (index < this.myLastSingRowLayout.myVisibleInfos.size()) {
                result = index;
            }
        }
        return result;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            SingleRowLayout.$$$reportNull$$$0(1);
        }
        return TabsUtil.getDropSideFor(point, this.myTabs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

