/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.frame;

import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XValueChildrenList {
    public static final XValueChildrenList EMPTY = new XValueChildrenList(Collections.emptyList(), Collections.emptyList());
    private final List<String> myNames;
    private final List<XValue> myValues;
    private final List<XValueGroup> myTopGroups;
    private final List<XValueGroup> myBottomGroups;

    public XValueChildrenList(int initialCapacity) {
        this(new ArrayList<String>(initialCapacity), new ArrayList<XValue>(initialCapacity), (List<XValueGroup>)new SmartList());
    }

    public XValueChildrenList() {
        this((List<String>)new SmartList(), (List<XValue>)new SmartList(), (List<XValueGroup>)new SmartList());
    }

    private XValueChildrenList(@NotNull List<String> names, @NotNull List<XValue> values, @NotNull List<XValueGroup> topGroups) {
        if (names == null) {
            XValueChildrenList.$$$reportNull$$$0(0);
        }
        if (values == null) {
            XValueChildrenList.$$$reportNull$$$0(1);
        }
        if (topGroups == null) {
            XValueChildrenList.$$$reportNull$$$0(2);
        }
        this.myBottomGroups = new SmartList();
        this.myNames = names;
        this.myValues = values;
        this.myTopGroups = topGroups;
    }

    private XValueChildrenList(List<String> names, List<XValue> values) {
        this(names, values, (List<XValueGroup>)new SmartList());
    }

    public static XValueChildrenList singleton(String name, @NotNull XValue value2) {
        if (value2 == null) {
            XValueChildrenList.$$$reportNull$$$0(3);
        }
        return new XValueChildrenList(Collections.singletonList(name), Collections.singletonList(value2));
    }

    public static XValueChildrenList singleton(@NotNull XNamedValue value2) {
        if (value2 == null) {
            XValueChildrenList.$$$reportNull$$$0(4);
        }
        return new XValueChildrenList(Collections.singletonList(value2.getName()), Collections.singletonList(value2));
    }

    public static XValueChildrenList bottomGroup(@NotNull XValueGroup group) {
        if (group == null) {
            XValueChildrenList.$$$reportNull$$$0(5);
        }
        XValueChildrenList list = new XValueChildrenList();
        list.addBottomGroup(group);
        return list;
    }

    public static XValueChildrenList topGroups(@NotNull List<XValueGroup> topGroups) {
        if (topGroups == null) {
            XValueChildrenList.$$$reportNull$$$0(6);
        }
        return new XValueChildrenList(Collections.emptyList(), Collections.emptyList(), topGroups);
    }

    public void add(@NonNls String name, @NotNull XValue value2) {
        if (value2 == null) {
            XValueChildrenList.$$$reportNull$$$0(7);
        }
        this.myNames.add(name);
        this.myValues.add(value2);
    }

    public void add(@NotNull XNamedValue value2) {
        if (value2 == null) {
            XValueChildrenList.$$$reportNull$$$0(8);
        }
        this.myNames.add(value2.getName());
        this.myValues.add(value2);
    }

    public void addTopGroup(@NotNull XValueGroup group) {
        if (group == null) {
            XValueChildrenList.$$$reportNull$$$0(9);
        }
        this.myTopGroups.add(group);
    }

    public void addBottomGroup(@NotNull XValueGroup group) {
        if (group == null) {
            XValueChildrenList.$$$reportNull$$$0(10);
        }
        this.myBottomGroups.add(group);
    }

    public int size() {
        return this.myNames.size();
    }

    public String getName(int i) {
        return this.myNames.get(i);
    }

    public XValue getValue(int i) {
        return this.myValues.get(i);
    }

    public List<XValueGroup> getTopGroups() {
        return this.myTopGroups;
    }

    public List<XValueGroup> getBottomGroups() {
        return this.myBottomGroups;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topGroups";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/frame/XValueChildrenList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "singleton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "bottomGroup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "topGroups";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addTopGroup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addBottomGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

