/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GradleReRunBuildFilter
implements Filter {
    protected final String myBuildWorkingDir;
    private String line;
    private List<Filter.ResultItem> links;
    private int lineStart;

    public GradleReRunBuildFilter(String buildWorkingDir) {
        this.myBuildWorkingDir = buildWorkingDir;
    }

    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(0);
        }
        if (line == null) {
            return null;
        }
        this.line = line;
        this.lineStart = entireLength - line.length();
        this.links = new ArrayList<Filter.ResultItem>();
        String trimLine = line.trim();
        if (!trimLine.contains("Run with --") || !trimLine.endsWith("option to get the stack trace.") && !trimLine.endsWith("option to get more log output.") && !trimLine.endsWith("to get full insights.")) {
            return null;
        }
        this.addLinkIfMatch("Run with --stacktrace", "--stacktrace");
        this.addLinkIfMatch("Run with --info", "--info");
        this.addLinkIfMatch("Run with --debug option", "--debug");
        this.addLinkIfMatch("--debug option", "--debug");
        this.addLinkIfMatch("Run with --scan", "--scan");
        if (this.links.isEmpty()) {
            return null;
        }
        return new Filter.Result(this.links);
    }

    @NotNull
    protected abstract HyperlinkInfo getHyperLinkInfo(List<String> var1);

    private void addLinkIfMatch(@NotNull String text, @NotNull String option) {
        int index;
        if (text == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(1);
        }
        if (option == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(2);
        }
        if ((index = this.line.indexOf(text)) != -1) {
            this.links.add(this.createLink(this.lineStart + index, this.lineStart + index + text.length(), option));
        }
    }

    @NotNull
    private Filter.ResultItem createLink(int start2, int end, @NotNull String option) {
        if (option == null) {
            GradleReRunBuildFilter.$$$reportNull$$$0(3);
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add(option);
        return new Filter.ResultItem(start2, end, this.getHyperLinkInfo(options));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/filters/GradleReRunBuildFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addLinkIfMatch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createLink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

