/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ExternalProjectDataCache {
    @ApiStatus.Internal
    @NotNull
    public static final Key<ExternalProject> KEY = Key.create(ExternalProject.class, (int)(ProjectKeys.TASK.getProcessingWeight() + 1));
    private final Project myProject;

    public static ExternalProjectDataCache getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(0);
        }
        return (ExternalProjectDataCache)project.getService(ExternalProjectDataCache.class);
    }

    public ExternalProjectDataCache(@NotNull Project project) {
        if (project == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public ExternalProject getRootExternalProject(@NotNull ProjectSystemId systemId, @NotNull File projectRootDir) {
        if (systemId == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(2);
        }
        if (projectRootDir == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(3);
        }
        if (GradleConstants.SYSTEM_ID != systemId) {
            throw new IllegalStateException("Attempt to use Gradle-specific cache with illegal system id [" + systemId.getReadableName() + "]");
        }
        return this.getRootExternalProject(ExternalSystemApiUtil.toCanonicalPath((String)projectRootDir.getPath()));
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull String externalProjectPath) {
        ExternalProjectInfo projectData;
        if (externalProjectPath == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(4);
        }
        if ((projectData = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, externalProjectPath)) == null) {
            return null;
        }
        DataNode projectStructure = projectData.getExternalProjectStructure();
        if (projectStructure == null) {
            return null;
        }
        DataNode projectDataNode = ExternalSystemApiUtil.find((DataNode)projectStructure, KEY);
        if (projectDataNode == null) {
            return null;
        }
        return (ExternalProject)projectDataNode.getData();
    }

    @NotNull
    public Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        if (parentProject == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(6);
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        Map<String, ExternalSourceSet> map = externalProjectId != null ? ExternalProjectDataCache.findExternalProject(parentProject, externalProjectId, isSourceSet) : Collections.emptyMap();
        if (map == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    private static Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId, boolean isSourceSet) {
        ExternalProject externalProject;
        if (parentProject == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(8);
        }
        if (externalProjectId == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(9);
        }
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(parentProject);
        while ((externalProject = (ExternalProject)queue.pollFirst()) != null) {
            String projectId = externalProject.getId();
            boolean isRelatedProject = projectId.equals(externalProjectId);
            HashMap<String, ExternalSourceSet> result = new HashMap<String, ExternalSourceSet>();
            for (Map.Entry sourceSetEntry : externalProject.getSourceSets().entrySet()) {
                String sourceSetName = (String)sourceSetEntry.getKey();
                String sourceSetId = projectId + ":" + sourceSetName;
                if (!isRelatedProject && (!isSourceSet || !externalProjectId.equals(sourceSetId))) continue;
                result.put(sourceSetName, (ExternalSourceSet)sourceSetEntry.getValue());
            }
            if (!result.isEmpty() || isRelatedProject) {
                HashMap<String, ExternalSourceSet> hashMap = result;
                if (hashMap == null) {
                    ExternalProjectDataCache.$$$reportNull$$$0(10);
                }
                return hashMap;
            }
            queue.addAll(externalProject.getChildProjects().values());
        }
        Map<String, ExternalSourceSet> map = Collections.emptyMap();
        if (map == null) {
            ExternalProjectDataCache.$$$reportNull$$$0(11);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataCache";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRootExternalProject";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findExternalProject";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

