/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WorkingCopyInfoPanelKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/svn/dialogs/UiBuilder;", "", "info", "Lorg/jetbrains/idea/svn/dialogs/WCInfo;", "upgradeFormats", "", "Lorg/jetbrains/idea/svn/WorkingCopyFormat;", "(Lorg/jetbrains/idea/svn/dialogs/WCInfo;Ljava/util/Collection;)V", "build", "Lcom/intellij/openapi/util/text/HtmlChunk;", "cleanupRow", "configureBranchesRow", "depthRow", "formatRow", "isRootRow", "mergeFromRow", "nestedTypeRow", "pathRow", "urlRow", "intellij.vcs.svn"})
final class UiBuilder {
    private final WCInfo info;
    private final Collection<WorkingCopyFormat> upgradeFormats;

    @NotNull
    public final HtmlChunk build() {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        boolean bl2 = false;
        HtmlBuilder $this$apply = htmlBuilder;
        boolean bl3 = false;
        $this$apply.append(this.pathRow());
        $this$apply.append(this.urlRow());
        $this$apply.append(this.formatRow());
        $this$apply.append(this.depthRow());
        $this$apply.append(this.nestedTypeRow());
        $this$apply.append(this.isRootRow());
        if (!this.info.hasError()) {
            $this$apply.append(this.cleanupRow());
            $this$apply.append(this.configureBranchesRow());
            $this$apply.append(this.mergeFromRow());
        }
        HtmlChunk.Element element = htmlBuilder.wrapWith("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"HtmlBuilder().apply {\n  \u2026}\n    }.wrapWith(\"table\")");
        return (HtmlChunk)element;
    }

    private final HtmlChunk pathRow() {
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.text((String)this.info.getPath()).bold()));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(text(info.path).bold()))");
        return (HtmlChunk)element;
    }

    private final HtmlChunk urlRow() {
        HtmlChunk htmlChunk;
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td().addText(SvnBundle.message("label.working.copy.url", new Object[0])));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td().addText(\u2026abel.working.copy.url\")))");
        HtmlChunk.Element tr = element;
        if (this.info.hasError()) {
            HtmlChunk.Element element2 = tr.child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(2).attr("color", ColorUtil.toHex((Color)((Color)JBColor.red))).addText(this.info.getErrorMessage()));
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"tr.child(td(2).attr(\"col\u2026dText(info.errorMessage))");
            htmlChunk = (HtmlChunk)element2;
        } else {
            HtmlChunk.Element element3 = tr.child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(2).addText(this.info.getUrl().toDecodedString()));
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"tr.child(td(2).addText(i\u2026o.url.toDecodedString()))");
            htmlChunk = (HtmlChunk)element3;
        }
        return htmlChunk;
    }

    private final HtmlChunk formatRow() {
        HtmlChunk htmlChunk;
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td().addText(SvnBundle.message("label.working.copy.format", new Object[0])));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td().addText(\u2026l.working.copy.format\")))");
        HtmlChunk.Element tr = element;
        if (this.upgradeFormats.size() <= 1) {
            HtmlChunk.Element element2 = WorkingCopyInfoPanelKt.access$td(2);
            WorkingCopyFormat workingCopyFormat = this.info.getFormat();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)workingCopyFormat), (String)"info.format");
            HtmlChunk.Element element3 = tr.child((HtmlChunk)element2.addText(workingCopyFormat.getDisplayName()));
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"tr.child(td(2).addText(info.format.displayName))");
            htmlChunk = (HtmlChunk)element3;
        } else {
            HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
            HtmlChunk.Element element4 = WorkingCopyInfoPanelKt.access$td();
            WorkingCopyFormat workingCopyFormat = this.info.getFormat();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)workingCopyFormat), (String)"info.format");
            htmlChunkArray[0] = (HtmlChunk)element4.addText(workingCopyFormat.getDisplayName());
            htmlChunkArray[1] = (HtmlChunk)WorkingCopyInfoPanelKt.access$td().child((HtmlChunk)HtmlChunk.link((String)"CHANGE_FORMAT", (String)SvnBundle.message("link.change.format", new Object[0])));
            HtmlChunk.Element element5 = tr.children(htmlChunkArray);
            Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"tr.children(\n        td(\u2026change.format\")))\n      )");
            htmlChunk = (HtmlChunk)element5;
        }
        return htmlChunk;
    }

    private final HtmlChunk depthRow() {
        HtmlChunk htmlChunk;
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td().addText(SvnBundle.message("label.working.copy.depth", new Object[0])));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td().addText(\u2026el.working.copy.depth\")))");
        HtmlChunk.Element tr = element;
        if (Depth.INFINITY == this.info.getStickyDepth() || this.info.hasError()) {
            HtmlChunk.Element element2 = WorkingCopyInfoPanelKt.access$td(2);
            Depth depth = this.info.getStickyDepth();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)depth), (String)"info.stickyDepth");
            HtmlChunk.Element element3 = tr.child((HtmlChunk)element2.addText(depth.getDisplayName()));
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"tr.child(td(2).addText(i\u2026stickyDepth.displayName))");
            htmlChunk = (HtmlChunk)element3;
        } else {
            HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
            HtmlChunk.Element element4 = WorkingCopyInfoPanelKt.access$td();
            Depth depth = this.info.getStickyDepth();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)depth), (String)"info.stickyDepth");
            htmlChunkArray[0] = (HtmlChunk)element4.addText(depth.getDisplayName());
            htmlChunkArray[1] = (HtmlChunk)WorkingCopyInfoPanelKt.access$td().child((HtmlChunk)HtmlChunk.link((String)"FIX_DEPTH", (String)SvnBundle.message("link.fix.depth", new Object[0])));
            HtmlChunk.Element element5 = tr.children(htmlChunkArray);
            Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"tr.children(\n        td(\u2026ink.fix.depth\")))\n      )");
            htmlChunk = (HtmlChunk)element5;
        }
        return htmlChunk;
    }

    private final HtmlChunk nestedTypeRow() {
        NestedCopyType type = this.info.getType();
        if (NestedCopyType.external != type && NestedCopyType.switched != type) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"empty()");
            return htmlChunk;
        }
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.text((String)type.getDisplayName()).italic()));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(t\u2026e.displayName).italic()))");
        return (HtmlChunk)element;
    }

    private final HtmlChunk isRootRow() {
        if (!this.info.isIsWcRoot()) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"empty()");
            return htmlChunk;
        }
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.text((String)SvnBundle.message("label.working.copy.root", new Object[0])).italic()));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(t\u2026g.copy.root\")).italic()))");
        return (HtmlChunk)element;
    }

    private final HtmlChunk cleanupRow() {
        if (!this.info.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"empty()");
            return htmlChunk;
        }
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.link((String)"CLEANUP", (String)SvnBundle.message("cleanup.action.name", new Object[0]))));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(l\u2026\"cleanup.action.name\"))))");
        return (HtmlChunk)element;
    }

    private final HtmlChunk configureBranchesRow() {
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.link((String)"CONFIGURE_BRANCHES", (String)SvnBundle.message("action.name.configure.branches", new Object[0]))));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(l\u2026e.configure.branches\"))))");
        return (HtmlChunk)element;
    }

    private final HtmlChunk mergeFromRow() {
        HtmlChunk.Element element = WorkingCopyInfoPanelKt.access$tr().child((HtmlChunk)WorkingCopyInfoPanelKt.access$td(3).child((HtmlChunk)HtmlChunk.link((String)"MERGE_FROM", (String)SvnBundle.message("action.name.merge.from.ellipsis", new Object[0])).bold()));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tr().child(td(3).child(l\u2026from.ellipsis\")).bold()))");
        return (HtmlChunk)element;
    }

    public UiBuilder(@NotNull WCInfo info2, @NotNull Collection<? extends WorkingCopyFormat> upgradeFormats) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter(upgradeFormats, (String)"upgradeFormats");
        this.info = info2;
        this.upgradeFormats = upgradeFormats;
    }
}

