/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class SyntheticWorker {
    private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();
    private final Url myUrl;

    public SyntheticWorker(Url url) {
        this.myUrl = url;
    }

    public void removeSelf() {
        Url parentUrl;
        try {
            parentUrl = SvnUtil.removePathTail(this.myUrl);
        }
        catch (SvnBindException e) {
            return;
        }
        List<DirectoryEntry> children = this.myCache.getChildren(parentUrl);
        if (children == null) {
            return;
        }
        Iterator<DirectoryEntry> iterator = children.iterator();
        while (iterator.hasNext()) {
            DirectoryEntry entry = iterator.next();
            if (!this.myUrl.equals(entry.getUrl())) continue;
            iterator.remove();
        }
        this.myCache.put(parentUrl, children);
    }

    public void addSyntheticChildToSelf(Url newUrl, Url repositoryUrl, String name, boolean isDir) {
        List<DirectoryEntry> children = this.myCache.getChildren(this.myUrl);
        if (children == null) {
            return;
        }
        children.add(SyntheticWorker.createSyntheticEntry(newUrl, repositoryUrl, name, isDir));
        children.sort(DirectoryEntry.CASE_INSENSITIVE_ORDER);
        this.myCache.put(this.myUrl, children);
    }

    public void copyTreeToSelf(RepositoryTreeNode node) {
        try {
            node.doOnSubtree(new Adder(SvnUtil.removePathTail(node.getURL()).toString().length(), this.myUrl));
        }
        catch (SvnBindException svnBindException) {
            // empty catch block
        }
    }

    public static void removeTreeOf(RepositoryTreeNode node) {
        node.doOnSubtree(new Remover());
    }

    public static DirectoryEntry createSyntheticEntry(Url newUrl, Url repositoryUrl, String name, boolean isDir) {
        return new DirectoryEntry(newUrl, repositoryUrl, name, NodeKind.from(isDir), CommitInfo.EMPTY, null);
    }

    private final class Adder
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final int myOldPrefixLen;
        private final Url myNewParentUrl;

        private Adder(int oldPrefixLen, Url newParentUrl) {
            this.myOldPrefixLen = oldPrefixLen;
            this.myNewParentUrl = newParentUrl;
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            List<DirectoryEntry> children = SyntheticWorker.this.myCache.getChildren(repositoryTreeNode.getURL());
            if (children == null) {
                Boolean bl = Boolean.FALSE;
                if (bl == null) {
                    Adder.$$$reportNull$$$0(0);
                }
                return bl;
            }
            ArrayList<DirectoryEntry> newChildren = new ArrayList<DirectoryEntry>(children.size());
            try {
                for (DirectoryEntry child : children) {
                    newChildren.add(SyntheticWorker.createSyntheticEntry(this.convertUrl(child.getUrl()), child.getRepositoryRoot(), child.getName(), child.isDirectory()));
                }
                SyntheticWorker.this.myCache.put(this.convertUrl(repositoryTreeNode.getURL()), newChildren);
            }
            catch (SvnBindException svnBindException) {
                // empty catch block
            }
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                Adder.$$$reportNull$$$0(1);
            }
            return bl;
        }

        @NotNull
        private Url convertUrl(@NotNull Url currentUrl) throws SvnBindException {
            if (currentUrl == null) {
                Adder.$$$reportNull$$$0(2);
            }
            Url url = SvnUtil.append(this.myNewParentUrl, currentUrl.toString().substring(this.myOldPrefixLen), true);
            if (url == null) {
                Adder.$$$reportNull$$$0(3);
            }
            return url;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Adder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Adder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Remover
    implements NotNullFunction<RepositoryTreeNode, Object> {
        private final SvnRepositoryCache myCache = SvnRepositoryCache.getInstance();

        private Remover() {
        }

        @NotNull
        public Object fun(RepositoryTreeNode repositoryTreeNode) {
            this.myCache.remove(repositoryTreeNode.getURL());
            Boolean bl = Boolean.FALSE;
            if (bl == null) {
                Remover.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/SyntheticWorker$Remover", "fun"));
        }
    }
}

