/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.lang.parser.CoffeeScriptStubElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoffeeScriptDocStringUtil {
    public static final String DOC_STRING_LITERAL = "\"\"\"";

    public static String getDocStringValue(@NotNull String elementText, @Nullable List<? super TextRange> ranges) {
        if (elementText == null) {
            CoffeeScriptDocStringUtil.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            ranges = new ArrayList<TextRange>();
        }
        String text = elementText.substring(DOC_STRING_LITERAL.length(), elementText.length() - DOC_STRING_LITERAL.length());
        String[] lines = text.split("\n");
        int spaceLineCount = 0;
        int minSpace = Integer.MAX_VALUE;
        int spaceLineIndex = -1;
        for (int i = 1; i < lines.length; ++i) {
            int j;
            String s = lines[i];
            for (j = 0; j < s.length() && s.charAt(j) == ' '; ++j) {
            }
            if (j == 0 && s.length() > 0) {
                minSpace = 0;
                continue;
            }
            if (j <= 0) continue;
            ++spaceLineCount;
            if (minSpace <= j) continue;
            minSpace = j;
            spaceLineIndex = i;
        }
        if (minSpace == Integer.MAX_VALUE) {
            minSpace = 0;
        }
        int offset = 4;
        StringBuilder result = new StringBuilder();
        if (lines.length > 0 && lines[0].length() > 0) {
            result.append(lines[0]).append("\n");
            int lineBreak = lines.length > 1 ? 1 : 0;
            ranges.add((TextRange)new TextRange(--offset, offset + lines[0].length() + lineBreak));
            offset += lines[0].length();
            if (lines.length > 1) {
                ++offset;
            }
        }
        boolean firstNonEmptyLine = true;
        for (int i = 1; i < lines.length; ++i) {
            int lineBreak = i < lines.length - 1 ? 1 : 0;
            String s = lines[i];
            if (s.length() > 0) {
                String toAdd;
                if (firstNonEmptyLine && i == spaceLineIndex) {
                    toAdd = s.trim();
                    int spaceCount = s.length() - toAdd.length();
                    result.append(toAdd);
                    ranges.add((TextRange)new TextRange(spaceCount + offset, spaceCount + offset + toAdd.length() + lineBreak));
                } else if (spaceLineCount != 1) {
                    toAdd = s.substring(minSpace);
                    result.append(toAdd);
                    ranges.add((TextRange)new TextRange(minSpace + offset, minSpace + offset + toAdd.length() + lineBreak));
                } else {
                    result.append(s);
                    ranges.add((TextRange)new TextRange(minSpace + offset, minSpace + offset + s.length() + lineBreak));
                }
                firstNonEmptyLine = false;
            } else {
                ranges.add((TextRange)new TextRange(offset, offset + s.length() + lineBreak));
            }
            result.append('\n');
            offset += s.length() + 1;
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static List<TextRange> getDocStringValue(@NotNull String elementText) {
        if (elementText == null) {
            CoffeeScriptDocStringUtil.$$$reportNull$$$0(1);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        CoffeeScriptDocStringUtil.getDocStringValue(elementText, result);
        return result;
    }

    public static boolean isDocString(@NotNull ASTNode node) {
        if (node == null) {
            CoffeeScriptDocStringUtil.$$$reportNull$$$0(2);
        }
        return node.getElementType() == CoffeeScriptStubElementTypes.HEREDOC;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/CoffeeScriptDocStringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocStringValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

