/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ChecksumAndSignatureVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.WriteDependencyVerificationFile;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class StartParameterResolutionOverride {
    private final StartParameter startParameter;
    private final File gradleDir;

    public StartParameterResolutionOverride(StartParameter startParameter, File gradleDir) {
        this.startParameter = startParameter;
        this.gradleDir = gradleDir;
    }

    public void applyToCachePolicy(CachePolicy cachePolicy) {
        if (this.startParameter.isOffline()) {
            cachePolicy.setOffline();
        } else if (this.startParameter.isRefreshDependencies()) {
            cachePolicy.setRefreshDependencies();
        }
    }

    public ModuleComponentRepository overrideModuleVersionRepository(ModuleComponentRepository original) {
        if (this.startParameter.isOffline()) {
            return new OfflineModuleComponentRepository(original);
        }
        return original;
    }

    public DependencyVerificationOverride dependencyVerificationOverride(BuildOperationExecutor buildOperationExecutor, ChecksumService checksumService, SignatureVerificationServiceFactory signatureVerificationServiceFactory, DocumentationRegistry documentationRegistry, BuildCommencedTimeProvider timeProvider, Factory<GradleProperties> gradlePropertiesFactory) {
        List<String> checksums = this.startParameter.getWriteDependencyVerifications();
        if (!checksums.isEmpty()) {
            return DisablingVerificationOverride.of(new WriteDependencyVerificationFile(this.gradleDir, buildOperationExecutor, checksums, checksumService, signatureVerificationServiceFactory, this.startParameter.isDryRun(), this.startParameter.isExportKeys()));
        }
        File verificationsFile = DependencyVerificationOverride.dependencyVerificationsFile(this.gradleDir);
        File keyringsFile = DependencyVerificationOverride.keyringsFile(this.gradleDir);
        if (verificationsFile.exists()) {
            if (this.startParameter.getDependencyVerificationMode() == DependencyVerificationMode.OFF) {
                return DependencyVerificationOverride.NO_VERIFICATION;
            }
            try {
                File sessionReportDir = this.computeReportDirectory(timeProvider);
                return DisablingVerificationOverride.of(new ChecksumAndSignatureVerificationOverride(buildOperationExecutor, this.startParameter.getGradleUserHomeDir(), verificationsFile, keyringsFile, checksumService, signatureVerificationServiceFactory, this.startParameter.getDependencyVerificationMode(), documentationRegistry, sessionReportDir, gradlePropertiesFactory));
            }
            catch (Exception e) {
                return new FailureVerificationOverride(e);
            }
        }
        return DependencyVerificationOverride.NO_VERIFICATION;
    }

    private File computeReportDirectory(BuildCommencedTimeProvider timeProvider) {
        File buildDir = new File(this.gradleDir.getParentFile(), "build");
        File reportsDirectory = new File(buildDir, "reports");
        File verifReportsDirectory = new File(reportsDirectory, "dependency-verification");
        return new File(verifReportsDirectory, "at-" + timeProvider.getCurrentTime());
    }

    public ExternalResourceCachePolicy overrideExternalResourceCachePolicy(ExternalResourceCachePolicy original) {
        if (this.startParameter.isOffline()) {
            return ageMillis -> false;
        }
        return original;
    }

    public ExternalResourceConnector overrideExternalResourceConnector(ExternalResourceConnector original) {
        if (this.startParameter.isOffline()) {
            return new OfflineExternalResourceConnector();
        }
        return original;
    }

    public static class DisablingVerificationOverride
    implements DependencyVerificationOverride,
    Stoppable {
        private static final Logger LOGGER = Logging.getLogger(DependencyVerificationOverride.class);
        private final DependencyVerificationOverride delegate;

        public static DisablingVerificationOverride of(DependencyVerificationOverride delegate) {
            return new DisablingVerificationOverride(delegate);
        }

        private DisablingVerificationOverride(DependencyVerificationOverride delegate) {
            this.delegate = delegate;
        }

        @Override
        public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original, String resolveContextName, ResolutionStrategyInternal resolutionStrategy) {
            if (resolutionStrategy.isDependencyVerificationEnabled()) {
                return this.delegate.overrideDependencyVerification(original, resolveContextName, resolutionStrategy);
            }
            LOGGER.warn("Dependency verification has been disabled for configuration " + resolveContextName);
            return original;
        }

        @Override
        public void buildFinished(Gradle gradle) {
            this.delegate.buildFinished(gradle);
        }

        @Override
        public void artifactsAccessed(String displayName) {
            this.delegate.artifactsAccessed(displayName);
        }

        @Override
        public ResolvedArtifactResult verifiedArtifact(ResolvedArtifactResult artifact) {
            return this.delegate.verifiedArtifact(artifact);
        }

        @Override
        public void stop() {
            if (this.delegate instanceof Stoppable) {
                ((Stoppable)((Object)this.delegate)).stop();
            } else if (this.delegate instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.delegate)).close();
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        }
    }

    private static class FailureVerificationOverride
    implements DependencyVerificationOverride {
        private final Exception error;

        private FailureVerificationOverride(Exception error) {
            this.error = error;
        }

        @Override
        public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original, String resolveContextName, ResolutionStrategyInternal resolutionStrategy) {
            throw new GradleException("Dependency verification cannot be performed", this.error);
        }
    }

    private static class OfflineExternalResourceConnector
    implements ExternalResourceConnector {
        private OfflineExternalResourceConnector() {
        }

        @Override
        @Nullable
        public ExternalResourceReadResponse openResource(URI location, boolean revalidate) throws ResourceException {
            throw this.offlineResource(location);
        }

        @Override
        @Nullable
        public ExternalResourceMetaData getMetaData(URI location, boolean revalidate) throws ResourceException {
            throw this.offlineResource(location);
        }

        @Override
        @Nullable
        public List<String> list(URI parent) throws ResourceException {
            throw this.offlineResource(parent);
        }

        @Override
        public void upload(ReadableContent resource, URI destination) throws IOException {
            throw new ResourceException(destination, String.format("Cannot upload to '%s' in offline mode.", destination));
        }

        private ResourceException offlineResource(URI source) {
            return new ResourceException(source, String.format("No cached resource '%s' available for offline mode.", source));
        }
    }

    private static class FailedRemoteAccess
    implements ModuleComponentRepositoryAccess {
        private FailedRemoteAccess() {
        }

        public String toString() {
            return "offline remote";
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            result.failed(new ModuleVersionResolveException((ComponentSelector)dependency.getSelector(), () -> String.format("No cached version listing for %s available for offline mode.", dependency.getSelector())));
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            result.failed(new ModuleVersionResolveException(moduleComponentIdentifier, () -> String.format("No cached version of %s available for offline mode.", moduleComponentIdentifier.getDisplayName())));
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            result.failed(new ArtifactResolveException(component.getId(), "No cached version available for offline mode"));
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, ConfigurationMetadata variant, BuildableComponentArtifactsResolveResult result) {
            result.failed(new ArtifactResolveException(component.getId(), "No cached version available for offline mode"));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactResolveResult result) {
            result.failed(new ArtifactResolveException(artifact.getId(), "No cached version available for offline mode"));
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return MetadataFetchingCost.CHEAP;
        }
    }

    private static class OfflineModuleComponentRepository
    extends BaseModuleComponentRepository {
        private final FailedRemoteAccess failedRemoteAccess = new FailedRemoteAccess();

        public OfflineModuleComponentRepository(ModuleComponentRepository original) {
            super(original);
        }

        @Override
        public ModuleComponentRepositoryAccess getRemoteAccess() {
            return this.failedRemoteAccess;
        }
    }
}

