/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.DependencyVerificationReportRenderer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationHighLevelErrors;
import org.gradle.api.internal.artifacts.verification.verifier.ChecksumVerificationFailure;
import org.gradle.api.internal.artifacts.verification.verifier.DeletedArtifact;
import org.gradle.api.internal.artifacts.verification.verifier.MissingChecksums;
import org.gradle.api.internal.artifacts.verification.verifier.MissingSignature;
import org.gradle.api.internal.artifacts.verification.verifier.OnlyIgnoredKeys;
import org.gradle.api.internal.artifacts.verification.verifier.SignatureVerificationFailure;
import org.gradle.api.internal.artifacts.verification.verifier.VerificationFailure;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.apache.commons.lang.StringEscapeUtils;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;

class HtmlDependencyVerificationReportRenderer
implements DependencyVerificationReportRenderer {
    private final Map<String, Section> sections = Maps.newTreeMap();
    private Section currentSection;
    private final StringBuilder contents = new StringBuilder();
    private final DocumentationRegistry documentationRegistry;
    private final File verificationFile;
    private final List<String> writeFlags;
    private final File htmlReportOutputDirectory;

    HtmlDependencyVerificationReportRenderer(DocumentationRegistry documentationRegistry, File verificationFile, List<String> writeFlags, File htmlReportOutputDirectory) {
        this.documentationRegistry = documentationRegistry;
        this.verificationFile = verificationFile;
        this.writeFlags = writeFlags;
        this.htmlReportOutputDirectory = htmlReportOutputDirectory;
    }

    @Override
    public void startNewSection(String title) {
        this.currentSection = this.sections.get(title);
        if (this.currentSection == null) {
            this.currentSection = new Section(title);
            this.sections.put(title, this.currentSection);
        }
    }

    @Override
    public void startArtifactErrors(Runnable action) {
        action.run();
    }

    @Override
    public void startNewArtifact(ModuleComponentArtifactIdentifier key, Runnable action) {
        this.currentSection.newArtifact(new ArtifactErrors(key));
        action.run();
    }

    @Override
    public void reportFailure(RepositoryAwareVerificationFailure failure) {
        this.currentSection.currentArtifact.addFailure(failure);
    }

    @Override
    public void reportAsMultipleErrors(Runnable action) {
        action.run();
    }

    @Override
    public void finish(VerificationHighLevelErrors highLevelErrors) {
    }

    public void renderNavBar() {
        this.contents.append("<nav class=\"uk-navbar-container\" uk-navbar>\n    <div class=\"uk-navbar-left\">\n        <a href=\"\" class=\"uk-navbar-item uk-logo\"><img src=\"img/gradle-logo.png\" width=\"120\"></a>\n        <ul class=\"uk-navbar-nav\">\n<li class=\"uk-active\"><a href=\"#\">Dependency verification report</a></li>\n        </ul>\n    </div>\n</nav>\n\n");
    }

    public void renderSections() {
        this.contents.append("<div class=\"uk-container uk-container-expand\">\n");
        this.contents.append("        <ul uk-accordion>\n");
        boolean first = true;
        for (Section section : this.sections.values()) {
            if (first) {
                this.contents.append("            <li class=\"uk-open\">\n");
            } else {
                this.contents.append("            <li>\n");
            }
            this.prerenderSection(section);
            this.renderSection(section);
            this.contents.append("            </li>\n");
            first = false;
        }
        this.contents.append("         </ul>\n");
        this.contents.append("        </div>\n");
    }

    File writeReport() {
        this.generateContent();
        this.ensureReportDirectoryCreated();
        this.copyReportResources();
        return this.doWriteReport();
    }

    private void ensureReportDirectoryCreated() {
        this.htmlReportOutputDirectory.mkdirs();
    }

    private void copyReportResources() {
        this.copyReportResource(this.htmlReportOutputDirectory, "css", "uikit.min.css");
        this.copyReportResource(this.htmlReportOutputDirectory, "js", "uikit.min.js");
        this.copyReportResource(this.htmlReportOutputDirectory, "js", "uikit-icons.min.js");
        this.copyReportResource(this.htmlReportOutputDirectory, "img", "gradle-logo.png");
    }

    private File doWriteReport() {
        File reportFile = new File(this.htmlReportOutputDirectory, "dependency-verification-report.html");
        try (OutputStreamWriter prn = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile, false), StandardCharsets.UTF_8);){
            prn.write(this.contents.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return reportFile;
    }

    private void generateContent() {
        this.contents.setLength(0);
        this.contents.append("<!DOCTYPE html>\n<html>\n    <head>\n        <title>Dependency verification report</title>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n        <link rel=\"stylesheet\" href=\"css/uikit.min.css\" />\n        <script src=\"js/uikit.min.js\"></script>\n        <script src=\"js/uikit-icons.min.js\"></script>\n    </head>\n    <body>\n");
        this.renderNavBar();
        this.renderSections();
        this.registerModals();
        this.registerStickyTip();
        this.contents.append("    </body>\n</html>\n\n");
    }

    private void registerStickyTip() {
        this.contents.append("    <div class=\"uk-container uk-padding\">\n");
        this.contents.append("        <div class=\"uk-card uk-card-default uk-card-body\" style=\"z-index: 980;\" uk-sticky=\"bottom: true\">\n");
        this.contents.append("            <h2 class=\"uk-modal-title\">Troubleshooting</h2>\n");
        this.contents.append("            <p>Please review the errors reported above carefully.");
        this.contents.append("            Click on the icons near to the error descriptions for information about how to fix a particular problem.");
        this.contents.append("            It is recommended that you edit the ").append(this.verificationFileLink()).append(" manually. ");
        this.contents.append("            However, if you are confident that those are false positives, Gradle can help you by generating the missing verification metadata.");
        this.contents.append("            In this case, you can run with the following command-line:</p>");
        this.contents.append("            <pre>gradle --write-verification-metadata ").append(this.verificationOptions()).append(" help</pre>");
        this.contents.append("            <p>In any case you <b>must review the result</b> of this operation.");
        this.contents.append("            <p>Please refer to the <a href=\"").append(this.documentationRegistry.getDocumentationFor("dependency_verification")).append("\" target=\"_blank\">documentation</a> for more information.</p>\n");
        this.contents.append("        </div>\n");
        this.contents.append("    </div>\n");
    }

    private String verificationOptions() {
        return String.join((CharSequence)",", this.writeFlags);
    }

    private String verificationFileLink() {
        return "<a href=\"" + this.verificationFile.toURI().toASCIIString() + "\">verification file</a>";
    }

    private void registerModal(String id, String title, String ... lines) {
        this.contents.append("<div id=\"").append(id).append("\" uk-modal>\n").append("    <div class=\"uk-modal-dialog uk-modal-body\">\n").append("        <h2 class=\"uk-modal-title\">").append(title).append("</h2>\n");
        for (String line : lines) {
            this.contents.append(line).append("\n");
        }
        this.contents.append("        <p>See the <a href=\"").append(this.documentationRegistry.getDocumentationFor("dependency_verification", "sec:signature-verification")).append("\" target=\"_blank\">documentation</a> to get more information.</p>\n").append("        <button class=\"uk-button uk-button-primary uk-modal-close\" type=\"button\">Ok</button>\n").append("    </div>\n").append("</div>\n");
    }

    private void registerModals() {
        this.registerModal("verified-not-trusted", "Key isn't trusted", "        <p>This indicates that a dependency was <i>verified</i>, that the signature matched, but that you don't <i>trust</i> this signature.</p>\n", "        <p>If you trust the author of the signature, you need to add the key to the trusted keys.</p>");
        this.registerModal("signature-didnt-match", "Signature didn't match", "        <p>This indicates that a dependency was <i>signed</i> but that the signature verification <b>failed</b>.</p>", "        <p>This happens when a dependency was compromised or that the signature was made for a different artifact than the one you got.</p>", "        <p>It's important that you <b>carefully review this problem</b>.</p>");
        this.registerModal("ignored-key", "A key was ignored", "        <p>This indicates that a dependency was <i>signed with an ignored key</i>.</p>", "        <p>You must provide at least one checksum so that verification can pass.</p>");
        this.registerModal("missing-key", "Public key couldn't be found", "        <p>This indicates that a dependency was <i>signed</i> but that Gradle couldn't download the public key to verify the signature.</p>", "        <p>You should check if the key is valid, and if so, provide a key server where to download it.</p>");
        this.registerModal("missing-checksums", "Checksums are missing", "        <p>This indicates that the dependency verification file doesn't contain at least one checksum for this artifact.</p>", "        <p>You must provide at least one checksum for artifact verification to pass.</p>");
        this.registerModal("checksum-mismatch", "Incorrect checksum", "        <p>This indicates that the dependency verification file <b>failed</b> because the actual checksum of the dependency artifact didn't match the expected checksum declared in the verification metadata.</p>", "        <p>This happens when a dependency was compromised or that downloaded artifact isn't the one that you expected.</p>", "        <p>It's important that you <b>carefully review this problem</b>.</p>");
        this.registerModal("deleted-artifact", "Deleted artifact", "        <p>This error usually indicated that the local dependency cache was tampered with.</p>", "        <p>This happens when someone manually deletes an artifact from the Gradle dependency cache, which is now corrupt.</p>");
        this.registerModal("signature-file-missing", "Missing signature file", "        <p>The signature file for this artifact wasn't found.</p>", "        <p>Usually it indicates that the signature doesn't exist in the repository the artifact was downloaded from.</p>", "        <p>In general this is not a problem but you should then declare at least one checksum for verification to pass.</p>");
    }

    private void copyReportResource(File outputDirectory, String dirName, String fileName) {
        File targetDir = new File(outputDirectory, dirName);
        targetDir.mkdirs();
        this.copyResource(fileName, new File(targetDir, fileName));
    }

    private void copyResource(String name, File outputFile) {
        try (InputStream in = this.getClass().getResourceAsStream(name);){
            Files.copy(in, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void prerenderSection(Section section) {
        int size = section.errors.size();
        this.contents.append("<a class=\"uk-accordion-title\" href=\"#\"><span uk-icon=\"chevron-right\"></span>").append(section.title).append("&nbsp;<span class=\"uk-badge\">").append(size).append(size < 2 ? " error" : " errors").append("</span></a>");
    }

    private void renderSection(Section section) {
        this.contents.append("<div class=\"uk-accordion-content\">").append("<table class=\"uk-table uk-table-hover uk-table-divider uk-table-middle uk-table-small\">\n").append("    <thead>\n").append("        <tr>\n").append("            <th class=\"uk-table-shrink uk-width-auto uk-text-nowrap\">Module</th>\n").append("            <th class=\"uk-table-shrink uk-width-auto uk-text-nowrap\">Artifact</th>\n").append("            <th class=\"uk-table-shrink uk-width-expand\">Problem(s)</th>\n").append("        </tr>\n").append("    </thead>\n").append("    <tbody>\n");
        section.errors.forEach(this::formatErrors);
        this.contents.append("    </tbody>\n</table>").append("</div>");
    }

    private void formatErrors(ArtifactErrors currentArtifact) {
        this.contents.append("        <tr>\n");
        RepositoryAwareVerificationFailure firstFailure = currentArtifact.failures.get(0);
        this.reportItem(currentArtifact.key.getComponentIdentifier().getDisplayName());
        this.reportItem(this.createFileLink(currentArtifact.key, firstFailure.getFailure(), firstFailure.getRepositoryName()));
        this.contents.append("            <td>\n");
        currentArtifact.failures.forEach(this::formatError);
        this.contents.append("            </td>\n");
        this.contents.append("        </tr>\n");
    }

    private void formatError(RepositoryAwareVerificationFailure failure) {
        VerificationFailure vf = failure.getFailure();
        this.reportSignatureProblems(vf);
        this.reportChecksumProblems(vf);
        this.reportOtherProblems(vf);
    }

    private String createFileLink(ModuleComponentArtifactIdentifier key, VerificationFailure vf, String repositoryName) {
        File signatureFile;
        String fileLink = "<div uk-tooltip=\"title: From repository '" + repositoryName + "'\">";
        fileLink = fileLink + "<a href=\"" + vf.getFilePath().toURI().toASCIIString() + "\">" + key.getFileName() + "</a>";
        if (vf instanceof SignatureVerificationFailure && (signatureFile = ((SignatureVerificationFailure)vf).getSignatureFile()) != null) {
            fileLink = fileLink + "&nbsp;<a href=\"" + signatureFile.toURI().toASCIIString() + "\">(.asc)</a>";
        }
        fileLink = fileLink + "</div>";
        return fileLink;
    }

    private void reportOtherProblems(VerificationFailure vf) {
        if (vf instanceof DeletedArtifact) {
            String reason = "Artifact has been deleted from dependency cache";
            this.reportItem(reason, "deleted-artifact", "info");
        }
    }

    private void reportChecksumProblems(VerificationFailure vf) {
        if (vf instanceof MissingChecksums) {
            String reason = HtmlDependencyVerificationReportRenderer.warning("Checksums are missing from verification metadata");
            this.reportItem(reason, "missing-checksums", "info");
        } else if (vf instanceof ChecksumVerificationFailure) {
            ChecksumVerificationFailure cvf = (ChecksumVerificationFailure)vf;
            String reason = "Expected a " + (Object)((Object)cvf.getKind()) + " checksum of " + HtmlDependencyVerificationReportRenderer.expected(cvf.getExpected()) + " but was " + HtmlDependencyVerificationReportRenderer.actual(cvf.getActual());
            this.reportItem(reason, "checksum-mismatch", "warning");
        } else if (vf instanceof OnlyIgnoredKeys) {
            String reason = "All public keys have been ignored";
            this.reportItem(reason, "missing-checksums", "info");
        }
    }

    private static String expected(String text) {
        return HtmlDependencyVerificationReportRenderer.emphatize(text, "blue");
    }

    private static String actual(String text) {
        return HtmlDependencyVerificationReportRenderer.emphatize(text, "#ee442f");
    }

    private static String warning(String text) {
        return HtmlDependencyVerificationReportRenderer.emphatize(text, "#c59434");
    }

    private static String grey(String text) {
        return HtmlDependencyVerificationReportRenderer.emphatize(text, "#cccccc");
    }

    private static String emphatize(String text, String color) {
        return "<span style=\"font-weight:bold; color: " + color + "\">" + text + "</span>";
    }

    private void reportSignatureProblems(VerificationFailure vf) {
        if (vf instanceof MissingSignature) {
            this.reportItem("Signature file is missing", "signature-file-missing", "info");
        } else if (vf instanceof SignatureVerificationFailure) {
            SignatureVerificationFailure svf = (SignatureVerificationFailure)vf;
            Map<String, SignatureVerificationFailure.SignatureError> errors = svf.getErrors();
            errors.forEach((keyId, error) -> {
                StringBuilder sb = new StringBuilder();
                PGPPublicKey publicKey = error.getPublicKey();
                if (publicKey != null) {
                    svf.appendKeyDetails(sb, publicKey);
                } else {
                    sb.append("(not found)");
                }
                String keyDetails = StringEscapeUtils.escapeHtml((String)sb.toString());
                String keyInfo = "<b>" + keyId + " " + keyDetails + "</b>";
                switch (error.getKind()) {
                    case PASSED_NOT_TRUSTED: {
                        String reason = HtmlDependencyVerificationReportRenderer.warning("Artifact was signed with key " + keyInfo + " but this key is not in your trusted key list");
                        this.reportItem(reason, "verified-not-trusted", "question");
                        break;
                    }
                    case FAILED: {
                        String reason = HtmlDependencyVerificationReportRenderer.actual("Artifact was signed with key " + keyInfo + " but signature didn't match");
                        this.reportItem(reason, "signature-didnt-match", "warning");
                        break;
                    }
                    case IGNORED_KEY: {
                        String reason = HtmlDependencyVerificationReportRenderer.grey("Artifact was signed with an ignored key: " + keyInfo);
                        this.reportItem(reason, "ignored-key", "info");
                        break;
                    }
                    case MISSING_KEY: {
                        String reason = HtmlDependencyVerificationReportRenderer.warning("Key " + keyInfo + " couldn't be found in any key server so verification couldn't be performed");
                        this.reportItem(reason, "missing-key", "warning");
                    }
                }
            });
        }
    }

    private void reportItem(String item) {
        this.contents.append("            <td class=\"uk-text-nowrap\"");
        this.contents.append(">").append(item).append("</td>\n");
    }

    private void reportItem(String item, String tipTarget, String tipIcon) {
        String tip = "<a uk-toggle=\"target: #" + tipTarget + "\" uk-icon=\"icon: " + tipIcon + "\"></a>";
        this.contents.append("            <p>").append(item).append("&nbsp;").append(tip).append("</p>\n");
    }

    private static class ArtifactErrors {
        final ModuleComponentArtifactIdentifier key;
        final List<RepositoryAwareVerificationFailure> failures = Lists.newArrayList();

        private ArtifactErrors(ModuleComponentArtifactIdentifier key) {
            this.key = key;
        }

        void addFailure(RepositoryAwareVerificationFailure failure) {
            this.failures.add(failure);
        }
    }

    private static class Section {
        private final String title;
        private final List<ArtifactErrors> errors = Lists.newArrayList();
        private ArtifactErrors currentArtifact;

        private Section(String title) {
            this.title = title;
        }

        public void newArtifact(ArtifactErrors artifactErrors) {
            this.errors.add(artifactErrors);
            this.currentArtifact = artifactErrors;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

