/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.filestore.ArtifactIdentifierFileStore;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public class TwoStageArtifactIdentifierFileStore
implements ArtifactIdentifierFileStore {
    private final ArtifactIdentifierFileStore readOnlyStore;
    private final ArtifactIdentifierFileStore writableStore;
    private final FileAccessTracker fileAccessTracker;

    public TwoStageArtifactIdentifierFileStore(ArtifactIdentifierFileStore readOnlyStore, ArtifactIdentifierFileStore writableStore) {
        this.readOnlyStore = readOnlyStore;
        this.writableStore = writableStore;
        this.fileAccessTracker = new DelegatingFileAccessTracker();
    }

    @Override
    public File whereIs(ModuleComponentArtifactIdentifier artifactId, String checksum) {
        File file = this.writableStore.whereIs(artifactId, checksum);
        if (file.exists()) {
            return file;
        }
        return this.readOnlyStore.whereIs(artifactId, checksum);
    }

    @Override
    public FileAccessTracker getFileAccessTracker() {
        return this.fileAccessTracker;
    }

    @Override
    public LocallyAvailableResource move(ModuleComponentArtifactIdentifier key, File source) throws FileStoreException {
        return this.writableStore.move(key, source);
    }

    @Override
    public LocallyAvailableResource add(ModuleComponentArtifactIdentifier key, Action<File> addAction) throws FileStoreException {
        return this.writableStore.add(key, addAction);
    }

    @Override
    public Set<? extends LocallyAvailableResource> search(ModuleComponentArtifactIdentifier key) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.writableStore.search(key));
        builder.addAll(this.readOnlyStore.search(key));
        return builder.build();
    }

    private class DelegatingFileAccessTracker
    implements FileAccessTracker {
        private DelegatingFileAccessTracker() {
        }

        @Override
        public void markAccessed(File file) {
            TwoStageArtifactIdentifierFileStore.this.readOnlyStore.getFileAccessTracker().markAccessed(file);
            TwoStageArtifactIdentifierFileStore.this.writableStore.getFileAccessTracker().markAccessed(file);
        }
    }
}

