/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.processing.DelegatingProcessor;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Stopwatch;
import org.gradle.internal.impldep.com.google.common.base.Ticker;

public class TimeTrackingProcessor
extends DelegatingProcessor {
    private final AnnotationProcessorResult result;
    private final Stopwatch stopwatch;

    public TimeTrackingProcessor(Processor delegate, AnnotationProcessorResult result) {
        this(delegate, result, Ticker.systemTicker());
    }

    @VisibleForTesting
    protected TimeTrackingProcessor(Processor delegate, AnnotationProcessorResult result, Ticker ticker) {
        super(delegate);
        this.result = result;
        this.stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return this.track(new Factory<Set<String>>(){

            @Override
            public Set<String> create() {
                return TimeTrackingProcessor.super.getSupportedOptions();
            }
        });
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.track(new Factory<Set<String>>(){

            @Override
            public Set<String> create() {
                return TimeTrackingProcessor.super.getSupportedAnnotationTypes();
            }
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return this.track(new Factory<SourceVersion>(){

            @Override
            public SourceVersion create() {
                return TimeTrackingProcessor.super.getSupportedSourceVersion();
            }
        });
    }

    @Override
    public void init(final ProcessingEnvironment processingEnv) {
        this.track(new Factory<Void>(){

            @Override
            public Void create() {
                TimeTrackingProcessor.super.init(processingEnv);
                return null;
            }
        });
    }

    @Override
    public boolean process(final Set<? extends TypeElement> annotations, final RoundEnvironment roundEnv) {
        return this.track(new Factory<Boolean>(){

            @Override
            public Boolean create() {
                return TimeTrackingProcessor.super.process(annotations, roundEnv);
            }
        });
    }

    @Override
    public Iterable<? extends Completion> getCompletions(final Element element, final AnnotationMirror annotation, final ExecutableElement member, final String userText) {
        return this.track(new Factory<Iterable<? extends Completion>>(){

            @Override
            public Iterable<? extends Completion> create() {
                return TimeTrackingProcessor.super.getCompletions(element, annotation, member, userText);
            }
        });
    }

    private <T> T track(Factory<T> factory) {
        this.stopwatch.start();
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.stopwatch.stop();
            this.result.setExecutionTimeInMillis(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

