/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.logging.ClassMethodNameStackTraceSpec;
import org.gradle.api.internal.tasks.testing.logging.GroovyStackTraceSpec;
import org.gradle.api.internal.tasks.testing.logging.StackTraceFilter;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TruncatedStackTraceSpec;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestStackTraceFilter;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.internal.TextUtil;

public class FullExceptionFormatter
implements TestExceptionFormatter {
    private static final String INDENT = "    ";
    private final TestLogging testLogging;

    public FullExceptionFormatter(TestLogging testLogging) {
        this.testLogging = testLogging;
    }

    @Override
    public String format(TestDescriptor descriptor, List<Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < exceptions.size(); ++i) {
            this.printException(descriptor, exceptions.get(i), null, 0, builder);
            if (i >= exceptions.size() - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    private void printException(TestDescriptor descriptor, Throwable exception, @Nullable List<StackTraceElement> parentTrace, int exceptionLevel, StringBuilder builder) {
        String exceptionIndent = Strings.repeat((String)INDENT, (int)(exceptionLevel + 1));
        String exceptionText = exceptionLevel == 0 ? exception.toString() : "\nCaused by:\n" + exception.toString();
        String indentedText = TextUtil.indent(exceptionText, exceptionIndent);
        builder.append(indentedText);
        builder.append('\n');
        String stackTraceIndent = exceptionIndent + INDENT;
        List<StackTraceElement> stackTrace = null;
        if (this.testLogging.getShowStackTraces()) {
            stackTrace = this.filterStackTrace(exception, descriptor);
            int commonElements = this.countCommonElements(stackTrace, parentTrace);
            for (int i = 0; i < stackTrace.size() - commonElements; ++i) {
                builder.append(stackTraceIndent);
                builder.append("at ");
                builder.append(stackTrace.get(i));
                builder.append('\n');
            }
            if (commonElements != 0) {
                builder.append(stackTraceIndent);
                builder.append("... ");
                builder.append(commonElements);
                builder.append(" more");
                builder.append('\n');
            }
        }
        if (this.testLogging.getShowCauses() && exception.getCause() != null) {
            this.printException(descriptor, exception.getCause(), stackTrace, exceptionLevel + 1, builder);
        }
    }

    private List<StackTraceElement> filterStackTrace(Throwable exception, TestDescriptor descriptor) {
        Spec<StackTraceElement> filterSpec = this.createCompositeFilter(descriptor);
        StackTraceFilter filter = new StackTraceFilter(filterSpec);
        return filter.filter(exception);
    }

    private Spec<StackTraceElement> createCompositeFilter(TestDescriptor descriptor) {
        ArrayList filters = Lists.newArrayList();
        for (TestStackTraceFilter type : this.testLogging.getStackTraceFilters()) {
            filters.add(this.createFilter(descriptor, type));
        }
        return new AndSpec<StackTraceElement>(filters);
    }

    private Spec<StackTraceElement> createFilter(TestDescriptor descriptor, TestStackTraceFilter filterType) {
        switch (filterType) {
            case ENTRY_POINT: {
                return new ClassMethodNameStackTraceSpec(descriptor.getClassName(), descriptor.getName());
            }
            case TRUNCATE: {
                return new TruncatedStackTraceSpec(new ClassMethodNameStackTraceSpec(descriptor.getClassName(), null));
            }
            case GROOVY: {
                return new GroovyStackTraceSpec();
            }
        }
        throw new AssertionError();
    }

    private int countCommonElements(List<StackTraceElement> stackTrace, @Nullable List<StackTraceElement> parentTrace) {
        if (parentTrace == null) {
            return 0;
        }
        int commonElements = 0;
        int i = stackTrace.size() - 1;
        for (int j = parentTrace.size() - 1; i >= 1 && j >= 0 && stackTrace.get(i).equals(parentTrace.get(j)); --i, --j) {
            ++commonElements;
        }
        return commonElements;
    }
}

