/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;

public abstract class AbstractRenderableDependencyResult
extends AbstractRenderableDependency {
    @Override
    public ComponentIdentifier getId() {
        return this.getActual();
    }

    @Override
    public String getName() {
        ComponentIdentifier selected;
        ComponentSelector requested = this.getRequested();
        if (this.exactMatch(requested, selected = this.getActual())) {
            return this.getSimpleName();
        }
        if (requested instanceof ModuleComponentSelector && selected instanceof ModuleComponentIdentifier) {
            ModuleComponentSelector requestedModuleComponentSelector = (ModuleComponentSelector)requested;
            ModuleComponentIdentifier selectedModuleComponentedIdentifier = (ModuleComponentIdentifier)selected;
            if (requestedModuleComponentSelector.getModuleIdentifier().equals(selectedModuleComponentedIdentifier.getModuleIdentifier())) {
                return this.getSimpleName() + " -> " + selectedModuleComponentedIdentifier.getVersion();
            }
        }
        return this.getSimpleName() + " -> " + selected.getDisplayName();
    }

    private String getSimpleName() {
        return this.getRequested().getDisplayName();
    }

    protected abstract ComponentSelector getRequested();

    protected abstract ComponentIdentifier getActual();
}

