/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.visualstudio.TextConfigFile;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfigurationMetadata;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMetadata;
import org.gradle.ide.visualstudio.internal.VisualStudioSolutionInternal;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.util.internal.CollectionUtils;

public class DefaultVisualStudioSolution
implements VisualStudioSolutionInternal {
    private final String name;
    private final SolutionFile solutionFile;
    private final DefaultTaskDependency buildDependencies = new DefaultTaskDependency();
    private final IdeArtifactRegistry ideArtifactRegistry;
    private final Provider<RegularFile> location;

    @Inject
    public DefaultVisualStudioSolution(String name, ObjectFactory objectFactory, IdeArtifactRegistry ideArtifactRegistry, ProviderFactory providers, ProjectLayout projectLayout) {
        this.name = name;
        this.solutionFile = objectFactory.newInstance(SolutionFile.class, this.getName() + ".sln");
        this.location = projectLayout.file(providers.provider(new Callable<File>(){

            @Override
            public File call() {
                return DefaultVisualStudioSolution.this.solutionFile.getLocation();
            }
        }));
        this.ideArtifactRegistry = ideArtifactRegistry;
        this.builtBy(ideArtifactRegistry.getIdeProjectFiles(VisualStudioProjectMetadata.class));
    }

    @Override
    public String getDisplayName() {
        return "Visual Studio solution";
    }

    @Override
    public Provider<RegularFile> getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SolutionFile getSolutionFile() {
        return this.solutionFile;
    }

    @Override
    @Internal
    public List<VisualStudioProjectMetadata> getProjects() {
        return CollectionUtils.collect(this.ideArtifactRegistry.getIdeProjects(VisualStudioProjectMetadata.class), new Transformer<VisualStudioProjectMetadata, IdeArtifactRegistry.Reference<VisualStudioProjectMetadata>>(){

            @Override
            public VisualStudioProjectMetadata transform(IdeArtifactRegistry.Reference<VisualStudioProjectMetadata> reference) {
                return reference.get();
            }
        });
    }

    @Input
    public List<String> getProjectFilePaths() {
        return CollectionUtils.collect(this.getProjects(), new Transformer<String, VisualStudioProjectMetadata>(){

            @Override
            public String transform(VisualStudioProjectMetadata metadata) {
                return metadata.getFile().getAbsolutePath();
            }
        });
    }

    @Input
    public Set<String> getConfigurationNames() {
        return this.getProjects().stream().flatMap(it -> it.getConfigurations().stream().map(VisualStudioProjectConfigurationMetadata::getName)).collect(Collectors.toSet());
    }

    @Nested
    public List<Action<? super TextProvider>> getSolutionFileActions() {
        return this.solutionFile.getTextActions();
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildDependencies.add(tasks);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    public static class SolutionFile
    implements TextConfigFile {
        private final List<Action<? super TextProvider>> actions = new ArrayList<Action<? super TextProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        @Inject
        public SolutionFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        @Internal
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withContent(Action<? super TextProvider> action) {
            this.actions.add(action);
        }

        @Nested
        public List<Action<? super TextProvider>> getTextActions() {
            return this.actions;
        }
    }
}

