/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.problems.buildtree.ProblemReporter;

public class ProblemReportingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final ExceptionAnalyser exceptionAnalyser;
    private final List<? extends ProblemReporter> reporters;

    public ProblemReportingBuildActionRunner(BuildActionRunner delegate, ExceptionAnalyser exceptionAnalyser, List<? extends ProblemReporter> reporters) {
        this.delegate = delegate;
        this.exceptionAnalyser = exceptionAnalyser;
        this.reporters = ImmutableList.sortedCopyOf(Comparator.comparing(ProblemReporter::getId), reporters);
    }

    @Override
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        File defaultRootBuildDir = new File(buildController.getGradle().getServices().get(BuildLayout.class).getRootDirectory(), "build");
        RootProjectBuildDirCollectingListener listener = new RootProjectBuildDirCollectingListener(defaultRootBuildDir);
        buildController.getGradle().addBuildListener(listener);
        BuildActionRunner.Result result = this.delegate.run(action, buildController);
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        File rootProjectBuildDir = listener.buildDir;
        Consumer<Throwable> collector = failure -> failures.add(this.exceptionAnalyser.transform((Throwable)failure));
        for (ProblemReporter problemReporter : this.reporters) {
            try {
                problemReporter.report(rootProjectBuildDir, collector);
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        return result.addFailures(failures);
    }

    private static class RootProjectBuildDirCollectingListener
    extends InternalBuildAdapter {
        File buildDir;

        public RootProjectBuildDirCollectingListener(File defaultBuildDir) {
            this.buildDir = defaultBuildDir;
        }

        @Override
        public void projectsEvaluated(Gradle gradle) {
            this.buildDir = gradle.getRootProject().getBuildDir();
        }
    }
}

