/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import org.gradle.internal.dispatch.Dispatch;

public class ContextClassLoaderDispatch<T>
implements Dispatch<T> {
    private final Dispatch<? super T> dispatch;
    private final ClassLoader contextClassLoader;

    public ContextClassLoaderDispatch(Dispatch<? super T> dispatch, ClassLoader contextClassLoader) {
        this.dispatch = dispatch;
        this.contextClassLoader = contextClassLoader;
    }

    @Override
    public void dispatch(T message2) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            this.dispatch.dispatch(message2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

