/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3Object;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ResourceConnector
implements ExternalResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ResourceConnector.class);
    private final S3Client s3Client;

    public S3ResourceConnector(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    @Override
    public List<String> list(URI parent) {
        LOGGER.debug("Listing parent resources: {}", (Object)parent);
        return this.s3Client.listDirectChildren(parent);
    }

    @Override
    public ExternalResourceReadResponse openResource(URI location, boolean revalidate) {
        LOGGER.debug("Attempting to get resource: {}", (Object)location);
        S3Object s3Object = this.s3Client.getResource(location);
        if (s3Object == null) {
            return null;
        }
        return new S3Resource(s3Object, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalResourceMetaData getMetaData(URI location, boolean revalidate) {
        LOGGER.debug("Attempting to get resource metadata: {}", (Object)location);
        S3Object s3Object = this.s3Client.getMetaData(location);
        if (s3Object == null) {
            return null;
        }
        try {
            ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
            DefaultExternalResourceMetaData defaultExternalResourceMetaData = new DefaultExternalResourceMetaData(location, objectMetadata.getLastModified().getTime(), objectMetadata.getContentLength(), objectMetadata.getContentType(), objectMetadata.getETag(), null);
            return defaultExternalResourceMetaData;
        }
        finally {
            IoActions.closeQuietly((Closeable)s3Object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(ReadableContent resource, URI destination) throws IOException {
        LOGGER.debug("Attempting to upload stream to : {}", (Object)destination);
        try (InputStream inputStream = resource.open();){
            this.s3Client.put(inputStream, resource.getContentLength(), destination);
        }
    }
}

