/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public class OutputCleaningCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Compiler<T> compiler;
    private final String outputFileSuffix;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;

    public OutputCleaningCompiler(Compiler<T> compiler, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, String outputFileSuffix) {
        this.compiler = compiler;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.outputFileSuffix = outputFileSuffix;
    }

    @Override
    public WorkResult execute(T spec) {
        boolean didRemove = this.deleteOutputsForRemovedSources((NativeCompileSpec)spec);
        boolean didCompile = this.compileSources(spec);
        return WorkResults.didWork(didRemove || didCompile);
    }

    private boolean compileSources(T spec) {
        if (spec.getSourceFiles().isEmpty()) {
            return false;
        }
        return this.compiler.execute(spec).getDidWork();
    }

    private boolean deleteOutputsForRemovedSources(NativeCompileSpec spec) {
        boolean didRemove = false;
        for (File removedSource : spec.getRemovedSourceFiles()) {
            File objectFile = this.getObjectFile(spec.getObjectFileDir(), removedSource);
            new File(objectFile.getParentFile(), objectFile.getName() + ".pdb").delete();
            if (!objectFile.delete()) continue;
            didRemove = true;
            objectFile.getParentFile().delete();
        }
        return didRemove;
    }

    private File getObjectFile(File objectFileRoot, File sourceFile) {
        return this.compilerOutputFileNamingSchemeFactory.create().withObjectFileNameSuffix(this.outputFileSuffix).withOutputBaseFolder(objectFileRoot).map(sourceFile);
    }
}

