/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdeArtifactStore;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.internal.CollectionUtils;

public class DefaultIdeArtifactRegistry
implements IdeArtifactRegistry {
    private final IdeArtifactStore store;
    private final ProjectStateRegistry projectRegistry;
    private final FileOperations fileOperations;
    private final ProjectComponentIdentifier currentProject;

    public DefaultIdeArtifactRegistry(IdeArtifactStore store, ProjectStateRegistry projectRegistry, FileOperations fileOperations, DomainObjectContext domainObjectContext, BuildState currentBuild) {
        this.store = store;
        this.projectRegistry = projectRegistry;
        this.fileOperations = fileOperations;
        this.currentProject = currentBuild.getProject(domainObjectContext.getProjectPath()).getComponentIdentifier();
    }

    @Override
    public void registerIdeProject(IdeProjectMetadata ideProjectMetadata) {
        this.store.put(this.currentProject, ideProjectMetadata);
    }

    @Override
    @Nullable
    public <T extends IdeProjectMetadata> T getIdeProject(Class<T> type, ProjectComponentIdentifier project) {
        ProjectState projectState = this.projectRegistry.stateFor(project);
        if (!projectState.getOwner().isImplicitBuild()) {
            for (IdeProjectMetadata ideProjectMetadata : this.store.get(project)) {
                if (!type.isInstance(ideProjectMetadata)) continue;
                return (T)((IdeProjectMetadata)type.cast(ideProjectMetadata));
            }
        }
        return null;
    }

    @Override
    public <T extends IdeProjectMetadata> List<IdeArtifactRegistry.Reference<T>> getIdeProjects(Class<T> type) {
        ArrayList result = Lists.newArrayList();
        for (ProjectState projectState : this.projectRegistry.getAllProjects()) {
            if (projectState.getOwner().isImplicitBuild()) continue;
            ProjectComponentIdentifier projectId = projectState.getComponentIdentifier();
            for (IdeProjectMetadata ideProjectMetadata : this.store.get(projectId)) {
                if (!type.isInstance(ideProjectMetadata)) continue;
                IdeProjectMetadata metadata = (IdeProjectMetadata)type.cast(ideProjectMetadata);
                result.add(new MetadataReference<IdeProjectMetadata>(metadata, projectId));
            }
        }
        return result;
    }

    @Override
    public FileCollection getIdeProjectFiles(final Class<? extends IdeProjectMetadata> type) {
        return this.fileOperations.immutableFiles(new Callable<List<FileCollection>>(){

            @Override
            public List<FileCollection> call() {
                return CollectionUtils.collect(DefaultIdeArtifactRegistry.this.getIdeProjects(type), new Transformer<FileCollection, IdeArtifactRegistry.Reference<?>>(){

                    @Override
                    public FileCollection transform(IdeArtifactRegistry.Reference<?> result) {
                        ConfigurableFileCollection singleton = DefaultIdeArtifactRegistry.this.fileOperations.configurableFiles(result.get().getFile());
                        singleton.builtBy(result.get().getGeneratorTasks());
                        return singleton;
                    }
                });
            }
        });
    }

    private static class MetadataReference<T extends IdeProjectMetadata>
    implements IdeArtifactRegistry.Reference<T> {
        private final T metadata;
        private final ProjectComponentIdentifier projectId;

        MetadataReference(T metadata, ProjectComponentIdentifier projectId) {
            this.metadata = metadata;
            this.projectId = projectId;
        }

        @Override
        public T get() {
            return this.metadata;
        }

        @Override
        public ProjectComponentIdentifier getOwningProject() {
            return this.projectId;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            for (Task task : this.get().getGeneratorTasks()) {
                context.add(task);
            }
        }
    }
}

