/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.AccessRule;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.UnresolvedLibrary;
import org.gradle.plugins.ide.internal.configurer.EclipseModelAwareUniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.TasksFactory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultAccessRule;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultClasspathAttribute;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseBuildCommand;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseClasspathContainer;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseExternalDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseJavaSourceSettings;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseLinkedResource;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseOutputLocation;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProject;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectNature;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseTask;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.eclipse.EclipseRuntime;
import org.gradle.tooling.model.eclipse.EclipseWorkspace;
import org.gradle.tooling.model.eclipse.EclipseWorkspaceProject;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public class EclipseModelBuilder
implements ParameterizedToolingModelBuilder<EclipseRuntime> {
    private final GradleProjectBuilder gradleProjectBuilder;
    private final EclipseModelAwareUniqueProjectNameProvider uniqueProjectNameProvider;
    private boolean projectDependenciesOnly;
    private DefaultEclipseProject result;
    private List<DefaultEclipseProject> eclipseProjects;
    private TasksFactory tasksFactory;
    private DefaultGradleProject rootGradleProject;
    private Project currentProject;
    private EclipseRuntime eclipseRuntime;
    private Map<String, Boolean> projectOpenStatus = new HashMap<String, Boolean>();

    @VisibleForTesting
    public EclipseModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services, EclipseModelAwareUniqueProjectNameProvider uniqueProjectNameProvider) {
        this.gradleProjectBuilder = gradleProjectBuilder;
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
    }

    public EclipseModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services) {
        this(gradleProjectBuilder, services, new EclipseModelAwareUniqueProjectNameProvider(services.get(ProjectStateRegistry.class)));
    }

    @Override
    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject") || modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
    }

    @Override
    public Class<EclipseRuntime> getParameterType() {
        return EclipseRuntime.class;
    }

    @Override
    public Object buildAll(String modelName, EclipseRuntime eclipseRuntime, Project project) {
        this.eclipseRuntime = eclipseRuntime;
        List<EclipseWorkspaceProject> projects = eclipseRuntime.getWorkspace().getProjects();
        HashSet<EclipseWorkspaceProject> projectsInBuild = new HashSet<EclipseWorkspaceProject>(projects);
        projectsInBuild.removeAll(this.gatherExternalProjects(project.getRootProject(), projects));
        this.projectOpenStatus = projectsInBuild.stream().collect(Collectors.toMap(EclipseWorkspaceProject::getName, EclipseModelBuilder::isProjectOpen, (a, b) -> a | b));
        return this.buildAll(modelName, project);
    }

    public static boolean isProjectOpen(EclipseWorkspaceProject project) {
        try {
            return project.isOpen();
        }
        catch (UnsupportedMethodException e) {
            return true;
        }
    }

    @Override
    public DefaultEclipseProject buildAll(String modelName, Project project) {
        boolean includeTasks = modelName.equals("org.gradle.tooling.model.eclipse.EclipseProject");
        this.tasksFactory = new TasksFactory(includeTasks);
        this.projectDependenciesOnly = modelName.equals("org.gradle.tooling.model.eclipse.HierarchicalEclipseProject");
        this.currentProject = project;
        this.eclipseProjects = Lists.newArrayList();
        Project root = project.getRootProject();
        this.rootGradleProject = this.gradleProjectBuilder.buildAll(project);
        this.tasksFactory.collectTasks(root);
        this.applyEclipsePlugin(root, new ArrayList<GradleInternal>());
        this.deduplicateProjectNames(root);
        this.buildHierarchy(root);
        this.populate(root);
        return this.result;
    }

    private void deduplicateProjectNames(Project root) {
        this.uniqueProjectNameProvider.setReservedProjectNames(this.calculateReservedProjectNames(root, this.eclipseRuntime));
        for (Project project : root.getAllprojects()) {
            EclipseModel eclipseModel = project.getExtensions().findByType(EclipseModel.class);
            if (eclipseModel == null) continue;
            eclipseModel.getProject().setName(this.uniqueProjectNameProvider.getUniqueName(project));
        }
    }

    private void applyEclipsePlugin(Project root, List<GradleInternal> alreadyProcessed) {
        Set<Project> allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(EclipsePlugin.class);
        }
        for (IncludedBuild includedBuild : root.getGradle().getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || alreadyProcessed.contains(build = ((IncludedBuildState)((Object)includedBuild)).getConfiguredBuild())) continue;
            alreadyProcessed.add(build);
            this.applyEclipsePlugin(build.getRootProject(), alreadyProcessed);
        }
    }

    private DefaultEclipseProject buildHierarchy(Project project) {
        ArrayList<DefaultEclipseProject> children = new ArrayList<DefaultEclipseProject>();
        for (Project child : project.getChildProjects().values()) {
            children.add(this.buildHierarchy(child));
        }
        EclipseModel eclipseModel = project.getExtensions().getByType(EclipseModel.class);
        EclipseProject internalProject = eclipseModel.getProject();
        String name = internalProject.getName();
        String description = GUtil.elvis(internalProject.getComment(), null);
        DefaultEclipseProject eclipseProject = new DefaultEclipseProject(name, project.getPath(), description, project.getProjectDir(), children).setGradleProject(this.rootGradleProject.findByPath(project.getPath()));
        for (DefaultEclipseProject child : children) {
            child.setParent(eclipseProject);
        }
        this.addProject(project, eclipseProject);
        return eclipseProject;
    }

    private void addProject(Project project, DefaultEclipseProject eclipseProject) {
        if (project == this.currentProject) {
            this.result = eclipseProject;
        }
        this.eclipseProjects.add(eclipseProject);
    }

    private void populate(Project project) {
        EclipseModel eclipseModel = project.getExtensions().getByType(EclipseModel.class);
        boolean projectDependenciesOnly = this.projectDependenciesOnly;
        ClasspathElements classpathElements = EclipseModelBuilder.gatherClasspathElements(this.projectOpenStatus, eclipseModel.getClasspath(), projectDependenciesOnly);
        DefaultEclipseProject eclipseProject = this.findEclipseProject(project);
        eclipseProject.setClasspath(classpathElements.getExternalDependencies());
        eclipseProject.setProjectDependencies(classpathElements.getProjectDependencies());
        eclipseProject.setSourceDirectories(classpathElements.getSourceDirectories());
        eclipseProject.setClasspathContainers(classpathElements.getClasspathContainers());
        eclipseProject.setOutputLocation(classpathElements.getEclipseOutputLocation() != null ? classpathElements.getEclipseOutputLocation() : new DefaultEclipseOutputLocation("bin"));
        eclipseProject.setAutoBuildTasks(!eclipseModel.getAutoBuildTasks().getDependencies(null).isEmpty());
        org.gradle.plugins.ide.eclipse.model.Project xmlProject = new org.gradle.plugins.ide.eclipse.model.Project(new XmlTransformer());
        XmlFileContentMerger projectFile = eclipseModel.getProject().getFile();
        if (projectFile == null) {
            xmlProject.configure(eclipseModel.getProject());
        } else {
            eclipseModel.getProject().mergeXmlProject(xmlProject);
        }
        EclipseModelBuilder.populateEclipseProjectTasks(eclipseProject, this.tasksFactory.getTasks(project));
        EclipseModelBuilder.populateEclipseProject(eclipseProject, xmlProject);
        EclipseModelBuilder.populateEclipseProjectJdt(eclipseProject, eclipseModel.getJdt());
        for (Project childProject : project.getChildProjects().values()) {
            this.populate(childProject);
        }
    }

    public static ClasspathElements gatherClasspathElements(Map<String, Boolean> projectOpenStatus, EclipseClasspath eclipseClasspath, boolean projectDependenciesOnly) {
        List<ClasspathEntry> classpathEntries;
        ClasspathElements classpathElements = new ClasspathElements();
        eclipseClasspath.setProjectDependenciesOnly(projectDependenciesOnly);
        if (eclipseClasspath.getFile() == null) {
            classpathEntries = eclipseClasspath.resolveDependencies();
        } else {
            Classpath classpath = new Classpath(eclipseClasspath.getFileReferenceFactory());
            eclipseClasspath.mergeXmlClasspath(classpath);
            classpathEntries = classpath.getEntries();
        }
        HashMap<String, DefaultEclipseProjectDependency> projectDependencyMap = new HashMap<String, DefaultEclipseProjectDependency>();
        for (ClasspathEntry entry : classpathEntries) {
            String path;
            if (entry instanceof Library) {
                DefaultEclipseExternalDependency dependency;
                File javadoc;
                AbstractLibrary library = (AbstractLibrary)entry;
                File file = library.getLibrary().getFile();
                File source = library.getSourcePath() == null ? null : library.getSourcePath().getFile();
                File file2 = javadoc = library.getJavadocPath() == null ? null : library.getJavadocPath().getFile();
                if (entry instanceof UnresolvedLibrary) {
                    UnresolvedLibrary unresolvedLibrary = (UnresolvedLibrary)entry;
                    dependency = DefaultEclipseExternalDependency.createUnresolved(file, javadoc, source, library.getModuleVersion(), library.isExported(), EclipseModelBuilder.createAttributes(library), EclipseModelBuilder.createAccessRules(library), unresolvedLibrary.getAttemptedSelector().getDisplayName());
                } else {
                    dependency = DefaultEclipseExternalDependency.createResolved(file, javadoc, source, library.getModuleVersion(), library.isExported(), EclipseModelBuilder.createAttributes(library), EclipseModelBuilder.createAccessRules(library));
                }
                classpathElements.getExternalDependencies().add(dependency);
                continue;
            }
            if (entry instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)entry;
                path = StringUtils.removeStart((String)projectDependency.getPath(), (String)"/");
                boolean isProjectOpen = projectOpenStatus.getOrDefault(path, true);
                if (!isProjectOpen) {
                    File source = projectDependency.getPublicationSourcePath() == null ? null : projectDependency.getPublicationSourcePath().getFile();
                    File javadoc = projectDependency.getPublicationJavadocPath() == null ? null : projectDependency.getPublicationJavadocPath().getFile();
                    classpathElements.getExternalDependencies().add(DefaultEclipseExternalDependency.createResolved(projectDependency.getPublication().getFile(), javadoc, source, null, projectDependency.isExported(), EclipseModelBuilder.createAttributes(projectDependency), EclipseModelBuilder.createAccessRules(projectDependency)));
                    classpathElements.getBuildDependencies().add(projectDependency.getBuildDependencies());
                    continue;
                }
                projectDependencyMap.put(path, new DefaultEclipseProjectDependency(path, projectDependency.isExported(), EclipseModelBuilder.createAttributes(projectDependency), EclipseModelBuilder.createAccessRules(projectDependency)));
                continue;
            }
            if (entry instanceof SourceFolder) {
                SourceFolder sourceFolder = (SourceFolder)entry;
                path = sourceFolder.getPath();
                List<String> excludes = sourceFolder.getExcludes();
                List<String> includes = sourceFolder.getIncludes();
                String output = sourceFolder.getOutput();
                classpathElements.getSourceDirectories().add(new DefaultEclipseSourceDirectory(path, sourceFolder.getDir(), excludes, includes, output, EclipseModelBuilder.createAttributes(sourceFolder), EclipseModelBuilder.createAccessRules(sourceFolder)));
                continue;
            }
            if (entry instanceof Container) {
                Container container = (Container)entry;
                classpathElements.getClasspathContainers().add(new DefaultEclipseClasspathContainer(container.getPath(), container.isExported(), EclipseModelBuilder.createAttributes(container), EclipseModelBuilder.createAccessRules(container)));
                continue;
            }
            if (!(entry instanceof Output)) continue;
            classpathElements.setEclipseOutputLocation(new DefaultEclipseOutputLocation(((Output)entry).getPath()));
        }
        classpathElements.getProjectDependencies().addAll(projectDependencyMap.values());
        return classpathElements;
    }

    private static void populateEclipseProjectTasks(DefaultEclipseProject eclipseProject, Iterable<Task> projectTasks) {
        ArrayList<DefaultEclipseTask> tasks = new ArrayList<DefaultEclipseTask>();
        for (Task t : projectTasks) {
            tasks.add(new DefaultEclipseTask(eclipseProject, t.getPath(), t.getName(), t.getDescription()));
        }
        eclipseProject.setTasks(tasks);
    }

    private static void populateEclipseProject(DefaultEclipseProject eclipseProject, org.gradle.plugins.ide.eclipse.model.Project xmlProject) {
        LinkedList<DefaultEclipseLinkedResource> linkedResources = new LinkedList<DefaultEclipseLinkedResource>();
        for (Link link : xmlProject.getLinkedResources()) {
            linkedResources.add(new DefaultEclipseLinkedResource(link.getName(), link.getType(), link.getLocation(), link.getLocationUri()));
        }
        eclipseProject.setLinkedResources(linkedResources);
        ArrayList<DefaultEclipseProjectNature> natures = new ArrayList<DefaultEclipseProjectNature>();
        for (String n : xmlProject.getNatures()) {
            natures.add(new DefaultEclipseProjectNature(n));
        }
        eclipseProject.setProjectNatures(natures);
        ArrayList<DefaultEclipseBuildCommand> arrayList = new ArrayList<DefaultEclipseBuildCommand>();
        for (BuildCommand b : xmlProject.getBuildCommands()) {
            LinkedHashMap arguments = Maps.newLinkedHashMap();
            for (Map.Entry<String, String> entry : b.getArguments().entrySet()) {
                arguments.put(EclipseModelBuilder.convertGString(entry.getKey()), EclipseModelBuilder.convertGString(entry.getValue()));
            }
            arrayList.add(new DefaultEclipseBuildCommand(b.getName(), arguments));
        }
        eclipseProject.setBuildCommands(arrayList);
    }

    private static void populateEclipseProjectJdt(DefaultEclipseProject eclipseProject, EclipseJdt jdt) {
        if (jdt != null) {
            eclipseProject.setJavaSourceSettings(new DefaultEclipseJavaSourceSettings().setSourceLanguageLevel(jdt.getSourceCompatibility()).setTargetBytecodeVersion(jdt.getTargetCompatibility()).setJdk(DefaultInstalledJdk.current()));
        }
    }

    private DefaultEclipseProject findEclipseProject(final Project project) {
        return CollectionUtils.findFirst(this.eclipseProjects, new Spec<DefaultEclipseProject>(){

            @Override
            public boolean isSatisfiedBy(DefaultEclipseProject element) {
                return element.getGradleProject().getPath().equals(project.getPath());
            }
        });
    }

    private static List<DefaultClasspathAttribute> createAttributes(AbstractClasspathEntry classpathEntry) {
        ArrayList result = Lists.newArrayList();
        Map<String, Object> attributes = classpathEntry.getEntryAttributes();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object value = entry.getValue();
            result.add(new DefaultClasspathAttribute(EclipseModelBuilder.convertGString(entry.getKey()), value == null ? "" : value.toString()));
        }
        return result;
    }

    private static List<DefaultAccessRule> createAccessRules(AbstractClasspathEntry classpathEntry) {
        ArrayList result = Lists.newArrayList();
        for (AccessRule accessRule : classpathEntry.getAccessRules()) {
            result.add(EclipseModelBuilder.createAccessRule(accessRule));
        }
        return result;
    }

    private static DefaultAccessRule createAccessRule(AccessRule accessRule) {
        int kindCode;
        String kind;
        switch (kind = accessRule.getKind()) {
            case "accessible": 
            case "0": {
                kindCode = 0;
                break;
            }
            case "nonaccessible": 
            case "1": {
                kindCode = 1;
                break;
            }
            case "discouraged": 
            case "2": {
                kindCode = 2;
                break;
            }
            default: {
                kindCode = 0;
            }
        }
        return new DefaultAccessRule(kindCode, accessRule.getPattern());
    }

    private List<Project> collectAllProjects(List<Project> all, Gradle gradle, Set<Gradle> allBuilds) {
        all.addAll(gradle.getRootProject().getAllprojects());
        for (IncludedBuild includedBuild : gradle.getIncludedBuilds()) {
            GradleInternal build;
            if (!(includedBuild instanceof IncludedBuildState) || allBuilds.contains(build = ((IncludedBuildState)((Object)includedBuild)).getConfiguredBuild())) continue;
            allBuilds.add(build);
            this.collectAllProjects(all, build, allBuilds);
        }
        return all;
    }

    private Gradle getRootBuild(Gradle gradle) {
        if (gradle.getParent() == null) {
            return gradle;
        }
        return gradle.getParent();
    }

    private List<String> calculateReservedProjectNames(Project rootProject, EclipseRuntime parameter) {
        if (parameter == null) {
            return Collections.emptyList();
        }
        EclipseWorkspace workspace = parameter.getWorkspace();
        if (workspace == null) {
            return Collections.emptyList();
        }
        List<EclipseWorkspaceProject> projects = workspace.getProjects();
        if (projects == null) {
            return Collections.emptyList();
        }
        ArrayList<String> reservedProjectNames = new ArrayList<String>();
        List<EclipseWorkspaceProject> externalProjects = this.gatherExternalProjects(rootProject, projects);
        for (EclipseWorkspaceProject externalProject : externalProjects) {
            reservedProjectNames.add(externalProject.getName());
        }
        return reservedProjectNames;
    }

    private List<EclipseWorkspaceProject> gatherExternalProjects(Project rootProject, List<EclipseWorkspaceProject> projects) {
        Set gradleProjectLocations = this.collectAllProjects(new ArrayList<Project>(), this.getRootBuild(rootProject.getGradle()), new HashSet<Gradle>()).stream().map(p -> p.getProjectDir().getAbsoluteFile()).collect(Collectors.toSet());
        ArrayList<EclipseWorkspaceProject> externalProjects = new ArrayList<EclipseWorkspaceProject>();
        for (EclipseWorkspaceProject project : projects) {
            if (project == null || project.getLocation() == null || project.getName() == null || project.getLocation() == null || gradleProjectLocations.contains(project.getLocation().getAbsoluteFile())) continue;
            externalProjects.add(project);
        }
        return externalProjects;
    }

    private static String convertGString(CharSequence original) {
        return original.toString();
    }

    public static class ClasspathElements {
        private final List<DefaultEclipseExternalDependency> externalDependencies = new ArrayList<DefaultEclipseExternalDependency>();
        private final List<DefaultEclipseProjectDependency> projectDependencies = new ArrayList<DefaultEclipseProjectDependency>();
        private final List<DefaultEclipseSourceDirectory> sourceDirectories = new ArrayList<DefaultEclipseSourceDirectory>();
        private final List<DefaultEclipseClasspathContainer> classpathContainers = new ArrayList<DefaultEclipseClasspathContainer>();
        private final List<TaskDependency> buildDependencies = new ArrayList<TaskDependency>();
        private DefaultEclipseOutputLocation eclipseOutputLocation;

        public List<DefaultEclipseExternalDependency> getExternalDependencies() {
            return this.externalDependencies;
        }

        public List<DefaultEclipseProjectDependency> getProjectDependencies() {
            return this.projectDependencies;
        }

        public List<DefaultEclipseSourceDirectory> getSourceDirectories() {
            return this.sourceDirectories;
        }

        public List<DefaultEclipseClasspathContainer> getClasspathContainers() {
            return this.classpathContainers;
        }

        public List<TaskDependency> getBuildDependencies() {
            return this.buildDependencies;
        }

        public DefaultEclipseOutputLocation getEclipseOutputLocation() {
            return this.eclipseOutputLocation;
        }

        public void setEclipseOutputLocation(DefaultEclipseOutputLocation eclipseOutputLocation) {
            this.eclipseOutputLocation = eclipseOutputLocation;
        }
    }
}

