/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.OffsetSavingBuilder;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.BaseDmlHelperKt;
import com.intellij.database.dialects.base.generator.dml.BaseInsertRowsGeneratorKt;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002 \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002\u0012\u0004\u0012\u00020\u00060\u0001B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002H\u0016J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseInsertRowsGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/dataSource/connection/Either;", "", "", "Lcom/intellij/database/datagrid/mutating/RowUpdateData;", "Lcom/intellij/database/script/generator/dml/InsertRowsTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/script/generator/dml/InsertRowsTask;Lcom/intellij/database/Dbms;)V", "generate", "hasPlaceholder", "", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor$DelegateDescriptor;", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "sqlInsertInto", "Lcom/intellij/database/util/DdlBuilder;", "builder", "table", "Lcom/intellij/database/model/DasTable;", "columns", "", "values", "Lcom/intellij/util/Consumer;", "intellij.database.dialects.base.core"})
public class BaseInsertRowsGenerator
extends DmlGenerator<Either<String, List<RowUpdateData>>, InsertRowsTask> {
    private final Dbms dbms;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Either<String, List<RowUpdateData>> generate() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"DbImplUtilCore.getDatabaseDialect(dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtilCore.createBuilderForUIExec((DatabaseDialectEx)dialect));
        boolean bl = false;
        List data = new ArrayList();
        for (RowMutation mutation : ((InsertRowsTask)this.getTask()).getMutations()) {
            String sql;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            List list = mutation.getData();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mutation.data");
            String string = DmlUtilKt.checkUnparsed((List)list);
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                return Either.Companion.left((Object)it);
            }
            List delegateDescriptors = BaseInsertRowsGeneratorKt.access$createDescriptors(mutation);
            List<Consumer<DdlBuilder>> placeholders = BaseDmlHelperKt.getPlaceholdersForInsert(delegateDescriptors, this.dbms, ((InsertRowsTask)this.getTask()).getTable());
            List<String> colNames = BaseDmlHelperKt.getColumnNamesForInsert(delegateDescriptors, this.dbms);
            this.sqlInsertInto((DdlBuilder)builder, ((InsertRowsTask)this.getTask()).getTable(), colNames, placeholders);
            Intrinsics.checkNotNullExpressionValue((Object)builder.getStatement(), (String)"builder.statement");
            Iterable $this$filter$iv = delegateDescriptors;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AutoValueDescriptor.DelegateDescriptor it = (AutoValueDescriptor.DelegateDescriptor)element$iv$iv;
                boolean bl5 = false;
                if (!this.hasPlaceholder((AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>)it, this.dbms)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List withPlaceholders = (List)destination$iv$iv;
            Iterable $this$map$iv = withPlaceholders;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AutoValueDescriptor.DelegateDescriptor bl5 = (AutoValueDescriptor.DelegateDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                ColumnQueryData columnQueryData = (ColumnQueryData)it.getDelegate();
                collection.add(columnQueryData);
            }
            List delegates = (List)destination$iv$iv2;
            RowQueryData qData = new RowQueryData(delegates, builder.getOffsets(), sql, delegates.size());
            data.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        return Either.Companion.right((Object)data);
    }

    private final boolean hasPlaceholder(AutoValueDescriptor.DelegateDescriptor<ColumnQueryData> d, Dbms dbms) {
        return !d.isComputed() && !d.isAutogenerated() && !d.hasDefault() && !JdbcEngineUtils.shouldValueBeInlined((Object)((ColumnQueryData)d.getDelegate()).getObject(), (String)d.getTypeName(), (Dbms)dbms);
    }

    private final DdlBuilder sqlInsertInto(DdlBuilder builder, DasTable table, List<String> columns, List<? extends Consumer<DdlBuilder>> values) {
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        Collection collection = columns;
        boolean bl = false;
        if (!collection.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)builder, (Iterable)columns);
            builder.symbol(")");
        }
        if (values.isEmpty() && DmlUtilKt.dmlGenerator((Dbms)this.dbms).getSupportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendCommaSeparated((DdlBuilder)builder, (Iterable)values);
            builder.symbol(")");
        }
        return builder;
    }

    public BaseInsertRowsGenerator(@NotNull InsertRowsTask task, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super((DmlTask)task);
        this.dbms = dbms;
    }
}

