/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.query;

import com.intellij.database.dialects.base.introspector.query.Evaluator;
import com.intellij.database.dialects.base.introspector.query.PreprocessedQuery;
import com.intellij.database.dialects.base.introspector.query.Preprocessor;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonPreprocessor
implements Preprocessor {
    private static final Pattern SCAN_PATTERN = Pattern.compile("#([A-Z][A-Z0-9]+)([:>]\\s*)?|#\\[\\s*(\\S.*?)\\s*]([:>]\\s*)?|#:\\s*|#\\.|:(\\w+)|:\\[\\s*(\\S.*?)\\s*]|\\?|[\"'\\[]|/\\*.*?\\*/|--.*?(\\n|$)", 32);
    private static final Pattern BLOCK_END_PATTERN = Pattern.compile("#([A-Z][A-Z0-9]+):|#\\[\\s*(\\S.*?)\\s*]:|#:|#\\.", 32);
    private static final Pattern COMPLEX_PARAMETER_PATTERN = Pattern.compile("(\\*{0,2})\\s*(\\w+)");
    @NotNull
    private final Evaluator myEvaluator;
    @NotNull
    private List<?> myFreeParameters;
    private final boolean myAllowShortForm;
    private final ArrayList<Object> myBindableParameters;
    private boolean mySkipChainedSections;
    private static final List<?> EMPTY_FREE_PARAMETERS = Collections.emptyList();

    public CommonPreprocessor(@NotNull Evaluator evaluator) {
        if (evaluator == null) {
            CommonPreprocessor.$$$reportNull$$$0(0);
        }
        this(false, evaluator);
    }

    public CommonPreprocessor(boolean allowShortForm, @NotNull Evaluator evaluator) {
        if (evaluator == null) {
            CommonPreprocessor.$$$reportNull$$$0(1);
        }
        this.myFreeParameters = EMPTY_FREE_PARAMETERS;
        this.myBindableParameters = new ArrayList();
        this.mySkipChainedSections = false;
        this.myEvaluator = evaluator;
        this.myAllowShortForm = allowShortForm;
    }

    public void setFreeParameters(@NotNull List<?> freeParameters) {
        if (freeParameters == null) {
            CommonPreprocessor.$$$reportNull$$$0(2);
        }
        this.myFreeParameters = freeParameters;
    }

    public void setFreeParameters(Object ... freeParameters) {
        this.myFreeParameters = Arrays.asList(freeParameters);
    }

    @Override
    @NotNull
    public <X> PreprocessedQuery<X> preprocess(@NotNull SqlQuery<X> query) {
        if (query == null) {
            CommonPreprocessor.$$$reportNull$$$0(3);
        }
        return new PreprocessedQuery(query.rewrite((StringOperator)this), this.getBindableParameters());
    }

    @Override
    @NotNull
    public String apply(@NotNull String text) {
        if (text == null) {
            CommonPreprocessor.$$$reportNull$$$0(4);
        }
        this.reset();
        String string = this.process(text);
        if (string == null) {
            CommonPreprocessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void reset() {
        this.myBindableParameters.clear();
        this.mySkipChainedSections = false;
    }

    @NotNull
    public String process(@NotNull String originalText) {
        if (originalText == null) {
            CommonPreprocessor.$$$reportNull$$$0(6);
        }
        StringBuilder buf = new StringBuilder(originalText);
        boolean changed = false;
        Stack<Character> literalQuotations = new Stack<Character>();
        int freeParametersCount = 0;
        Matcher m = SCAN_PATTERN.matcher(buf);
        boolean found = m.find();
        while (found) {
            int begin = m.start();
            int end = m.end();
            int[] next = new int[]{end};
            String something = m.group();
            assert (something != null && something.length() > 0);
            char c1 = something.charAt(0);
            char c_prior = begin > 0 ? buf.charAt(begin - 1) : (char)'\u0000';
            char c_next = begin + 1 < buf.length() ? buf.charAt(begin + 1) : (char)'\u0000';
            switch (c1) {
                case '#': {
                    boolean shortForm;
                    boolean bl = shortForm = m.start(1) > 0;
                    if (c_prior == '#' || !this.myAllowShortForm && shortForm) break;
                    if (c_next == '.') {
                        this.processMacroConditionClosing(buf, begin, end, next);
                    } else if (c_next == ':') {
                        this.processMacroConditionElse(buf, begin, end, next);
                    } else if (c_next == '[') {
                        this.processMacroInner(buf, begin, end, m.group(3), m.group(4), next);
                    } else {
                        this.processMacroInner(buf, begin, end, m.group(1), m.group(2), next);
                    }
                    changed = true;
                    break;
                }
                case ':': {
                    String complexDefinition;
                    String phrase5;
                    if (c_prior == ':') break;
                    String simpleName = m.group(5);
                    if (!(simpleName == null || simpleName.isEmpty() || (phrase5 = buf.substring(begin, Math.min(begin + 5, buf.length()))).equalsIgnoreCase(":new.") || phrase5.equalsIgnoreCase(":old."))) {
                        this.processSimpleParameter(buf, simpleName, begin, end, next);
                        changed = true;
                    }
                    if ((complexDefinition = m.group(6)) == null || complexDefinition.isEmpty()) break;
                    this.processComplexParameter(buf, complexDefinition, begin, end, next);
                    changed = true;
                    break;
                }
                case '?': {
                    Object freeParameterValue = this.myFreeParameters.get(freeParametersCount++);
                    this.addParameterValue(freeParameterValue);
                    break;
                }
                case '\'': {
                    if (c_prior == 'q') {
                        char pairedChar = CommonPreprocessor.literalQuotePair(c_next);
                        if (pairedChar == '\u0000') break;
                        literalQuotations.push(Character.valueOf(pairedChar));
                        break;
                    }
                    if (literalQuotations.size() > 0 && ((Character)literalQuotations.peek()).charValue() == c_prior) {
                        literalQuotations.pop();
                        break;
                    }
                    CommonPreprocessor.skipQuotation(buf, c1, begin, next);
                    break;
                }
                case '\"': 
                case '[': {
                    CommonPreprocessor.skipQuotation(buf, c1, begin, next);
                    break;
                }
            }
            m = SCAN_PATTERN.matcher(buf);
            found = m.find(next[0]);
        }
        boolean changedDuringPostprocessing = this.postPreprocess(buf);
        String string = (changed |= changedDuringPostprocessing) ? buf.toString() : originalText;
        if (string == null) {
            CommonPreprocessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void processMacroInner(StringBuilder buf, int begin, int end, @NotNull String macroExpression, @Nullable String suffix2, int[] next) {
        if (macroExpression == null) {
            CommonPreprocessor.$$$reportNull$$$0(8);
        }
        int kind = StringUtil.isEmpty((String)suffix2) ? 0 : (suffix2.startsWith(">") ? 1 : 2);
        macroExpression = macroExpression.trim();
        switch (kind) {
            case 0: {
                this.processMacroSubstitution(buf, macroExpression, begin, end, next);
                break;
            }
            case 1: {
                this.processMacroConditionLine(buf, macroExpression, begin, end, next);
                break;
            }
            case 2: {
                this.processMacroConditionBlock(buf, macroExpression, begin, end, next);
            }
        }
    }

    private void processMacroSubstitution(@NotNull StringBuilder buf, @NotNull String expression, int begin, int end, int[] next) {
        Object result2;
        if (buf == null) {
            CommonPreprocessor.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            CommonPreprocessor.$$$reportNull$$$0(10);
        }
        String subst = (result2 = this.myEvaluator.evaluate(expression)) != null ? result2.toString() : "null";
        buf.replace(begin, end, subst);
        next[0] = begin;
    }

    private void processMacroConditionLine(@NotNull StringBuilder buf, @NotNull String expression, int macroBegin, int innerBegin, int[] next) {
        boolean presents;
        if (buf == null) {
            CommonPreprocessor.$$$reportNull$$$0(11);
        }
        if (expression == null) {
            CommonPreprocessor.$$$reportNull$$$0(12);
        }
        if (presents = this.isSectionSelected(expression)) {
            buf.delete(macroBegin, innerBegin);
            next[0] = macroBegin;
        } else {
            buf.replace(macroBegin, innerBegin, "--  ");
            int lineEnd = buf.indexOf("\n", macroBegin + 4);
            if (lineEnd < 0) {
                lineEnd = buf.length();
            }
            next[0] = lineEnd;
        }
    }

    private void processMacroConditionBlock(@NotNull StringBuilder buf, @NotNull String expression, int macroBegin, int innerBegin, int[] next) {
        boolean continues;
        if (buf == null) {
            CommonPreprocessor.$$$reportNull$$$0(13);
        }
        if (expression == null) {
            CommonPreprocessor.$$$reportNull$$$0(14);
        }
        boolean selected = !this.mySkipChainedSections && this.isSectionSelected(expression);
        Matcher m2 = BLOCK_END_PATTERN.matcher(buf);
        boolean endFound = m2.find(innerBegin);
        if (!endFound) {
            buf.append("\n-- The macro-conditional block ").append(buf.substring(macroBegin, innerBegin)).append(" is not closed!\n");
            next[0] = buf.length();
            return;
        }
        int endMarkerPos = m2.start(0);
        boolean bl = continues = buf.charAt(endMarkerPos + 1) != '.';
        if (selected) {
            buf.delete(macroBegin, innerBegin);
            next[0] = macroBegin;
            this.mySkipChainedSections = continues;
        } else if (continues) {
            buf.insert(endMarkerPos, "*/");
            buf.replace(macroBegin, innerBegin, "/* ");
            next[0] = endMarkerPos + 3 - (innerBegin - macroBegin) + 2;
        } else {
            buf.replace(endMarkerPos, endMarkerPos + 2, "*/");
            buf.replace(macroBegin, innerBegin, "/* ");
            next[0] = endMarkerPos + 3 - (innerBegin - macroBegin);
            this.mySkipChainedSections = false;
        }
    }

    private void processMacroConditionElse(StringBuilder buf, int begin, int end, int[] next) {
        int endMarkerPos = buf.indexOf("#.", end);
        if (endMarkerPos < 0) {
            buf.append("\n-- The macro-conditional block #> is not closed!\n");
            next[0] = buf.length();
        }
        if (this.mySkipChainedSections) {
            buf.replace(endMarkerPos, endMarkerPos + 2, "*/");
            buf.replace(begin, end, "/* ");
            next[0] = endMarkerPos + 2 - (end - begin - 3);
            this.mySkipChainedSections = false;
        } else {
            buf.delete(endMarkerPos, endMarkerPos + 2);
            buf.delete(begin, end);
            next[0] = begin;
        }
    }

    private void processMacroConditionClosing(StringBuilder buf, int begin, int end, int[] next) {
        buf.delete(begin, end);
        next[0] = begin;
        this.mySkipChainedSections = false;
    }

    private boolean isSectionSelected(String name2) {
        boolean presents;
        Object result2 = this.myEvaluator.evaluate(name2);
        boolean bl = presents = result2 != null;
        if (presents && result2 instanceof Boolean) {
            presents = (Boolean)result2;
        }
        return presents;
    }

    private void processSimpleParameter(StringBuilder buf, String name2, int begin, int end, int[] next) {
        Object value = this.myEvaluator.evaluate(name2);
        if (value != null) {
            buf.setCharAt(begin, '?');
            buf.delete(begin + 1, end);
            this.addParameterValue(value);
            next[0] = begin + 1;
        } else {
            buf.replace(begin, end, "null");
            next[0] = begin + 4;
        }
    }

    private void processComplexParameter(StringBuilder buf, String definition2, int begin, int end, int[] next) {
        Matcher m = COMPLEX_PARAMETER_PATTERN.matcher(definition2);
        boolean ok = m.matches();
        if (!ok) {
            buf.append("\n-- the complex parameter definition is invalid: ").append(definition2);
            return;
        }
        String name2 = m.group(2);
        int arity = m.end(1) - m.start(1);
        switch (arity) {
            case 0: {
                this.processSimpleParameter(buf, name2, begin, end, next);
                break;
            }
            case 1: {
                this.processParameterList(buf, name2, begin, end, next);
                break;
            }
            case 2: {
                throw new IllegalStateException("Unknown how to handle multi-dimension array: " + definition2);
            }
        }
    }

    private void processParameterList(StringBuilder buf, String name2, int begin, int end, int[] next) {
        Object[] array;
        Object value = this.myEvaluator.evaluate(name2);
        int n = 0;
        if (value instanceof Object[]) {
            array = (Object[])value;
            n = array.length;
            this.addParameterValues(Arrays.asList(array));
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            n = collection.size();
            this.addParameterValues(collection);
        } else if (value instanceof int[]) {
            array = (int[])value;
            n = array.length;
            for (Object v3 : array) {
                this.addParameterValue((int)v3);
            }
        } else if (value instanceof long[]) {
            array = (long[])value;
            n = array.length;
            for (Object v4 : array) {
                this.addParameterValue((long)v4);
            }
        } else if (value instanceof short[]) {
            array = (short[])value;
            n = array.length;
            for (Object v5 : array) {
                this.addParameterValue((short)v5);
            }
        } else if (value instanceof Iterable) {
            Iterable sequence = (Iterable)value;
            for (Object v6 : sequence) {
                this.addParameterValue(v6);
                ++n;
            }
        } else if (value instanceof Stream) {
            int[] counter = new int[]{0};
            Stream stream = (Stream)value;
            stream.forEach(v2 -> {
                this.addParameterValue(v2);
                counter[0] = counter[0] + 1;
            });
            n = counter[0];
        } else if (value != null) {
            buf.append("\n-- the complex parameter ").append(name2).append(" is expected to be an Iterable.");
            return;
        }
        String subst = n > 0 ? "?" + StringUtil.repeat((String)",?", (int)(n - 1)) : "null";
        buf.replace(begin, end, subst);
        next[0] = begin + subst.length();
    }

    private static void skipQuotation(StringBuilder buf, char beginQuote, int begin, int[] next) {
        String endQuote = beginQuote == '[' ? "]" : Character.toString(beginQuote);
        int lastPosition = buf.indexOf(endQuote, begin + 1);
        next[0] = lastPosition >= begin ? lastPosition + 1 : buf.length();
    }

    private void addParameterValue(Object value) {
        this.myBindableParameters.add(value);
    }

    private void addParameterValues(@NotNull Collection<?> values) {
        if (values == null) {
            CommonPreprocessor.$$$reportNull$$$0(15);
        }
        this.myBindableParameters.addAll(values);
    }

    @Override
    public Object @NotNull [] getBindableParameters() {
        Object[] objectArray = this.myBindableParameters.toArray();
        if (objectArray == null) {
            CommonPreprocessor.$$$reportNull$$$0(16);
        }
        return objectArray;
    }

    protected boolean postPreprocess(@NotNull StringBuilder buf) {
        if (buf == null) {
            CommonPreprocessor.$$$reportNull$$$0(17);
        }
        return false;
    }

    private static char literalQuotePair(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '(': {
                return ')';
            }
            case '<': {
                return '>';
            }
            case '!': {
                return '!';
            }
        }
        return '\u0000';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/introspector/query/CommonPreprocessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroExpression";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/introspector/query/CommonPreprocessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindableParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFreeParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMacroInner";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processMacroSubstitution";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processMacroConditionLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMacroConditionBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addParameterValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "postPreprocess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

