/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/exasol/generator/ExaNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "()V", "closingQuotes", "", "getClosingQuotes", "()Ljava/lang/String;", "openingQuotes", "getOpeningQuotes", "matchesCasing", "", "c", "", "Provider", "intellij.database.dialects.exasol"})
public final class ExaNamingService
extends AbstractNamingService {
    @NotNull
    public static final ExaNamingService INSTANCE;

    @Override
    protected boolean matchesCasing(char c) {
        return !Character.isTitleCase(c) && !Character.isLowerCase(c);
    }

    @Override
    @NotNull
    public String getOpeningQuotes() {
        return "\"[";
    }

    @Override
    @NotNull
    public String getClosingQuotes() {
        return "\"]";
    }

    private ExaNamingService() {
        Dbms dbms = Dbms.EXASOL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.EXASOL");
        Pattern pattern = Pattern.compile("[\\p{Ll}\\p{Lt}\\p{Lu}\\p{Lm}\\p{Lo}\\p{Nl}][\\p{Ll}\\p{Lt}\\p{Lu}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}\\p{Cf}\\u00B7]*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\n  \"\"\"[\\\u2026}\\p{Pc}\\p{Cf}\\u00B7]*\"\"\")");
        Casing casing = CasingProvider.UPPER_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"CasingProvider.UPPER_CASING");
        super(dbms, pattern, casing);
    }

    static {
        ExaNamingService exaNamingService;
        INSTANCE = exaNamingService = new ExaNamingService();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/exasol/generator/ExaNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.exasol"})
    public static final class Provider
    implements NamingService.Provider {
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            return INSTANCE;
        }
    }
}

