/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoColumnsOrderByGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoDeleteColumnGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoDeleteRowsGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoInsertRowsGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoPredicatesWhereClauseGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoSelectGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoUpdateRowGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoValuesWhereClauseGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoWrapInSelectGenerator;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.dml.ColumnsOrderByTask;
import com.intellij.database.script.generator.dml.DeleteColumnTask;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.script.generator.dml.PredicatesWhereClauseTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.UpdateRowTask;
import com.intellij.database.script.generator.dml.ValuesWhereClauseTask;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J!\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0016\u00a2\u0006\u0002\u0010#J0\u0010$\u001a\u0016\u0012\u0004\u0012\u0002H \u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\"\u0018\u00010%\"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0002J\u001a\u0010&\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/mongo/MongoDmlHelper;", "Lcom/intellij/database/script/generator/dml/DmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "emptyFilterText", "", "getEmptyFilterText", "()Ljava/lang/String;", "emptySortingText", "getEmptySortingText", "hideRowId", "", "getHideRowId", "()Z", "needAliasInDeleteStatement", "getNeedAliasInDeleteStatement", "orderByPrefix", "getOrderByPrefix", "supportsInsertDefaultValues", "getSupportsInsertDefaultValues", "wherePrefix", "getWherePrefix", "appendPlaceholderForInsert", "", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "table", "Lcom/intellij/database/model/DasTable;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "generate", "OUT", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "(Lcom/intellij/database/script/generator/dml/DmlTask;)Ljava/lang/Object;", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "hasRowId", "version", "Lcom/intellij/database/util/Version;", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.mongo"})
public final class MongoDmlHelper
implements DmlHelper {
    @NotNull
    private final String emptyFilterText;
    @NotNull
    private final String wherePrefix;
    @NotNull
    private final String emptySortingText;
    @NotNull
    private final String orderByPrefix;
    private final boolean supportsInsertDefaultValues;
    private final boolean needAliasInDeleteStatement;
    private final boolean hideRowId;
    private final Dbms dbms;

    @NotNull
    public String getEmptyFilterText() {
        return this.emptyFilterText;
    }

    @NotNull
    public String getWherePrefix() {
        return this.wherePrefix;
    }

    @NotNull
    public String getEmptySortingText() {
        return this.emptySortingText;
    }

    @NotNull
    public String getOrderByPrefix() {
        return this.orderByPrefix;
    }

    public boolean getSupportsInsertDefaultValues() {
        return this.supportsInsertDefaultValues;
    }

    public boolean getNeedAliasInDeleteStatement() {
        return this.needAliasInDeleteStatement;
    }

    public boolean getHideRowId() {
        return this.hideRowId;
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return false;
    }

    public <OUT> OUT generate(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator<OUT, DmlTask<OUT>> dmlGenerator = this.getGenerator(task);
        if (dmlGenerator == null) {
            throw (Throwable)new UnsupportedOperationException("Task is not supported " + task);
        }
        DmlGenerator<OUT, DmlTask<OUT>> generator = dmlGenerator;
        return generator.generate();
    }

    private final <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(DmlTask<? extends OUT> task) {
        DmlGenerator dmlGenerator;
        DmlTask<? extends OUT> dmlTask = task;
        if (!((dmlTask instanceof ValuesWhereClauseTask ? (DmlGenerator)new MongoValuesWhereClauseGenerator((ValuesWhereClauseTask)task, this.dbms) : (dmlTask instanceof PredicatesWhereClauseTask ? (DmlGenerator)new MongoPredicatesWhereClauseGenerator((PredicatesWhereClauseTask)task, this.dbms) : (dmlTask instanceof ColumnsOrderByTask ? (DmlGenerator)new MongoColumnsOrderByGenerator((ColumnsOrderByTask)task, this.dbms) : (dmlTask instanceof WrapInSelectTask ? (DmlGenerator)new MongoWrapInSelectGenerator((WrapInSelectTask)task, this.dbms) : (dmlTask instanceof SelectTask ? (DmlGenerator)new MongoSelectGenerator((SelectTask)task, this.dbms) : (dmlTask instanceof InsertRowsTask ? (DmlGenerator)new MongoInsertRowsGenerator((InsertRowsTask)task, this.dbms) : (dmlTask instanceof DeleteRowsTask ? (DmlGenerator)new MongoDeleteRowsGenerator((DeleteRowsTask)task, this.dbms) : (dmlTask instanceof UpdateRowTask ? (DmlGenerator)new MongoUpdateRowGenerator((UpdateRowTask)task, this.dbms) : (dmlGenerator = dmlTask instanceof DeleteColumnTask ? (DmlGenerator)new MongoDeleteColumnGenerator((DeleteColumnTask)task, this.dbms) : null))))))))) instanceof DmlGenerator)) {
            dmlGenerator = null;
        }
        return dmlGenerator;
    }

    public boolean isEditableTable(@Nullable ObjectKind kind) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE);
    }

    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d, @NotNull DasTable table, @NotNull DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    public MongoDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.emptyFilterText = "{}";
        this.wherePrefix = "filter";
        this.emptySortingText = "{}";
        this.orderByPrefix = "sort";
    }
}

