/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.mssql.AbstractTsqlDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseDialogsHelperCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.psi.MssqlAlterDatabaseStatement;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDialect
extends AbstractTsqlDialect
implements DatabaseDialect {
    private final Dbms myDbms;

    public MsDialect(@NotNull Dbms dbms) {
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(0);
        }
        super(new TypeHelper.MsTypeHelper());
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            MsDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "SQL Server";
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String sqlType;
        if (dataType == null) {
            MsDialect.$$$reportNull$$$0(2);
        }
        if ("money".equals(sqlType = dataType.getSpecification())) {
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            MsDialect.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(4);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, (NamingService)this.getNamingService()) + "'"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            MsDialect.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, (NamingService)this.getNamingService()) + "'"), (Object)DbImplUtilCore.ConcatenationProps.TIGHT);
        if (pair == null) {
            MsDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MsDialect.$$$reportNull$$$0(8);
        }
        if (qualifier == null) {
            MsDialect.$$$reportNull$$$0(9);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            MsDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MsDialect.$$$reportNull$$$0(11);
        }
        return dialect instanceof MsDialect;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(12);
        }
        if (element instanceof MssqlAlterDatabaseStatement) {
            for (PsiElement child : SqlImplUtil.sqlChildren((PsiElement)element)) {
                IElementType elementType;
                if (PsiUtilCore.getElementType((PsiElement)child) != SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE || (elementType = PsiUtilCore.getElementType((PsiElement)child.getFirstChild())) != MsTypes.MSSQL_ONLINE && elementType != MsTypes.MSSQL_OFFLINE) continue;
                return true;
            }
        }
        if (element instanceof SqlCallStatement) {
            String name2;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)element, SqlFunctionCallExpression.class);
            SqlReferenceExpression referenceExpression = callExpression != null ? callExpression.getNameElement() : null;
            String string = name2 = referenceExpression != null ? referenceExpression.getName() : null;
            if ("sp_addlinkedserver".equals(name2) || "sp_dropserver".equals(name2)) {
                return true;
            }
        }
        return super.triggersIntrospection(element);
    }

    private static boolean isMax(@Nullable String type, @Nullable String length) {
        return type != null && length != null && StringUtil.equals((CharSequence)"-1", (CharSequence)length) && !MsDialect.isLargeType(type);
    }

    private static boolean isLargeType(@Nullable String type) {
        return StringUtil.findIgnoreCase((String)type, (String[])new String[]{"xml", "image", "text", "ntext"});
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (element == null) {
            MsDialect.$$$reportNull$$$0(13);
        }
        if (connection == null) {
            MsDialect.$$$reportNull$$$0(14);
        }
        Map map2 = DbImplUtilCore.resultRowAsMap((DatabaseConnectionCore)connection, (String)String.format("EXEC sp_spaceused '%s'", DbImplUtilCore.escapeStr((String)QNameUtil.getQualifiedName((DbElement)element))), (String[])new String[]{"rows", "rows"});
        if (map2 == null) {
            MsDialect.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (table == null) {
            MsDialect.$$$reportNull$$$0(16);
        }
        if (connection == null) {
            MsDialect.$$$reportNull$$$0(17);
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        SmartStatementFactory statements2 = SmartStatementFactoryService.getInstance().poweredBy(connection);
        List pkColumns = (List)statements2.simple().noisy().execute((Object)pkColumnsQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.listOfStrings((String)"column_name"));
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        AbstractDatabaseDialect dialect = (AbstractDatabaseDialect)DbImplUtilCore.getDatabaseDialect((Dbms)Dbms.MSSQL);
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelperCore.createDdlBuilder((DbElement)((DbElement)table), (boolean)false) : new DdlBuilder().withDialect((DatabaseDialectEx)dialect);
        ddl.keywords(new String[]{"create", "table"}).space().qualifiedRef((DasObject)table).space().symbol("(");
        statements2.simple().noisy().execute((Object)columns, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results(rs -> {
            boolean first2 = true;
            while (rs.next()) {
                if (first2) {
                    first2 = false;
                } else {
                    ddl.symbol(",");
                }
                String name2 = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("column_name"));
                String defaults = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("column_default"));
                String type = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("data_type"));
                String length = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("character_maximum_length"));
                String precision = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("numeric_precision"));
                String scale = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("numeric_scale"));
                String isNullableStr = (String)JdbcNativeUtil.computeSafe(() -> rs.getString("is_nullable"));
                boolean isNotNull = "NO".equals(isNullableStr);
                length = MsDialect.isMax(type, length) ? String.valueOf(Integer.MAX_VALUE) : length;
                String substitution = dialect.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
                ddl.newLine().space(spaces).columnRef(name2 != null ? name2 : "<name>").space().type(substitution);
                if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name2)) {
                    ddl.space().keywords(new String[]{"primary", "key"});
                }
                if (defaults != null) {
                    ddl.space().keywords(new String[]{"default"}).space().literal(defaults);
                }
                if (!isNotNull) continue;
                ddl.space().keywords(new String[]{"not", "null"});
            }
        }));
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords(new String[]{"primary", "key"}).space().symbol("(");
            boolean f = true;
            for (Object pk : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier((String)pk);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        List fkNames = (List)statements2.simple().noisy().execute((Object)fkQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            SmartList result2 = new SmartList();
            while (rs.next()) {
                result2.add(rs.getString("constraint_name"));
            }
            return result2;
        }, (Object)ContainerUtil.emptyList()));
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            LinkedHashSet fromCols = new LinkedHashSet();
            LinkedHashSet toCols = new LinkedHashSet();
            String refTableName = "<ref_table>";
            try (ClosableResultsProducer producer = statements2.simple().noisy().execute((Object)fkCols, (ExecutionMode)StandardExecutionMode.QUERY);){
                RemoteResultSet rs2;
                RemoteResultSet remoteResultSet = rs2 = producer.advance() ? (RemoteResultSet)producer.processCurrent((ResultsProducer.Processor)StandardResultsProcessors.RESULT_SET) : null;
                if (rs2 != null) {
                    while (rs2.next()) {
                        refTableName = rs2.getString("table_name");
                        ContainerUtil.addIfNotNull(fromCols, (Object)rs2.getString("from_col"));
                        ContainerUtil.addIfNotNull(toCols, (Object)rs2.getString("column_name"));
                    }
                }
            }
            ddl.symbol(",").newLine().space(spaces).keywords(new String[]{"foreign", "key"}).space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList((DdlBuilder)ddl, toCols);
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String indices = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        MultiMap indexColumns = new MultiMap();
        HashMap<String, Boolean> indexUnique = new HashMap<String, Boolean>();
        try (ClosableResultsProducer producer = statements2.simple().noisy().execute((Object)indices, (ExecutionMode)StandardExecutionMode.QUERY);){
            RemoteResultSet rs3;
            RemoteResultSet remoteResultSet = rs3 = producer.advance() ? (RemoteResultSet)producer.processCurrent((ResultsProducer.Processor)StandardResultsProcessors.RESULT_SET) : null;
            if (rs3 != null) {
                while (rs3.next()) {
                    String indexName = rs3.getString("index_name");
                    String columnName = rs3.getString("col_name");
                    boolean isUnique = rs3.getBoolean("is_unique");
                    indexColumns.putValue((Object)indexName, (Object)columnName);
                    indexUnique.put(indexName, isUnique);
                }
            }
        }
        for (String i2 : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i2);
            Boolean isUnique = (Boolean)indexUnique.get(i2);
            ddl.newLine().keywords(new String[]{"create"}).space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i2).space().keyword("on").space().identifier(tableName).space().symbol("(");
            boolean first2 = true;
            for (String col : colNames) {
                if (first2) {
                    first2 = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string = ddl.getStatement();
        if (string == null) {
            MsDialect.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection) throws SQLException {
        if (connection == null) {
            MsDialect.$$$reportNull$$$0(19);
        }
        List list = (List)DbImplUtilCore.executeAndGetResult((DatabaseConnectionCore)connection, (String)"SELECT [name] FROM sys.databases d WHERE d.database_id > 4", (ThrowableConvertor)DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            MsDialect.$$$reportNull$$$0(20);
        }
        return list;
    }

    public static boolean isMsSql2008(@Nullable Version version) {
        return version == null || version.isOrGreater(new int[]{10, 50});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

