/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DatabaseViewStructureProvider;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/OraDatabaseStructureProvider;", "Lcom/intellij/database/view/DatabaseViewStructureProvider;", "()V", "getFilter", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "hostKind", "Lcom/intellij/database/model/ObjectKind;", "kidKind", "options", "Lcom/intellij/database/view/DatabaseViewOptions;", "Companion", "HideAutoCreated", "HideDroppedSequences", "intellij.database.dialects.oracle"})
public final class OraDatabaseStructureProvider
implements DatabaseViewStructureProvider {
    private static final Set<ObjectKind> autocreatable;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public Predicate<BasicElement> getFilter(@NotNull ObjectKind hostKind, @NotNull ObjectKind kidKind, @NotNull DatabaseViewOptions options2) {
        Intrinsics.checkNotNullParameter((Object)hostKind, (String)"hostKind");
        Intrinsics.checkNotNullParameter((Object)kidKind, (String)"kidKind");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        HideAutoCreated p1 = autocreatable.contains(kidKind) && !options2.SHOW_GENERATED_OBJECTS ? HideAutoCreated.INSTANCE : null;
        HideDroppedSequences p2 = Intrinsics.areEqual((Object)kidKind, (Object)ObjectKind.SEQUENCE) || Intrinsics.areEqual((Object)kidKind, (Object)ObjectKind.NONE) ? HideDroppedSequences.INSTANCE : null;
        return OraDatabaseStructureProvider.Companion.and(p1, p2);
    }

    static {
        Companion = new Companion(null);
        autocreatable = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.MAT_LOG, ObjectKind.SEQUENCE, ObjectKind.CHECK, ObjectKind.INDEX, ObjectKind.NONE});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/oracle/OraDatabaseStructureProvider$HideAutoCreated;", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "()V", "test", "", "t", "intellij.database.dialects.oracle"})
    public static final class HideAutoCreated
    implements Predicate<BasicElement> {
        @NotNull
        public static final HideAutoCreated INSTANCE;

        @Override
        public boolean test(@NotNull BasicElement t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return !t.isAutoCreated();
        }

        private HideAutoCreated() {
        }

        static {
            HideAutoCreated hideAutoCreated;
            INSTANCE = hideAutoCreated = new HideAutoCreated();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/oracle/OraDatabaseStructureProvider$HideDroppedSequences;", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "()V", "test", "", "t", "intellij.database.dialects.oracle"})
    public static final class HideDroppedSequences
    implements Predicate<BasicElement> {
        @NotNull
        public static final HideDroppedSequences INSTANCE;

        @Override
        public boolean test(@NotNull BasicElement t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            return t instanceof OraSequence ? !((OraSequence)t).isBelongsToDroppedTable() : true;
        }

        private HideDroppedSequences() {
        }

        static {
            HideDroppedSequences hideDroppedSequences;
            INSTANCE = hideDroppedSequences = new HideDroppedSequences();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0007\"\u0004\b\u0000\u0010\b*\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0007H\u0082\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/OraDatabaseStructureProvider$Companion;", "", "()V", "autocreatable", "", "Lcom/intellij/database/model/ObjectKind;", "and", "Ljava/util/function/Predicate;", "E", "that", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private final <E> Predicate<E> and(Predicate<E> $this$and, Predicate<E> that) {
            return $this$and != null && that != null ? $this$and.and(that) : ($this$and != null ? $this$and : (that != null ? that : null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

