/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.oracle.OraObjectBuilder;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraRecordColumn;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasTypedObjectEx;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCollectionTypeElementImpl;
import com.intellij.sql.dialects.oracle.psi.OraRecordTypeElementImpl;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0014\u0010/\u001a\u0004\u0018\u00010(2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010(2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010(2\b\u0010\u0007\u001a\u0004\u0018\u00010.H\u0014\u00a8\u00062"}, d2={"Lcom/intellij/database/dialects/oracle/OraObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "build", "Lcom/intellij/database/model/basic/BasicModElement;", "buildAliasType", "Lcom/intellij/database/dialects/oracle/model/OraAliasType;", "buildCluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "buildClusterColumn", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "buildCollectionType", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "buildMatView", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "buildObjectType", "Lcom/intellij/database/dialects/oracle/model/OraObjectType;", "buildObjectTypeBody", "Lcom/intellij/database/dialects/oracle/model/OraObjectTypeBody;", "buildOraIndex", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "buildPackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "buildPackageBody", "Lcom/intellij/database/dialects/oracle/model/OraPackageBody;", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "buildSingleRoutine", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getOraBodyContentRange", "getOraTypeContentRange", "getRoutineBodyRange", "intellij.database.dialects.oracle"})
public final class OraObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof OraCluster) {
            this.buildCluster((OraCluster)obj2, source, context);
        } else if (basicModElement instanceof OraClusterColumn) {
            this.buildClusterColumn((OraClusterColumn)obj2, source, context);
        } else if (basicModElement instanceof OraCollectionTypeBase) {
            this.buildCollectionType((OraCollectionTypeBase)obj2, source, context);
        } else if (basicModElement instanceof OraObjectType) {
            this.buildObjectType((OraObjectType)obj2, source, context);
        } else if (basicModElement instanceof OraAliasType) {
            this.buildAliasType((OraAliasType)obj2, source, context);
        } else if (basicModElement instanceof OraSingleRoutine) {
            this.buildSingleRoutine((OraSingleRoutine)obj2, source, context);
        } else if (basicModElement instanceof OraPackage) {
            this.buildPackage((OraPackage)obj2, source, context);
        } else if (basicModElement instanceof OraPackageBody) {
            this.buildPackageBody((OraPackageBody)obj2, source, context);
        } else if (basicModElement instanceof OraObjectTypeBody) {
            this.buildObjectTypeBody((OraObjectTypeBody)obj2, source, context);
        } else if (basicModElement instanceof OraMatView) {
            this.buildMatView((OraMatView)obj2, source, context);
        } else if (basicModElement instanceof OraTrigger) {
            this.buildTrigger((OraTrigger)obj2, source, context);
        } else if (basicModElement instanceof OraIndex) {
            this.buildOraIndex((OraIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? this.getOraTypeContentRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE) ? this.getOraBodyContentRange(def) : super.getCompactDefinition(path, text, def)));
    }

    private final TextRange getOraTypeContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement = (PsiElement)def;
        SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SqlTokens.SQL_LEFT_PAREN");
        PsiElement psiElement2 = this.findChild(psiElement, (IElementType)sqlTokenType);
        if (psiElement2 != null) {
            int n;
            PsiElement psiElement3 = psiElement2;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            TextRange textRange2 = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"it.textRange");
            int n2 = textRange2.getEndOffset();
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SqlTokens.SQL_RIGHT_PAREN");
            PsiElement psiElement4 = this.findSibling(it, (IElementType)sqlTokenType2);
            if (psiElement4 != null && (psiElement4 = psiElement4.getTextRange()) != null) {
                n = psiElement4.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                TextRange textRange3 = psiObject.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"def!!.textRange");
                n = textRange3.getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    private final TextRange getOraBodyContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement;
        block5: {
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement psiElement2 = (PsiElement)def;
            PsiElement element$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlTokens.SQL_IS) || Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlTokens.SQL_AS))) continue;
                psiElement = tmp$iv$iv;
                break block5;
            }
            psiElement = null;
        }
        if (psiElement != null) {
            int n;
            PsiElement psiElement3 = psiElement;
            boolean bl = false;
            boolean bl2 = false;
            PsiElement it = psiElement3;
            boolean bl3 = false;
            TextRange textRange2 = it.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"it.textRange");
            int n2 = textRange2.getEndOffset();
            SqlTokenType sqlTokenType = SqlTokens.SQL_END;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SqlTokens.SQL_END");
            PsiElement psiElement4 = this.findSibling(it, (IElementType)sqlTokenType);
            if (psiElement4 != null && (psiElement4 = psiElement4.getTextRange()) != null) {
                n = psiElement4.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                TextRange textRange3 = psiObject.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"def!!.textRange");
                n = textRange3.getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    private final void buildTrigger(OraTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        OraTrigger oraTrigger = obj2;
        if (oraTrigger == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        }
        this.buildTrigger((BasicModTrigger)oraTrigger, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final CompositeText invoke() {
                SimpleCompositeText simpleCompositeText;
                SqlCreateTriggerStatement sqlCreateTriggerStatement;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateTriggerStatement)) {
                    dasObject = null;
                }
                if ((sqlCreateTriggerStatement = (SqlCreateTriggerStatement)dasObject) != null) {
                    String string;
                    PsiElement psiElement;
                    SqlCreateTriggerStatement ct;
                    block7: {
                        SqlCreateTriggerStatement sqlCreateTriggerStatement2 = sqlCreateTriggerStatement;
                        boolean bl = false;
                        boolean bl2 = false;
                        ct = sqlCreateTriggerStatement2;
                        boolean bl3 = false;
                        SqlObjectBuilderImpl this_$iv = this.this$0;
                        boolean $i$f$findChild = false;
                        SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
                        PsiElement psiElement2 = (PsiElement)ct;
                        PsiElement element$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
                        boolean $i$f$findSibling = false;
                        for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                            PsiElement it$iv = tmp$iv$iv;
                            boolean bl4 = false;
                            if (!(it$iv instanceof SqlStatement)) continue;
                            psiElement = tmp$iv$iv;
                            break block7;
                        }
                        psiElement = null;
                    }
                    SqlStatement sqlStatement = (SqlStatement)psiElement;
                    if (sqlStatement != null) {
                        SqlStatement sqlStatement2 = sqlStatement;
                        boolean bl = false;
                        boolean bl5 = false;
                        SqlStatement it = sqlStatement2;
                        boolean bl6 = false;
                        String string2 = ct.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ct.text");
                        String string3 = string2;
                        int n = it.getStartOffsetInParent();
                        boolean bl7 = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(n);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    } else {
                        string = sqlCreateTriggerStatement = null;
                    }
                    if (string != null) {
                        simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)sqlCreateTriggerStatement, null, 1, null);
                        return (CompositeText)simpleCompositeText;
                    }
                }
                simpleCompositeText = null;
                return (CompositeText)simpleCompositeText;
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    private final void buildMatView(OraMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return (CompositeText)OraObjectBuilder.access$getViewQuery(this.this$0, this.$source, CompositeText.Kind.ORIGINAL_TEXT);
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    private final void buildSingleRoutine(OraSingleRoutine obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildRoutine(obj2, source, context);
    }

    @Override
    protected void buildRoutineSources(@NotNull BasicModSourceAware obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final CompositeText invoke() {
                SimpleCompositeText simpleCompositeText;
                Integer n = OraObjectBuilder.access$extractOraSourceStart(this.this$0, this.$source, buildRoutineSources.1.INSTANCE);
                if (n == null) {
                    simpleCompositeText = null;
                    return (CompositeText)simpleCompositeText;
                }
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                DasObject dasObject = this.$source;
                if (dasObject == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.PsiObject");
                }
                PsiObject cfr_ignored_0 = (PsiObject)dasObject;
                Object object = ((PsiObject)this.$source).getContainingFile();
                if (object != null && (object = object.getNode()) != null && (object = object.getChars()) != null) {
                    Object object2 = object;
                    TextRange textRange = ((PsiObject)this.$source).getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"source.textRange");
                    TextRange textRange2 = this.this$0.getRoutineBodyRange((PsiObject)this.$source);
                    int n3 = RangesKt.coerceAtLeast((int)textRange.getEndOffset(), (int)(textRange2 != null ? textRange2.getEndOffset() : it));
                    boolean bl4 = false;
                    object = ((Object)object2.subSequence(it, n3)).toString();
                    if (object != null) {
                        simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null);
                        return (CompositeText)simpleCompositeText;
                    }
                }
                simpleCompositeText = null;
                return (CompositeText)simpleCompositeText;
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    @Override
    @Nullable
    protected TextRange getRoutineBodyRange(@Nullable PsiObject source) {
        SqlRoutineDefinition sqlRoutineDefinition;
        SqlRoutineDefinition sqlRoutineDefinition2;
        PsiObject psiObject;
        Integer s;
        Integer n;
        TextRange textRange;
        block9: {
            if (source == null) {
                return null;
            }
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
            PsiElement element$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement e2 = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiUtilCore.getElementType((PsiElement)e2);
                boolean bl2 = false;
                boolean bl3 = false;
                IElementType it = iElementType;
                boolean bl4 = false;
                boolean bl5 = Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_IS) || Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_AS);
                if (!bl5) continue;
                textRange = tmp$iv$iv;
                break block9;
            }
            textRange = null;
        }
        TextRange textRange2 = textRange;
        if (textRange != null && (textRange2 = textRange2.getTextRange()) != null) {
            int this_$iv = textRange2.getEndOffset();
            boolean bl = false;
            boolean bl6 = false;
            int it = this_$iv;
            boolean bl7 = false;
            Object object = source.getContainingFile();
            if (object == null || (object = object.getNode()) == null || (object = object.getChars()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"source.containingFile?.node?.chars ?: \"\"");
            n = this.skipSpaces(it, (CharSequence)object, 1);
        } else {
            n = s = null;
        }
        if (!((psiObject = source) instanceof SqlRoutineDefinition)) {
            psiObject = null;
        }
        if ((sqlRoutineDefinition2 = (SqlRoutineDefinition)psiObject) == null || (sqlRoutineDefinition2 = sqlRoutineDefinition2.getBody()) == null || (sqlRoutineDefinition2 = this.unionRanges((JBIterable<? extends PsiElement>)sqlRoutineDefinition2)) == null) {
            PsiObject psiObject2 = source;
            if (!(psiObject2 instanceof SqlStatement)) {
                psiObject2 = null;
            }
            sqlRoutineDefinition2 = sqlRoutineDefinition = this.extractSomethingAfter((PsiElement)((SqlStatement)psiObject2));
        }
        if (sqlRoutineDefinition2 == null) {
            TextRange textRange3 = source.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"source.textRange");
            TextRange textRange4 = TextRange.from((int)textRange3.getEndOffset(), (int)0);
            sqlRoutineDefinition = textRange4;
            Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"TextRange.from(source.textRange.endOffset, 0)");
        }
        SqlRoutineDefinition stmts = sqlRoutineDefinition;
        return s == null ? stmts : stmts.union(TextRange.create((int)s, (int)s));
    }

    private final void buildCluster(OraCluster obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        if (!(dasObject instanceof DasCluster)) {
            dasObject = null;
        }
        DasCluster dasCluster = (DasCluster)dasObject;
        obj2.setClusterType((ClusterType)(dasCluster != null ? dasCluster.getClusterType() : null));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildClusterColumn(OraClusterColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        block12: {
            block11: {
                this.buildBasicElement((BasicModElement)obj, source, context);
                if (!context.isStubBuilder()) {
                    v0 = source;
                    if (!(v0 instanceof DasTypedObject)) {
                        v0 = null;
                    }
                    if ((v1 = (DasTypedObject)v0) == null || (v1 = v1.getDataType()) == null) {
                        v2 = DataType.UNKNOWN;
                        v1 = v2;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"DataType.UNKNOWN");
                    }
                    obj.setDataType((DataType)v1);
                }
                var5_4 = source;
                this_$iv = this;
                $i$f$stubbed = false;
                var7_7 = $this$stubbed$iv;
                if (var7_7 instanceof OraClusterColumn) {
                    v3 = (BasicElement)$this$stubbed$iv;
                } else if (var7_7 instanceof SqlStubbedElement) {
                    v4 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    if (!(v4 instanceof SqlDefinitionStub)) {
                        v4 = null;
                    }
                    v5 = (SqlDefinitionStub)v4;
                    v6 /* !! */  = v5 != null ? v5.getElement() : null;
                    if (!(v6 /* !! */  instanceof OraClusterColumn)) {
                        v6 /* !! */  = null;
                    }
                    v3 = (BasicElement)((OraClusterColumn)v6 /* !! */ );
                } else {
                    v3 = null;
                }
                v7 = (OraClusterColumn)v3;
                if (v7 == null) break block11;
                v8 = v7.isSorted();
                break block12;
            }
            if (!(source instanceof SqlColumnDefinition)) ** GOTO lbl-1000
            v9 = (PsiElement)source;
            v10 = OraTypes.ORA_SORT;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"OraTypes.ORA_SORT");
            if (this.findChild(v9, v10) != null) {
                v8 = true;
            } else lbl-1000:
            // 2 sources

            {
                v8 = false;
            }
        }
        obj.setSorted(v8);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildCollectionType(OraCollectionTypeBase obj2, DasObject source, SqlObjectBuilder.Context context) {
        SqlTypeElement sqlTypeElement;
        PsiElement psiElement;
        SqlObjectBuilderImpl this_$iv$iv;
        OraCollectionTypeBase oraCollectionTypeBase;
        OraCollectionTypeElementImpl collectionTypeElement;
        boolean bl;
        PsiElement it$iv;
        PsiElement tmp$iv$iv;
        boolean $i$f$findSibling;
        Object element$iv$iv;
        boolean $i$f$findChild;
        SqlObjectBuilderImpl this_$iv;
        block20: {
            PsiElement psiElement2;
            block19: {
                BasicElement basicElement;
                void $this$stubbed$iv2;
                this.buildBasicElement((BasicModElement)obj2, source, context);
                DasObject dasObject = source;
                Object this_$iv2 = this;
                boolean $i$f$stubbed = false;
                void var7_9 = $this$stubbed$iv2;
                if (var7_9 instanceof OraCollectionTypeBase) {
                    basicElement = (BasicElement)$this$stubbed$iv2;
                } else if (var7_9 instanceof SqlStubbedElement) {
                    StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv2).getGreenStub();
                    if (!(stubElement instanceof SqlDefinitionStub)) {
                        stubElement = null;
                    }
                    SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
                    Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(object instanceof OraCollectionTypeBase)) {
                        object = null;
                    }
                    basicElement = (BasicElement)((OraCollectionTypeBase)object);
                } else {
                    basicElement = null;
                }
                OraCollectionTypeBase oraCollectionTypeBase2 = (OraCollectionTypeBase)basicElement;
                if (oraCollectionTypeBase2 != null) {
                    this_$iv2 = oraCollectionTypeBase2;
                    boolean $this$stubbed$iv2 = false;
                    $i$f$stubbed = false;
                    Object $this$apply = this_$iv2;
                    boolean bl2 = false;
                    obj2.setElementType($this$apply.getElementType());
                    obj2.setTypeKind($this$apply.getTypeKind());
                    return;
                }
                DasObject dasObject2 = source;
                if (!(dasObject2 instanceof SqlTypedDefinition)) {
                    dasObject2 = null;
                }
                SqlTypedDefinition typed = (SqlTypedDefinition)dasObject2;
                this_$iv = this;
                $i$f$findChild = false;
                SqlObjectBuilderImpl bl2 = this_$iv;
                PsiElement psiElement3 = (PsiElement)typed;
                element$iv$iv = psiElement3 != null ? psiElement3.getFirstChild() : null;
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    bl = false;
                    if (!(it$iv instanceof OraCollectionTypeElementImpl)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block19;
                }
                psiElement2 = null;
            }
            collectionTypeElement = (OraCollectionTypeElementImpl)psiElement2;
            this_$iv = this;
            oraCollectionTypeBase = obj2;
            $i$f$findChild = false;
            this_$iv$iv = this_$iv;
            PsiElement psiElement4 = (PsiElement)collectionTypeElement;
            element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
            $i$f$findSibling = false;
            for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                it$iv = tmp$iv$iv;
                bl = false;
                if (!(it$iv instanceof SqlTypeElement)) continue;
                psiElement = tmp$iv$iv;
                break block20;
            }
            psiElement = null;
        }
        SqlTypeElement sqlTypeElement2 = (SqlTypeElement)psiElement;
        OraCollectionTypeBase oraCollectionTypeBase3 = oraCollectionTypeBase;
        SqlTypeElement sqlTypeElement3 = sqlTypeElement2;
        if (sqlTypeElement3 == null || (sqlTypeElement3 = sqlTypeElement3.getDataType()) == null) {
            PsiElement psiElement5;
            block21: {
                this_$iv = this;
                oraCollectionTypeBase = oraCollectionTypeBase3;
                $i$f$findChild = false;
                this_$iv$iv = this_$iv;
                PsiElement psiElement6 = (PsiElement)collectionTypeElement;
                element$iv$iv = psiElement6 != null ? psiElement6.getFirstChild() : null;
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it$iv = tmp$iv$iv;
                    bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement5 = tmp$iv$iv;
                    break block21;
                }
                psiElement5 = null;
            }
            sqlTypeElement2 = (SqlReferenceExpression)psiElement5;
            oraCollectionTypeBase3 = oraCollectionTypeBase;
            SqlTypeElement sqlTypeElement4 = sqlTypeElement2;
            if (sqlTypeElement4 != null) {
                void it;
                this_$iv = sqlTypeElement4;
                $i$f$findChild = false;
                boolean bl3 = false;
                element$iv$iv = this_$iv;
                oraCollectionTypeBase = oraCollectionTypeBase3;
                boolean bl4 = false;
                SqlExpression sqlExpression = it.getQualifierExpression();
                if (!(sqlExpression instanceof SqlReferenceExpression)) {
                    sqlExpression = null;
                }
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
                boolean hasPackage = (sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null) != null;
                sqlTypeElement2 = DataTypeFactory.of((String)it.getText(), (int)0, (boolean)true, (boolean)hasPackage, null, (boolean)false);
                oraCollectionTypeBase3 = oraCollectionTypeBase;
                sqlTypeElement3 = sqlTypeElement2;
            } else {
                sqlTypeElement3 = sqlTypeElement = null;
            }
        }
        if (sqlTypeElement3 == null) {
            DataType dataType = DataType.UNKNOWN;
            sqlTypeElement = dataType;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataType.UNKNOWN");
        }
        oraCollectionTypeBase3.setElementType((DataType)sqlTypeElement);
        Object object = collectionTypeElement;
        if (object == null || (object = object.getKind()) == null) {
            object = OraCollectionTypeKind.NESTED_TABLE;
        }
        obj2.setTypeKind((OraCollectionTypeKind)((Object)object));
        if (obj2 instanceof OraPackageCollectionType && ((OraPackageCollectionType)obj2).getTypeKind() == OraCollectionTypeKind.ASSOCIATIVE_ARRAY) {
            PsiElement psiElement7 = (PsiElement)collectionTypeElement;
            IElementType iElementType = OraTypes.ORA_INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ORA_INDEX");
            PsiElement indexKeyword = this.findChild(psiElement7, iElementType);
            SqlTypeElement indexTypeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)indexKeyword, SqlTypeElement.class);
            OraPackageCollectionType oraPackageCollectionType = (OraPackageCollectionType)obj2;
            SqlTypeElement sqlTypeElement5 = indexTypeElement;
            if (sqlTypeElement5 == null || (sqlTypeElement5 = sqlTypeElement5.getDataType()) == null) {
                DataType dataType = DataType.UNKNOWN;
                sqlTypeElement5 = dataType;
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"DataType.UNKNOWN");
            }
            oraPackageCollectionType.setIndexElementType((DataType)sqlTypeElement5);
        }
    }

    private final void buildObjectType(OraObjectType obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        if (source instanceof SqlCreateTypeStatementImpl) {
            SqlReferenceExpression ref2;
            SqlReferenceExpression sqlReferenceExpression = ref2 = ((SqlCreateTypeStatementImpl)source).getSuperTypeReference();
            obj2.setSuperObjectName(sqlReferenceExpression != null ? this.extractName((PsiElement)sqlReferenceExpression) : null);
            SqlReferenceExpression sqlReferenceExpression2 = ref2;
            obj2.setSuperSchemaName(sqlReferenceExpression2 != null && (sqlReferenceExpression2 = sqlReferenceExpression2.getQualifierExpression()) != null ? this.extractName((PsiElement)sqlReferenceExpression2) : null);
        }
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return OraObjectBuilder.access$extractOraSource(this.this$0, this.$source, buildObjectType.1.INSTANCE);
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAliasType(OraAliasType obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        if (context.isIntrospector()) {
            SqlTypeElement innerTypeElement;
            DasObject dasObject = source;
            if (!(dasObject instanceof SqlTypeDefinitionImpl)) {
                dasObject = null;
            }
            SqlTypeDefinitionImpl sqlTypeDefinitionImpl = (SqlTypeDefinitionImpl)dasObject;
            Object object = innerTypeElement = sqlTypeDefinitionImpl != null ? sqlTypeDefinitionImpl.getAliasedTypeElement() : null;
            if (innerTypeElement instanceof OraRecordTypeElementImpl) {
                boolean bl = false;
                JBIterable<DasTypedObjectEx> jBIterable = ((OraRecordTypeElementImpl)innerTypeElement).getColumns();
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"innerTypeElement.columns");
                for (DasTypedObjectEx sourceField : (Iterable)jBIterable) {
                    void i2;
                    OraRecordColumn field;
                    OraRecordColumn oraRecordColumn = field = (OraRecordColumn)obj2.getRecordColumns().createOrGetAt((short)(i2 + true));
                    Intrinsics.checkNotNullExpressionValue((Object)oraRecordColumn, (String)"field");
                    BasicModElement basicModElement = (BasicModElement)oraRecordColumn;
                    DasTypedObjectEx dasTypedObjectEx = sourceField;
                    Intrinsics.checkNotNullExpressionValue((Object)dasTypedObjectEx, (String)"sourceField");
                    this.build(basicModElement, (DasObject)dasTypedObjectEx, context);
                    ++i2;
                }
            }
        }
    }

    private final void buildPackage(OraPackage obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return OraObjectBuilder.access$extractOraSource(this.this$0, this.$source, buildPackage.1.INSTANCE);
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    private final void buildPackageBody(OraPackageBody obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return OraObjectBuilder.access$extractOraSource(this.this$0, this.$source, buildPackageBody.1.INSTANCE);
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    private final void buildObjectTypeBody(OraObjectTypeBody obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ OraObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return OraObjectBuilder.access$extractOraSource(this.this$0, this.$source, buildObjectTypeBody.1.INSTANCE);
            }
            {
                this.this$0 = oraObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    @Override
    protected void assignName(@NotNull BasicModNamedElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModNamedElement basicModNamedElement = obj2;
        if (basicModNamedElement instanceof OraObjectTypeBody) {
            OraObjectTypeBody oraObjectTypeBody = (OraObjectTypeBody)obj2;
            OraObjectType oraObjectType = ((OraObjectTypeBody)obj2).getObjectType();
            Intrinsics.checkNotNull((Object)oraObjectType);
            Intrinsics.checkNotNullExpressionValue((Object)oraObjectType, (String)"obj.objectType!!");
            oraObjectTypeBody.setName(oraObjectType.getName());
        } else if (basicModNamedElement instanceof OraPackageBody) {
            OraPackageBody oraPackageBody = (OraPackageBody)obj2;
            OraPackage oraPackage = ((OraPackageBody)obj2).getPackage();
            Intrinsics.checkNotNull((Object)oraPackage);
            Intrinsics.checkNotNullExpressionValue((Object)oraPackage, (String)"obj.`package`!!");
            oraPackageBody.setName(oraPackage.getName());
        } else if (context.isIntrospector()) {
            Casing casing = OraDialect.INSTANCE.getCasing(source.getKind(), source);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"OraDialect.INSTANCE.getCasing(source.kind, source)");
            Casing casing2 = casing;
            obj2.setName(SqlImplUtil.getEffectiveName((String)source.getName(), (boolean)DbSqlUtilCore.isQuoted((DasObject)source), (Casing)casing2));
        } else {
            super.assignName(obj2, source, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildOraIndex(OraIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbed$iv2;
        super.buildIndex(obj2, source, context);
        if (!(source instanceof SqlCreateIndexStatement)) {
            return;
        }
        DasObject dasObject = source;
        Object this_$iv = this;
        boolean $i$f$stubbed = false;
        void var7_9 = $this$stubbed$iv2;
        if (var7_9 instanceof OraIndex) {
            basicElement = (BasicElement)$this$stubbed$iv2;
        } else if (var7_9 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv2).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof OraIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((OraIndex)object);
        } else {
            basicElement = null;
        }
        OraIndex oraIndex = (OraIndex)basicElement;
        if (oraIndex != null) {
            this_$iv = oraIndex;
            boolean $this$stubbed$iv2 = false;
            $i$f$stubbed = false;
            Object $this$apply = this_$iv;
            boolean bl = false;
            obj2.setIndextypeName($this$apply.getIndextypeName());
            obj2.setIndextypeOwner($this$apply.getIndextypeOwner());
            return;
        }
        PsiElement indextypeRef = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)source), (IElementType)((IElementType)OraElementTypes.Extra.ORA_INDEXTYPE_REFERENCE));
        SqlIdentifier indextypeIdent = (SqlIdentifier)PsiTreeUtil.getChildOfType((PsiElement)indextypeRef, SqlIdentifier.class);
        SqlReferenceExpression indextypeOwner = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)indextypeRef, SqlReferenceExpression.class);
        SqlIdentifier sqlIdentifier = indextypeIdent;
        obj2.setIndextypeName(sqlIdentifier != null ? sqlIdentifier.getName() : null);
        SqlReferenceExpression sqlReferenceExpression = indextypeOwner;
        obj2.setIndextypeOwner(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null);
    }

    public static final /* synthetic */ Object access$findChild(OraObjectBuilder $this, PsiElement el) {
        return $this.findChild(el);
    }

    public static final /* synthetic */ SimpleCompositeText access$getViewQuery(OraObjectBuilder $this, DasObject source, CompositeText.Kind kind) {
        return $this.getViewQuery(source, kind);
    }

    public static final /* synthetic */ Integer access$extractOraSourceStart(OraObjectBuilder $this, DasObject source, Function1 cnd) {
        return $this.extractOraSourceStart(source, (Function1<? super IElementType, Boolean>)cnd);
    }

    public static final /* synthetic */ CompositeText access$extractOraSource(OraObjectBuilder $this, DasObject source, Function1 cnd) {
        return $this.extractOraSource(source, (Function1<? super IElementType, Boolean>)cnd);
    }
}

