/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.introspector.PgIntrospector;
import com.intellij.database.dialects.postgres.introspector.PgIntrospector$MyDatabaseRetriever$retrieveEventTriggers$1$$special$;
import com.intellij.database.dialects.postgres.introspector.PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$$special$;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgEventTrigger;
import com.intellij.database.dialects.postgres.model.PgIndex;
import com.intellij.database.dialects.postgres.model.PgKey;
import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSecurityPolicy;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgView;
import com.intellij.database.dialects.postgres.model.properties.PgCheckOption;
import com.intellij.database.dialects.postgres.model.properties.PgDataTypeSubCategory;
import com.intellij.database.dialects.postgres.model.properties.PgIdentityKind;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgres.model.properties.PgSecurityPolicyOperationType;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.sql.psi.SqlCreateStatement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004$%&'B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "schema", "generateDbAge", "", "tx", "initConnectionRelatedState", "", "processRole", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "r", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneRole;", "Companion", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects.postgres"})
public final class PgIntrospector
extends PgGPlumBaseIntrospector<PgRoot, PgDatabase, PgSchema> {
    @JvmField
    @NotNull
    public static final PgIntroQueries QUERIES;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return PgModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    protected PgIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Companion.setVersionParameters(this.getServerVersion(), this.getParametersMap());
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(" + tx + "::varchar::xid)";
    }

    @Override
    protected void processRole(@NotNull PgGPlumBaseRole role, @NotNull PgGPlumBaseIntroQueries.OneRole r) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.processRole(role, r);
        if (!(role instanceof PgRole)) {
            return;
        }
        ((PgRole)role).setReplication(r.is_replication);
        ((PgRole)role).setBypassRls(r.bypass_rls);
    }

    @NotNull
    protected MyDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    public PgIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.POSTGRES;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.POSTGRES");
        super(dbms, project, modelFactory);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(PgIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"Scriptum.of(PgIntroQueries::class.java)");
        QUERIES = new PgIntroQueries(scriptum);
    }

    public static final /* synthetic */ Object access$parseStatement(PgIntrospector $this, String src2) {
        return $this.parseStatement(src2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.postgres"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return version.isOrGreater(new int[]{9});
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new PgIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return PgBaseIntrospectorKt.canCheckOutdated(e2);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.postgres"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "getNativeDefinitionQuery", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "retrieveEventTriggers", "", "detectDropped", "", "loadNew", "retrieveExtensions", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects.postgres"})
    protected final class MyDatabaseRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseDatabaseRetriever<PgDatabase> {
        @Override
        @Nullable
        protected String getNativeDefinitionQuery(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            String string = super.getNativeDefinitionQuery(kind);
            if (string == null) {
                string = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE) ? "select pg_get_functiondef(?)" : null;
            }
            return string;
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(super.steps(), 1, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ MyDatabaseRetriever this$0;

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    BasicRoot basicRoot = MyDatabaseRetriever.access$getModel$p(this.this$0).getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
                    Version version = basicRoot.getServerVersion();
                    if (version != null) {
                        if (version.isOrGreater(new int[]{9, 3})) {
                            MyDatabaseRetriever.access$retrieveEventTriggers(this.this$0, detectDropped, loadNew);
                        }
                    }
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    super(2);
                }
            }));
        }

        @Override
        protected void retrieveExtensions(boolean detectDropped, boolean loadNew) {
            boolean supported = PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1});
            super.retrieveExtensions(detectDropped && supported, loadNew && supported);
        }

        private final void retrieveEventTriggers(boolean detectDropped, boolean loadNew) {
            PgIntrospector.this.reportRetrieving("event triggers", "introspection.retrieve.event.triggers");
            this.inDatabase((Function1)new Function1<PgDatabase, Unit>(this, detectDropped, loadNew){
                final /* synthetic */ MyDatabaseRetriever this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ boolean $loadNew;

                public final void invoke(@NotNull PgDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = MyDatabaseRetriever$retrieveEventTriggers$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl = false;
                    ModNamingIdentifyingFamily<? extends PgEventTrigger> modNamingIdentifyingFamily = db.getEventTriggers();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"db.eventTriggers");
                    it.invoke(modNamingIdentifyingFamily);
                    boolean bl2 = false;
                    if (this.$detectDropped) {
                        long[] $this$forEach$iv = (long[])MyDatabaseRetriever.access$performQuery(this.this$0, this.this$0.PgIntrospector.this.getQueries().getRetrieveExistentEventTriggers());
                        boolean $i$f$forEach = false;
                        long[] lArray = $this$forEach$iv;
                        int n = lArray.length;
                        for (int j = 0; j < n; ++j) {
                            long element$iv;
                            long it2 = element$iv = lArray[j];
                            boolean bl3 = false;
                            PgEventTrigger pgEventTrigger = (PgEventTrigger)db.getEventTriggers().getByObjectId(it2);
                            if (pgEventTrigger != null) {
                                pgEventTrigger.resetSyncPending();
                            }
                        }
                    }
                    if (this.$loadNew) {
                        BaseIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, PgIntrospector.QUERIES.getRetrieveEventTriggers(), 0, (Function1)new Function1<PgIntroQueries.OneEventTrigger, Unit>(this, db){
                            final /* synthetic */ retrieveEventTriggers.1 this$0;
                            final /* synthetic */ PgDatabase $db$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$db$inlined = pgDatabase;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PgIntroQueries.OneEventTrigger et) {
                                Object object;
                                PgEventTrigger pgEventTrigger;
                                PgEventTrigger $this$apply;
                                block3: {
                                    block2: {
                                        void it;
                                        Intrinsics.checkNotNullParameter((Object)et, (String)"et");
                                        BasicModNamedElement basicModNamedElement = this.$db$inlined.getEventTriggers().renew(et.id, et.name);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        $this$apply = (PgEventTrigger)basicModNamedElement;
                                        boolean bl3 = false;
                                        $this$apply.setStateNumber(et.state_number);
                                        pgEventTrigger = $this$apply;
                                        object = et.tags;
                                        if (et.tags == null) break block2;
                                        String[] stringArray = object;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        String[] stringArray2 = stringArray;
                                        PgEventTrigger pgEventTrigger2 = pgEventTrigger;
                                        boolean bl6 = false;
                                        void v2 = it;
                                        Set set = SetsKt.setOf((Object[])((String[])Arrays.copyOf(v2, ((void)v2).length)));
                                        pgEventTrigger = pgEventTrigger2;
                                        object = set;
                                        if (object != null) break block3;
                                    }
                                    object = SetsKt.emptySet();
                                }
                                pgEventTrigger.setTags((Set<String>)object);
                                $this$apply.setEvent(et.event);
                                $this$apply.setCallRoutineId(et.routine_id);
                            }
                        }, 2, null);
                    }
                    it = MyDatabaseRetriever$retrieveEventTriggers$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    bl = false;
                    ModNamingIdentifyingFamily<? extends PgEventTrigger> modNamingIdentifyingFamily2 = db.getEventTriggers();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"db.eventTriggers");
                    it.invoke(modNamingIdentifyingFamily2);
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    this.$detectDropped = bl;
                    this.$loadNew = bl2;
                    super(1);
                }
            });
        }

        public MyDatabaseRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        public static final /* synthetic */ BasicModModel access$getModel$p(MyDatabaseRetriever $this) {
            return $this.getModel();
        }

        public static final /* synthetic */ void access$retrieveEventTriggers(MyDatabaseRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveEventTriggers(detectDropped, loadNew);
        }

        public static final /* synthetic */ Object access$performQuery(MyDatabaseRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0014J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0&2\u0006\u0010'\u001a\u00020(H\u0014J \u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u0002H\u0014J \u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u0002012\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u00102\u001a\u00020\u001b2\u0006\u0010'\u001a\u0002012\u0006\u00103\u001a\u000204H\u0014J\u0018\u00105\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J \u00106\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u00022\u0006\u00107\u001a\u000204H\u0014J\u0018\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u0013H\u0014J\b\u0010?\u001a\u00020\u001bH\u0014J\b\u0010@\u001a\u00020\u001bH\u0002J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0010H\u0014\u00a8\u0006C"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgSchema;)V", "createRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "getSequencesQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneSequence;", "hasReference", "", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalViewSources", "isTableKind", "kind", "", "processAggregate", "", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "processModTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processTable", "oneTable", "processTrigger", "trigger", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneTrigger;", "retrieveCollations", "detectDropped", "loadNew", "retrieveForeignTablesInfo", "retrieveSecurityPolicies", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects.postgres"})
    protected final class MySchemaRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseSchemaRetriever<PgSchema> {
        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(super.steps(), 120, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    MySchemaRetriever.access$retrieveSecurityPolicies(this.this$0);
                }
                {
                    this.this$0 = mySchemaRetriever;
                    super(2);
                }
            }));
        }

        @Override
        @NotNull
        protected SqlQuery<List<PgGPlumBaseIntroQueries.OneSequence>> getSequencesQuery() {
            return PgIntrospector.this.getServerVersion().isOrGreater(new int[]{10, -10}) ? QUERIES.getRetrieveSequences10() : super.getSequencesQuery();
        }

        @Override
        protected void retrieveForeignTablesInfo() {
            if (PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1})) {
                super.retrieveForeignTablesInfo();
            }
        }

        @Override
        protected void retrieveCollations(boolean detectDropped, boolean loadNew) {
            boolean isSupported = PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 1});
            super.retrieveCollations(detectDropped && isSupported, loadNew && isSupported);
        }

        @Override
        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super.processDataType(dataType, oneType, (PgGPlumBaseSchema)schema);
            if (!(dataType instanceof PgDefType)) {
                return;
            }
            ((PgDefType)dataType).setSubCategory(PgDataTypeSubCategory.of(oneType.type_category));
        }

        @Override
        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            long l;
            long it;
            PgLikeStoredTable pgLikeStoredTable;
            boolean bl;
            boolean bl2;
            long l2;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgGPlumBaseSchema)schema, oneTable);
            if (table instanceof PgMatView) {
                l2 = oneTable.tablespace_id;
                bl2 = false;
                bl = false;
                long l3 = l2;
                pgLikeStoredTable = (PgMatView)table;
                boolean bl3 = false;
                l = it == 0L ? Long.MIN_VALUE : it;
                pgLikeStoredTable.setTablespaceId(l);
            }
            if (table instanceof PgLocalTable) {
                l2 = oneTable.am_id;
                bl2 = false;
                bl = false;
                it = l2;
                pgLikeStoredTable = (PgLocalTable)table;
                boolean bl4 = false;
                l = it == 0L ? Long.MIN_VALUE : it;
                pgLikeStoredTable.setAccessMethodId(l);
            }
        }

        @Override
        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processModTable(table, t);
            if (!(table instanceof PgTable)) {
                return;
            }
            ((PgTable)table).setPartitioned(t.table_kind == 'p');
            ((PgTable)table).setPartition(t.is_partition);
            ((PgTable)table).setPartitionKey(t.partition_key);
            ((PgTable)table).setPartitionExpression(t.partition_expression);
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof PgView)) {
                return;
            }
            ((PgView)table).setCheckOption(ArraysKt.contains((Object[])t.options, (Object)"check_option=local") ? PgCheckOption.LOCAL : (ArraysKt.contains((Object[])t.options, (Object)"check_option=cascaded") ? PgCheckOption.CASCADED : PgCheckOption.NONE));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Object object;
            block5: {
                boolean bl;
                boolean bl2;
                Object object2;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)col, (String)"col");
                    Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
                    Intrinsics.checkNotNullParameter(columns, (String)"columns");
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    super.processColumn(col, column2, columns, table);
                    if (!(column2 instanceof PgLocalTableColumn)) {
                        return;
                    }
                    object = col.identity_kind;
                    if (object == null) break block4;
                    object2 = object;
                    bl2 = false;
                    bl = false;
                    char it = ((Character)object2).charValue();
                    boolean bl3 = false;
                    object = PgIdentityKind.Companion.valueFor(it);
                    if (object != null) break block5;
                }
                object2 = PgIdentityKind.ALWAYS;
                bl2 = false;
                bl = false;
                Object it = object2;
                boolean bl4 = false;
                object = Intrinsics.areEqual((Object)col.generated, (Object)"s") ? object2 : null;
            }
            Object kind = object;
            ((PgLocalTableColumn)column2).setIdentityKind((PgIdentityKind)((Object)kind));
        }

        @Override
        protected void processKey(@NotNull PgBaseKey key2, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            super.processKey(key2, table, con);
            if (!(table instanceof PgLocalTable) || !(key2 instanceof PgKey)) {
                return;
            }
            PgIndex index2 = (PgIndex)((PgLocalTable)table).getIndices().getByObjectId(con.index_id);
            PgIndex pgIndex = index2;
            ((PgKey)key2).setUnderlyingIndexName(pgIndex != null ? pgIndex.getRealName() : null);
        }

        @Override
        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.index_id > 0L;
        }

        @Override
        @NotNull
        protected PgGPlumBaseRoutine createRoutine(@NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            PgGPlumBaseRoutine routine2;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgGPlumBaseRoutine pgGPlumBaseRoutine = routine2 = super.createRoutine((PgGPlumBaseSchema)schema, r);
            if (pgGPlumBaseRoutine == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgRoutine");
            }
            PgRoutine cfr_ignored_0 = (PgRoutine)pgGPlumBaseRoutine;
            ((PgRoutine)routine2).setConcurrencyKind(PgRoutineConcurrencyKind.of(r.concurrency_kind));
            ((PgRoutine)routine2).setWindow(r.kind == 'w');
            ((PgRoutine)routine2).setRows(r.rows);
            return routine2;
        }

        @Override
        protected void processTrigger(@NotNull PgGPlumBaseTrigger trigger, @NotNull PgGPlumBaseIntroQueries.OneTrigger t) {
            SqlCreateStatement createTrigger;
            SqlCreateStatement sqlCreateStatement;
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processTrigger(trigger, t);
            if (!(trigger instanceof PgTrigger)) {
                return;
            }
            ((PgTrigger)trigger).setDeferrable(t.is_deferrable);
            ((PgTrigger)trigger).setInitiallyDeferred(t.is_init_deferred);
            ((PgTrigger)trigger).setColumnIndices(PgIntrospector.this.parseListOfLongs(t.columns));
            ((PgTrigger)trigger).setConstraint(t.is_constraint);
            String string = t.source_code;
            if (string != null) {
                Object object;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                BaseIntrospector this_$iv = PgIntrospector.this;
                boolean $i$f$parseStatement = false;
                try {
                    IntrospectorSqlHelper this_$iv$iv = BaseIntrospector.access$getSqlHelper$p(this_$iv);
                    boolean $i$f$statements = false;
                    object = this_$iv$iv.statements(it, SqlCreateStatement.class).first();
                }
                catch (ProcessCanceledException pce$iv) {
                    throw (Throwable)pce$iv;
                }
                catch (Exception e$iv) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        this_$iv.log.error((Throwable)e$iv);
                    }
                    this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                    object = null;
                }
                sqlCreateStatement = (SqlCreateStatement)object;
            } else {
                sqlCreateStatement = createTrigger = null;
            }
            if (createTrigger != null) {
                PgIntrospector.this.getSqlHelper().getBuilder().build((BasicModElement)trigger, (DasObject)createTrigger, SqlObjectBuilder.INTROSPECTOR);
            }
        }

        @Override
        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgAggregate cfr_ignored_0 = (PgAggregate)aggregate;
            ((PgAggregate)aggregate).setStateSize(agg.state_size);
            ((PgAggregate)aggregate).setFinalExtra(agg.final_extra);
            ((PgAggregate)aggregate).setMovingTransitionId(agg.moving_transition_id);
            ((PgAggregate)aggregate).setMovingTransition(agg.moving_transition_name);
            ((PgAggregate)aggregate).setInverseTransitionId(agg.inverse_transition_id);
            ((PgAggregate)aggregate).setInverseTransition(agg.inverse_transition_name);
            PgAggregate pgAggregate = (PgAggregate)aggregate;
            DataType dataType = this.getMyTypes().get(agg.moving_state_type);
            if (dataType == null) {
                DataType dataType2 = DataType.UNKNOWN;
                dataType = dataType2;
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"DataType.UNKNOWN");
            }
            pgAggregate.setMovingStateType(dataType);
            ((PgAggregate)aggregate).setMovingStateSize(agg.moving_state_size);
            ((PgAggregate)aggregate).setMovingFinalId(agg.moving_final_id);
            ((PgAggregate)aggregate).setMovingFinal(agg.moving_final_name);
            ((PgAggregate)aggregate).setMovingFinalExtra(agg.moving_final_extra);
            ((PgAggregate)aggregate).setMovingInitialValue(agg.moving_initial_value);
            ((PgAggregate)aggregate).setCombine(agg.combine_function_name);
            ((PgAggregate)aggregate).setCombineId(agg.combine_function_id);
            ((PgAggregate)aggregate).setSerialization(agg.serialization_function_name);
            ((PgAggregate)aggregate).setSerializationId(agg.serialization_function_id);
            ((PgAggregate)aggregate).setDeserialization(agg.deserialization_function_name);
            ((PgAggregate)aggregate).setDeserializationId(agg.deserialization_function_id);
            ((PgAggregate)aggregate).setConcurrencyKind(PgRoutineConcurrencyKind.of(agg.concurrency_kind));
            ((PgAggregate)aggregate).setOwner(agg.getOwnerName());
        }

        @Override
        protected boolean incrementalViewSources() {
            return PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 2});
        }

        @Override
        protected boolean isTableKind(char kind) {
            return super.isTableKind(kind) || kind == 'p';
        }

        private final void retrieveSecurityPolicies() {
            boolean isSupported = PgIntrospector.this.getServerVersion().isOrGreater(new int[]{9, 5});
            ObjectKind objectKind = ObjectKind.SECURITY_POLICY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.SECURITY_POLICY");
            PgIntrospector.this.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<PgSchema, Unit>(this, isSupported){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ boolean $isSupported;

                public final void invoke(@NotNull PgSchema schema) {
                    boolean bl;
                    PgLocalTable t;
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    boolean $i$f$cleanupFamilies = false;
                    Function1 it = MySchemaRetriever$retrieveSecurityPolicies$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                    boolean bl2 = false;
                    ModNamingIdentifyingFamily<? extends PgLocalTable> modNamingIdentifyingFamily = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"schema.tables");
                    Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        t = (PgLocalTable)element$iv;
                        bl = false;
                        PgLocalTable pgLocalTable = t;
                        Intrinsics.checkNotNullExpressionValue((Object)pgLocalTable, (String)"t");
                        ModNamingFamily<? extends PgSecurityPolicy> modNamingFamily = pgLocalTable.getSecurityPolicies();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"t.securityPolicies");
                        it.invoke(modNamingFamily);
                    }
                    boolean bl3 = false;
                    if (this.$isSupported) {
                        NameCache<T> tableCache = new NameCache<T>();
                        BaseIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$0.PgIntrospector.this.getQueries().getRetrieveSecurityPolices(), 0, (Function1)new Function1<PgIntroQueries.OneSecurityPolicy, Unit>(tableCache, this, schema){
                            final /* synthetic */ NameCache $tableCache;
                            final /* synthetic */ retrieveSecurityPolicies.1 this$0;
                            final /* synthetic */ PgSchema $schema$inlined;
                            {
                                this.$tableCache = nameCache;
                                this.this$0 = var2_2;
                                this.$schema$inlined = pgSchema;
                                super(1);
                            }

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final void invoke(@NotNull PgIntroQueries.OneSecurityPolicy p) {
                                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                                v0 = p.tablename;
                                if (v0 == null) {
                                    return;
                                }
                                tableName = v0;
                                v1 = p.policyname;
                                if (v1 == null) {
                                    return;
                                }
                                name = v1;
                                this_$iv = this.$tableCache;
                                $i$f$get = false;
                                var6_6 = this_$iv;
                                create$iv$iv = false;
                                $i$f$get = false;
                                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                v2 = this_$iv$iv.getV();
                                Intrinsics.checkNotNull(v2);
                                if (Intrinsics.areEqual((Object)v2.getName(), (Object)tableName)) {
                                    v3 = this_$iv$iv.getV();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var9_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, tableName){
                                        final /* synthetic */ boolean $create;
                                        final /* synthetic */ String $name;
                                        {
                                            this.$create = bl;
                                            this.$name = string;
                                            super(1);
                                        }

                                        @Nullable
                                        public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                            Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                            return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                                        }
                                    };
                                    var10_12 /* !! */  = this_$iv$iv;
                                    var11_13 = this_$iv$iv;
                                    $i$a$-get-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$table$1 = false;
                                    v4 = this.$schema$inlined.getTables();
                                    Intrinsics.checkNotNullExpressionValue(v4, (String)"schema.tables");
                                    var13_16 = (PgLocalTable)it.invoke(v4);
                                    var11_13.setV((BasicModNamedElement)var13_16);
                                    v3 = this_$iv$iv.getV();
                                }
                                v5 = (PgLocalTable)v3;
                                if (v5 == null) {
                                    return;
                                }
                                table = v5;
                                var4_4 = table.getSecurityPolicies().createOrGet(name);
                                var5_5 = false;
                                var6_7 = false;
                                $this$apply = (PgSecurityPolicy)var4_4;
                                $i$a$-apply-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$1 = false;
                                $this$apply.setPermissive(p.permissive);
                                v6 /* !! */  = p.roles;
                                if (p.roles == null || (v6 /* !! */  = ArraysKt.toList((Object[])v6 /* !! */ )) == null) {
                                    v6 /* !! */  = CollectionsKt.emptyList();
                                }
                                $this$apply.setRoleNames((List<String>)v6 /* !! */ );
                                var9_11 = $this$apply;
                                try {
                                    v7 = var9_11;
                                    v8 = p.cmd;
                                    if (v8 == null) {
                                        v8 = "ALL";
                                    }
                                    var10_12 /* !! */  = v8;
                                    var10_12 /* !! */  = (PgSecurityPolicyOperationType)((Enum)PgSecurityPolicyOperationType.valueOf((String)var10_12 /* !! */ ));
                                }
                                catch (Exception $i$a$-get-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$table$1) {
                                    v7 = var9_11;
                                    var10_12 /* !! */  = PgSecurityPolicyOperationType.ALL;
                                }
                                v7.setOperationType(var10_12 /* !! */ );
                                $this$apply.setUsingExpression(p.qual);
                                $this$apply.setCheckExpression(p.with_check);
                            }
                        }, 2, null);
                    }
                    it = MySchemaRetriever$retrieveSecurityPolicies$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                    bl2 = false;
                    ModNamingIdentifyingFamily<? extends PgLocalTable> modNamingIdentifyingFamily2 = schema.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"schema.tables");
                    $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        t = (PgLocalTable)element$iv;
                        bl = false;
                        PgLocalTable pgLocalTable = t;
                        Intrinsics.checkNotNullExpressionValue((Object)pgLocalTable, (String)"t");
                        ModNamingFamily<? extends PgSecurityPolicy> modNamingFamily = pgLocalTable.getSecurityPolicies();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"t.securityPolicies");
                        it.invoke(modNamingFamily);
                    }
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$isSupported = bl;
                    super(1);
                }
            });
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, transaction, (PgGPlumBaseSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveSecurityPolicies(MySchemaRetriever $this) {
            $this.retrieveSecurityPolicies();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion;", "", "()V", "QUERIES", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "setVersionParameters", "", "version", "Lcom/intellij/database/util/Version;", "parameters", "", "", "intellij.database.dialects.postgres"})
    public static final class Companion {
        public final void setVersionParameters(@NotNull Version version, @NotNull Map<String, Object> parameters2) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
            int n = 1;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 8, new IntRange(n, 4), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 9, new IntRange(n, 9), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 10, new IntRange(n, 0), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 11, new IntRange(n, 0), parameters2);
            n = 0;
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 12, new IntRange(n, 0), parameters2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

