/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PgBaseDomains
extends BaseDomainRegistry {
    public static final int MAX_FRACTION = 6;
    public static final double MAX_REAL = 1.0E37;
    public static final double MIN_REAL = -1.0E37;
    public static final double MIN_DOUBLE = -1.0E307;
    public static final double MAX_DOUBLE = 1.0E308;

    protected PgBaseDomains(int maxPrecision, int maxScale, int maxChar, int maxVarchar) {
        this.add((Domain)new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add((Domain)new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add((Domain)new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add((Domain)new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("char", ConversionPoint.CHAR, (long)maxChar, 1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, (long)maxChar, 1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("character", ConversionPoint.CHAR, (long)maxChar, 1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, (long)maxVarchar, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, (long)maxVarchar, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN).withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN).withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add((Domain)new UnknownDomain("abstime"));
        this.add((Domain)new UnknownDomain("aclitem"));
        this.add((Domain)new UnknownDomain("cidr"));
        this.add((Domain)new UnknownDomain("circle"));
        this.add((Domain)new UnknownDomain("inet"));
        this.add((Domain)new UnknownDomain("macaddr"));
        this.add(new UnknownDomain("oid").withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add((Domain)new UnknownDomain("path"));
        this.add((Domain)new UnknownDomain("polygon"));
        this.add((Domain)new UnknownDomain("refcursor"));
        this.add((Domain)new UnknownDomain("regclass"));
        this.add((Domain)new UnknownDomain("regoper"));
        this.add((Domain)new UnknownDomain("regoperator"));
        this.add((Domain)new UnknownDomain("regproc"));
        this.add((Domain)new UnknownDomain("regprocedure"));
        this.add((Domain)new UnknownDomain("regtype"));
        this.add((Domain)new UnknownDomain("reltime"));
        this.add((Domain)new UnknownDomain("smgr"));
        this.add((Domain)new UnknownDomain("tinterval"));
        this.add((Domain)new UnknownDomain("varbit"));
    }

    protected static class MyTextLikeDomain
    extends TextLikeDomain {
        public MyTextLikeDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type) {
            if (name2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyTextLikeDomain.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyTextLikeDomain.$$$reportNull$$$0(2);
            }
            super(name2, descriptor, type);
        }

        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                MyTextLikeDomain.$$$reportNull$$$0(3);
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                MyTextLikeDomain.$$$reportNull$$$0(4);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyTextLikeDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyTextLikeDomain";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                MyZonedDomain.$$$reportNull$$$0(1);
            }
            super(domain.simpleName(), domain.getPoint(), domain.getDomainType(), domain.getMax(), domain.getDefaultValue(), domain.isNarrowable());
            this.myPrefix = prefix;
            this.withOperationSupport(domain.getOperationSupport());
        }

        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(2);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
        }

        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                MyZonedDomain.$$$reportNull$$$0(3);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
        }

        @NotNull
        public String name() {
            Object object = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (object == null) {
                MyZonedDomain.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyZonedDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseDomains$MyZonedDomain";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

