/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.dialects.postgresbase.PgBaseDomains;

public class PgGPlumBaseDomains
extends PgBaseDomains {
    private static final int MAX_BIT = 0x5000000;
    private static final int MONEY_SCALE = 2;
    private static final int MAX_PRECISION = 1000;
    private static final int MAX_CHAR = 0xA00000;

    public PgGPlumBaseDomains() {
        super(1000, 1000, 0xA00000, 0xA00000);
        this.add((Domain)new PgBaseDomains.MyZonedDomain(new FractionDomain("time with time zone", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true), "TIME"));
        this.add((Domain)new PgBaseDomains.MyZonedDomain(new FractionDomain("timestamp with time zone", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true), "timestamp"));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add((Domain)new FractionDomain("timestamptz", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 1000, 2, false).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new IntegerDomain("serial", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("bigserial", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new PgBaseDomains.MyTextLikeDomain("point", ConversionPoint.POINT, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new PgBaseDomains.MyTextLikeDomain("interval", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, 6, true));
        this.add((Domain)new FractionDomain("timetz", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true));
        this.add((Domain)new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new TextDomain("bit", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("bit varying", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new TextDomain("tid", ConversionPoint.TEXT_ID, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.UNKNOWN));
        this.add(new SimpleDomain("tsvector", ConversionPoint.TSVECTOR, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new UnknownDomain("box"));
        this.add((Domain)new UnknownDomain("gtsvector"));
        this.add((Domain)new UnknownDomain("line"));
        this.add((Domain)new UnknownDomain("lseg"));
        this.add((Domain)new UnknownDomain("regconfig"));
        this.add((Domain)new UnknownDomain("regdictionary"));
        this.add((Domain)new UnknownDomain("tsquery"));
        this.add((Domain)new UnknownDomain("txid_snapshot"));
    }
}

