/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.TIntObjectHashMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SFlakeRawPlanData
extends RawPlanData {
    MetaNode root;

    @Override
    public void load(@NotNull DatabaseConnectionCore connection, final @NotNull String statement, boolean run2) {
        if (connection == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(1);
        }
        this.root = null;
        final TIntObjectHashMap objects = new TIntObjectHashMap();
        SFlakeRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                s.noisy().execute((Object)("EXPLAIN USING TABULAR " + statement), SFlakeRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    while (rs.next()) {
                        Object id = rs.getObject(2);
                        if (id == null) continue;
                        Object parent2 = rs.getObject(3);
                        MetaNode node = new MetaNode(((Number)id).intValue(), parent2 == null ? -1 : ((Number)parent2).intValue(), rs.getString(4), rs.getString(5), rs.getString(6), rs.getString(7), (Number)rs.getObject(8), (Number)rs.getObject(9), (Number)rs.getObject(10));
                        objects.put(node.id, (Object)node);
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
        this.root = SFlakeRawPlanData.finish((TIntObjectHashMap<MetaNode>)objects);
    }

    private static MetaNode finish(TIntObjectHashMap<MetaNode> objects) {
        objects.forEachValue(n -> {
            if (n.parent != -1) {
                MetaNode parent2 = (MetaNode)objects.get(n.parent);
                if (parent2.children == null) {
                    parent2.children = new ArrayList<MetaNode>();
                }
                parent2.children.add((MetaNode)n);
            }
            return true;
        });
        return (MetaNode)objects.get(0);
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            SFlakeRawPlanData.$$$reportNull$$$0(2);
        }
        TIntObjectHashMap objects = new TIntObjectHashMap();
        for (String line : dump.split("\\r?\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 9);
            MetaNode node = new MetaNode(Integer.parseInt((String)split.get(0)), Integer.parseInt((String)split.get(1)), (String)split.get(2), (String)split.get(3), (String)split.get(4), (String)split.get(5), "null".equals(split.get(6)) ? null : Integer.valueOf((String)split.get(6)), "null".equals(split.get(7)) ? null : Integer.valueOf((String)split.get(7)), "null".equals(split.get(8)) ? null : Integer.valueOf((String)split.get(8)));
            objects.put(node.id, (Object)node);
        }
        this.root = SFlakeRawPlanData.finish((TIntObjectHashMap<MetaNode>)objects);
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (MetaNode n2 : ((JBTreeTraverser)JBTreeTraverser.from(n -> n.children).withRoot((Object)this.root)).traverse()) {
            sb.append(n2.id).append("\t").append(n2.parent).append("\t").append(n2.tp).append("\t").append(n2.objects).append("\t").append(n2.alias).append("\t").append(n2.expressions).append("\t").append(n2.partitionsTotal).append("\t").append(n2.partitionsAssigned).append("\t").append(n2.bytesAssigned).append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/snowflake/plan/SFlakeRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MetaNode {
        final int id;
        final int parent;
        final String tp;
        final String objects;
        final String alias;
        final String expressions;
        final Number partitionsTotal;
        final Number partitionsAssigned;
        final Number bytesAssigned;
        List<MetaNode> children;

        public MetaNode(int id, int parent2, String tp, String objects, String alias, String expressions, Number partitionsTotal, Number partitionsAssigned, Number bytesAssigned) {
            this.id = id;
            this.parent = parent2;
            this.tp = tp;
            this.objects = objects;
            this.alias = alias;
            this.expressions = expressions;
            this.partitionsTotal = partitionsTotal;
            this.partitionsAssigned = partitionsAssigned;
            this.bytesAssigned = bytesAssigned;
        }
    }
}

