/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.sybase.generator.AseNamingService;
import com.intellij.database.dialects.sybase.introspector.AseIntroQueries;
import com.intellij.database.dialects.sybase.model.AseArgument;
import com.intellij.database.dialects.sybase.model.AseForeignKey;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseGrantsHolder;
import com.intellij.database.dialects.sybase.model.AseLikeTable;
import com.intellij.database.dialects.sybase.model.AseMajorObject;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseSchema;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTable;
import com.intellij.database.dialects.sybase.model.AseTableColumn;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.dialects.sybase.model.properties.AseObjectGrant;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00c4\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002\u001a\u0010\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001a\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u0003H\u0002\u001a\u0018\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0003H\u0002\u001a\u001e\u00100\u001a\u0004\u0018\u00010\u00022\b\u00101\u001a\u0004\u0018\u00010\u00022\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0002\u001a:\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u0010/\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0002\u001a\u0018\u0010;\u001a\u00020\u00062\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0003H\u0000\u001a\u0014\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010=H\u0002\u001a\u0016\u0010B\u001a\u00020\u0018*\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002\u001a\u001c\u0010F\u001a\u00020G*\n\u0012\u0006\b\u0001\u0012\u00020G0H2\u0006\u0010+\u001a\u00020\u0002H\u0002\u001a\u0016\u0010I\u001a\u0004\u0018\u00010 *\u00020J2\u0006\u0010K\u001a\u00020\u0003H\u0002\u001a\u0016\u0010L\u001a\u0004\u0018\u00010M*\u00020J2\u0006\u0010K\u001a\u00020\u0003H\u0002\u001a\u001e\u0010N\u001a\u0004\u0018\u00010O*\u00020J2\u0006\u0010P\u001a\u00020Q2\u0006\u0010,\u001a\u00020\u0003H\u0002\u001a\u0014\u0010R\u001a\u00020\u0018*\n\u0012\u0006\b\u0001\u0012\u00020S0HH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"CHARACTER_TYPES", "", "", "", "CHARACTER_TYPES_16", "COLUMN_BITS1_IDENTITY", "", "COLUMN_BITS1_NULLABLE", "COLUMN_BITS2_COMPUTED", "COLUMN_BITS2_OUTPUT", "EXACT_LENGTH_TYPES", "", "INDEX_BITS1_CLUSTERED", "INDEX_BITS1_PRIMARY", "INDEX_BITS1_UNIQUE", "INDEX_BITS2_KEY", "INDEX_BITS2_NAME_SURROGATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SYBASE_INTERNAL_REMARK_PATTERN", "Lkotlin/text/Regex;", "TYPE_SUBSTITUTION", "applyGrants", "", "holder", "Lcom/intellij/database/dialects/sybase/model/AseGrantsHolder;", "grants", "", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries$OneGrant;", "assignForeignKeyColumns", "foreignKey", "Lcom/intellij/database/dialects/sybase/model/AseForeignKey;", "columnPositions", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "id", "fixFloatPrecision", "type_name", "length", "joinSourceTextParts", "text1", "text2", "makeDataType", "Lcom/intellij/database/model/DataType;", "typeName", "precision", "scale", "variable", "ver", "Lcom/intellij/database/util/Version;", "peek16", "array", "", "offset", "toBitSet", "Ljava/util/BitSet;", "bytes", "addEvent", "Lcom/intellij/database/dialects/sybase/model/AseTrigger;", "event", "Lcom/intellij/database/model/TrigEvent;", "createOrGetByName", "Lcom/intellij/database/dialects/sybase/model/AseArgument;", "Lcom/intellij/database/model/families/ModFamily;", "findForeignKeyById", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "objectId", "findObjectById", "Lcom/intellij/database/dialects/sybase/model/AseMajorObject;", "findTableOrView", "Lcom/intellij/database/dialects/sybase/model/AseLikeTable;", "code", "", "finish", "Lcom/intellij/database/model/basic/BasicModElement;", "intellij.database.dialects.sybase"})
public final class AseIntrospectorKt {
    private static final Logger LOG;
    private static final short COLUMN_BITS1_IDENTITY = 128;
    private static final short COLUMN_BITS1_NULLABLE = 8;
    private static final short COLUMN_BITS2_COMPUTED = 16;
    private static final short COLUMN_BITS2_OUTPUT = 2;
    private static final short INDEX_BITS1_PRIMARY = 2048;
    private static final short INDEX_BITS1_CLUSTERED = 16;
    private static final short INDEX_BITS1_UNIQUE = 2;
    private static final short INDEX_BITS2_NAME_SURROGATE = 8;
    private static final short INDEX_BITS2_KEY = 2;
    private static final Set<String> EXACT_LENGTH_TYPES;
    private static final Map<String, Integer> CHARACTER_TYPES;
    private static final Map<String, Integer> CHARACTER_TYPES_16;
    private static final Map<String, String> TYPE_SUBSTITUTION;
    private static final Regex SYBASE_INTERNAL_REMARK_PATTERN;

    private static final String catalogPrefix(BasicDatabase database) {
        String string;
        if (database.isCurrent()) {
            string = "dbo";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = database.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"database.name");
            string = stringBuilder.append(AseNamingService.INSTANCE.enquote(string2, database.getKind())).append(".dbo").toString();
        }
        return string;
    }

    private static final boolean detectSurrogateName(String name2, int id) {
        if (name2 == null) {
            return false;
        }
        String idStr = "" + '_' + id;
        return name2.length() > idStr.length() && StringsKt.endsWith$default((String)name2, (String)idStr, (boolean)false, (int)2, null);
    }

    private static final int fixFloatPrecision(String type_name, int length) {
        if (Intrinsics.areEqual((Object)"float", (Object)type_name)) {
            if (length == 8) {
                return 22;
            }
            if (length == 4) {
                return 15;
            }
        }
        return length;
    }

    private static final DataType makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        DataType dataType;
        if (typeName == null) {
            DataType dataType2 = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"DataType.UNKNOWN");
            return dataType2;
        }
        boolean exactLength = EXACT_LENGTH_TYPES.contains(typeName);
        int p = 0;
        short s = 0;
        LengthUnit u = null;
        Map<String, Integer> charTypes = ver.isOrGreater(new int[]{16}) ? CHARACTER_TYPES_16 : CHARACTER_TYPES;
        if (length == 0 && precision == 0 || !variable && !exactLength) {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        } else if (precision > 0) {
            p = precision;
            s = scale;
            LengthUnit lengthUnit = LengthUnit.DIGIT;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"LengthUnit.DIGIT");
            u = lengthUnit;
        } else if (exactLength) {
            s = 0;
            Integer lenFix = charTypes.get(typeName);
            if (lenFix != null) {
                p = length / lenFix;
                LengthUnit lengthUnit = LengthUnit.CHAR;
                Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"LengthUnit.CHAR");
                u = lengthUnit;
            } else {
                LengthUnit lengthUnit;
                p = AseIntrospectorKt.fixFloatPrecision(typeName, length);
                if (length > 0) {
                    LengthUnit lengthUnit2 = LengthUnit.BYTE;
                    lengthUnit = lengthUnit2;
                    Intrinsics.checkNotNullExpressionValue((Object)lengthUnit2, (String)"LengthUnit.BYTE");
                } else {
                    LengthUnit lengthUnit3 = LengthUnit.NONE;
                    lengthUnit = lengthUnit3;
                    Intrinsics.checkNotNullExpressionValue((Object)lengthUnit3, (String)"LengthUnit.NONE");
                }
                u = lengthUnit;
            }
        } else {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        }
        try {
            String string = TYPE_SUBSTITUTION.get(typeName);
            if (string == null) {
                string = typeName;
            }
            DataType dataType3 = DataTypeFactory.of(null, (String)string, (int)p, (int)s, (LengthUnit)u, null, (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"DataTypeFactory.of(null,\u2026s, u, null, false, false)");
            dataType = dataType3;
        }
        catch (Exception e2) {
            String string = e2.getMessage();
            if (string == null) {
                string = e2.getClass().getName();
            }
            String exceptionMessage = string;
            LOG.warn("Failed to handle data type " + typeName + " with length " + length + " precision " + precision + " scale " + scale + ": " + exceptionMessage);
            DataType dataType4 = DataType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dataType4, (String)"DataType.UNKNOWN");
            dataType = dataType4;
        }
        DataType dt = dataType;
        return dt;
    }

    /*
     * WARNING - void declaration
     */
    public static final short peek16(@NotNull byte[] array, int offset) {
        void $this$and$iv;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        byte b1 = array[offset];
        byte b2 = array[offset + 1];
        byte by = b1;
        int that$iv = 255;
        boolean $i$f$and = false;
        void $this$toUnsignedInt$iv$iv = $this$and$iv;
        boolean $i$f$toUnsignedInt = false;
        return (short)((b2 & 0xFF) << 8 | (byte)(Byte.toUnsignedInt((byte)$this$toUnsignedInt$iv$iv) & that$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final void assignForeignKeyColumns(AseForeignKey foreignKey, short[] columnPositions) {
        AseTable table = foreignKey.getTable();
        int n = columnPositions.length;
        ArrayList<Object> names2 = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            AseTable aseTable = table;
            Intrinsics.checkNotNull((Object)aseTable);
            AseTableColumn column2 = (AseTableColumn)aseTable.getColumns().getByNaturalPosition(columnPositions[i2]);
            Object object = column2;
            if (object == null || (object = object.getRealName()) == null) {
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"column?.realName ?: continue");
                Object name2 = object;
                names2.add(name2);
            }
            ++i2;
        }
        foreignKey.setColNames(names2);
    }

    private static final AseMajorObject findObjectById(AseSchema $this$findObjectById, int objectId) {
        AseMajorObject aseMajorObject;
        AseMajorObject aseMajorObject2;
        AseMajorObject aseMajorObject3 = (AseMajorObject)$this$findObjectById.getTables().getByObjectId(objectId);
        if (aseMajorObject3 == null) {
            aseMajorObject3 = aseMajorObject2 = (AseMajorObject)$this$findObjectById.getViews().getByObjectId(objectId);
        }
        if (aseMajorObject3 == null) {
            aseMajorObject2 = aseMajorObject = (AseMajorObject)$this$findObjectById.getFunctions().getByObjectId(objectId);
        }
        if (aseMajorObject2 == null) {
            aseMajorObject = (AseMajorObject)$this$findObjectById.getProcedureGroups().getByObjectId(objectId);
        }
        return aseMajorObject;
    }

    private static final AseForeignKey findForeignKeyById(AseSchema $this$findForeignKeyById, int objectId) {
        long id = objectId;
        Iterator iterator = $this$findForeignKeyById.getTables().iterator();
        while (iterator.hasNext()) {
            AseTable table;
            AseTable aseTable = table = (AseTable)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)aseTable, (String)"table");
            Iterator iterator2 = aseTable.getForeignKeys().iterator();
            while (iterator2.hasNext()) {
                AseForeignKey fk;
                AseForeignKey aseForeignKey = fk = (AseForeignKey)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)aseForeignKey, (String)"fk");
                if (aseForeignKey.getObjectId() != id) continue;
                return fk;
            }
        }
        return null;
    }

    private static final AseArgument createOrGetByName(ModFamily<? extends AseArgument> $this$createOrGetByName, String name2) {
        Object v1;
        block3: {
            Iterable $this$firstOrNull$iv = (Iterable)$this$createOrGetByName;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AseArgument it = (AseArgument)element$iv;
                boolean bl = false;
                AseArgument aseArgument = it;
                Intrinsics.checkNotNullExpressionValue((Object)aseArgument, (String)"it");
                if (!Intrinsics.areEqual((Object)aseArgument.getName(), (Object)name2)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        AseArgument a = v1;
        if (a == null) {
            a = (AseArgument)$this$createOrGetByName.createNewOne();
            a.setName(name2);
        } else {
            a.resetSyncPending();
        }
        return a;
    }

    private static final void finish(ModFamily<? extends BasicModElement> $this$finish) {
        $this$finish.removeSyncPendingChildren();
        $this$finish.sort();
    }

    private static final void addEvent(AseTrigger $this$addEvent, TrigEvent event) {
        if (event == null) {
            return;
        }
        Set set = $this$addEvent.getEvents();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.events");
        Set events = set;
        if (events.isEmpty()) {
            $this$addEvent.setEvents(Collections.singleton(event));
        } else if (!events.contains(event)) {
            $this$addEvent.setEvents(SetsKt.plus((Set)events, (Object)event));
        }
    }

    private static final AseLikeTable findTableOrView(AseSchema $this$findTableOrView, char code, int id) {
        AseLikeTable aseLikeTable;
        switch (code) {
            case 'T': {
                aseLikeTable = (AseLikeTable)$this$findTableOrView.getTables().getByObjectId(id);
                break;
            }
            case 'V': {
                aseLikeTable = (AseLikeTable)$this$findTableOrView.getViews().getByObjectId(id);
                break;
            }
            default: {
                aseLikeTable = null;
            }
        }
        return aseLikeTable;
    }

    private static final String joinSourceTextParts(String text1, String text2) {
        String string;
        if (text1 == null) {
            string = text2;
        } else if (text2 == null) {
            string = text1;
        } else {
            CharSequence charSequence = text1;
            Regex regex = SYBASE_INTERNAL_REMARK_PATTERN;
            boolean bl = false;
            string = regex.matches(charSequence) && StringsKt.startsWith$default((String)text2, (String)"CREATE", (boolean)false, (int)2, null) ? text1 + '\n' + text2 : text1 + text2;
        }
        return string;
    }

    private static final boolean canCheckOutdated(BasicElement e2) {
        return e2 == null || e2 instanceof AseSchemaObject && !(e2 instanceof AseFunction) && !(e2 instanceof AseProcedureGroup) && !(e2 instanceof AseTrigger) && ((AseSchemaObject)e2).getStateNumber() != -1;
    }

    private static final void applyGrants(AseGrantsHolder holder, List<AseIntroQueries.OneGrant> grants) {
        ArrayList<AseObjectGrant> newGrants = new ArrayList<AseObjectGrant>();
        for (AseIntroQueries.OneGrant g : grants) {
            Grants.State state2;
            switch (g.type) {
                case 0: {
                    state2 = Grants.State.GRANT_WITH_GRANT_OPTION;
                    break;
                }
                case 2: {
                    state2 = Grants.State.REVOKE;
                    break;
                }
                default: {
                    state2 = Grants.State.GRANT;
                }
            }
            Grants.State state3 = state2;
            long l = g.object_id;
            BitSet bitSet = AseIntrospectorKt.toBitSet(g.columns);
            long l2 = g.user_id;
            String string = g.permission;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"g.permission");
            AseObjectGrant complete = new AseObjectGrant(l, bitSet, l2, string, state3);
            newGrants.add(complete);
        }
        holder.setGrants((Grants<AseObjectGrant>)holder.getGrants().with((Iterable)newGrants));
    }

    /*
     * WARNING - void declaration
     */
    private static final BitSet toBitSet(byte[] bytes) {
        block3: {
            block2: {
                void $this$and$iv;
                if (bytes == null) break block2;
                byte[] byArray = bytes;
                boolean bl = false;
                if (byArray.length == 0) break block2;
                byte by = bytes[0];
                int that$iv = 1;
                boolean $i$f$and = false;
                void $this$toUnsignedInt$iv$iv = $this$and$iv;
                boolean $i$f$toUnsignedInt = false;
                if ((byte)(Byte.toUnsignedInt((byte)$this$toUnsignedInt$iv$iv) & that$iv) != (byte)1) break block3;
            }
            return null;
        }
        return BitSet.valueOf(bytes);
    }

    static {
        Logger logger = Logger.getInstance(BaseMultiDatabaseIntrospector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(BaseM\u2026Introspector::class.java)");
        LOG = logger;
        EXACT_LENGTH_TYPES = SetsKt.setOf((Object[])new String[]{"char", "nchar", "unichar", "varchar", "nvarchar", "univarchar", "binary", "float", "numeric", "decimal"});
        CHARACTER_TYPES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)1), TuplesKt.to((Object)"varchar", (Object)1), TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2), TuplesKt.to((Object)"nchar", (Object)3), TuplesKt.to((Object)"nvarchar", (Object)3), TuplesKt.to((Object)"sysname", (Object)1), TuplesKt.to((Object)"longsysname", (Object)1)});
        CHARACTER_TYPES_16 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2)});
        TYPE_SUBSTITUTION = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"usmallint", (Object)"unsigned smallint"), TuplesKt.to((Object)"uint", (Object)"unsigned int"), TuplesKt.to((Object)"ubigint", (Object)"unsigned bigint")});
        String string = "^/\\*[^/]+?\\*/\\s*$";
        boolean bl = false;
        SYBASE_INTERNAL_REMARK_PATTERN = new Regex(string);
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(BasicElement e2) {
        return AseIntrospectorKt.canCheckOutdated(e2);
    }

    public static final /* synthetic */ String access$catalogPrefix(BasicDatabase database) {
        return AseIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ void access$applyGrants(AseGrantsHolder holder, List grants) {
        AseIntrospectorKt.applyGrants(holder, grants);
    }

    public static final /* synthetic */ void access$finish(ModFamily $this$access_u24finish) {
        AseIntrospectorKt.finish((ModFamily<? extends BasicModElement>)$this$access_u24finish);
    }

    public static final /* synthetic */ AseMajorObject access$findObjectById(AseSchema $this$access_u24findObjectById, int objectId) {
        return AseIntrospectorKt.findObjectById($this$access_u24findObjectById, objectId);
    }

    public static final /* synthetic */ DataType access$makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        return AseIntrospectorKt.makeDataType(typeName, length, precision, scale, variable, ver);
    }

    public static final /* synthetic */ AseArgument access$createOrGetByName(ModFamily $this$access_u24createOrGetByName, String name2) {
        return AseIntrospectorKt.createOrGetByName((ModFamily<? extends AseArgument>)$this$access_u24createOrGetByName, name2);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(String name2, int id) {
        return AseIntrospectorKt.detectSurrogateName(name2, id);
    }

    public static final /* synthetic */ void access$assignForeignKeyColumns(AseForeignKey foreignKey, short[] columnPositions) {
        AseIntrospectorKt.assignForeignKeyColumns(foreignKey, columnPositions);
    }

    public static final /* synthetic */ AseForeignKey access$findForeignKeyById(AseSchema $this$access_u24findForeignKeyById, int objectId) {
        return AseIntrospectorKt.findForeignKeyById($this$access_u24findForeignKeyById, objectId);
    }

    public static final /* synthetic */ void access$addEvent(AseTrigger $this$access_u24addEvent, TrigEvent event) {
        AseIntrospectorKt.addEvent($this$access_u24addEvent, event);
    }

    public static final /* synthetic */ String access$joinSourceTextParts(String text1, String text2) {
        return AseIntrospectorKt.joinSourceTextParts(text1, text2);
    }

    public static final /* synthetic */ AseLikeTable access$findTableOrView(AseSchema $this$access_u24findTableOrView, char code, int id) {
        return AseIntrospectorKt.findTableOrView($this$access_u24findTableOrView, code, id);
    }
}

