/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.cassandra.CassDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCollectionLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassSetOrMapLiteral
extends SqlCollectionLiteralExpressionImpl {
    public CassSetOrMapLiteral(@NotNull IElementType elementType) {
        if (elementType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public SqlType getSqlType() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof SqlSetAssignment) {
                SqlSetAssignment setAssignment = (SqlSetAssignment)child;
                SqlElement lValue = setAssignment.getLValue();
                if (lValue instanceof SqlReferenceExpression) {
                    return this.getSqlTableType();
                }
                SqlParametrizedType sqlParametrizedType = CassSetOrMapLiteral.getSqlMapType(lValue, setAssignment.getRValue());
                if (sqlParametrizedType == null) {
                    CassSetOrMapLiteral.$$$reportNull$$$0(1);
                }
                return sqlParametrizedType;
            }
            if (!(child instanceof SqlExpression)) continue;
            return CassSetOrMapLiteral.getSqlSetType((SqlExpression)child);
        }
        return new SqlTableTypeBase.Empty();
    }

    private static SqlParametrizedType getSqlMapType(@NotNull SqlElement lValue, @Nullable SqlElement rValue) {
        if (lValue == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(2);
        }
        SqlPrimitiveType keyType = SqlType.UNKNOWN;
        SqlPrimitiveType valueType = SqlType.UNKNOWN;
        if (lValue instanceof SqlExpression) {
            keyType = ((SqlExpression)lValue).getSqlType();
        }
        if (rValue instanceof SqlExpression) {
            valueType = ((SqlExpression)rValue).getSqlType();
        }
        String specification = String.format("map<%s, %s>", keyType.getDataType(), valueType.getDataType());
        return SqlTypeFactory.of((DataType)DataTypeFactory.of((String)specification), (SqlLanguageDialect)CassDialect.INSTANCE, Arrays.asList(keyType, valueType));
    }

    @NotNull
    private static SqlParametrizedType getSqlSetType(SqlExpression expression) {
        SqlType itemType = expression.getSqlType();
        String specification = String.format("set<%s>", itemType.getDataType());
        SqlParametrizedType sqlParametrizedType = SqlTypeFactory.of((DataType)DataTypeFactory.of((String)specification), (SqlLanguageDialect)CassDialect.INSTANCE, Collections.singletonList(itemType));
        if (sqlParametrizedType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(3);
        }
        return sqlParametrizedType;
    }

    @NotNull
    private SqlTableType getSqlTableType() {
        ArrayList<SqlImplUtil.Column> columns = new ArrayList<SqlImplUtil.Column>();
        SqlSetAssignment[] mapElements = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlSetAssignment.class);
        if (mapElements == null) {
            return new SqlTableTypeBase.Empty();
        }
        for (SqlSetAssignment element : mapElements) {
            SqlElement rValue = element.getRValue();
            if (rValue == null) {
                return new SqlTableTypeBase.Empty();
            }
            SqlPrimitiveType type = rValue instanceof SqlExpression ? ((SqlExpression)rValue).getSqlType() : SqlType.UNKNOWN;
            DasType dasType = rValue instanceof SqlExpression ? ((SqlExpression)rValue).getDasType() : DasType.UNKNOWN;
            columns.add(new SqlImplUtil.Column(element.getLValue().getName(), (SqlType)type, dasType, (PsiElement)rValue, null));
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, columns, (PsiElement)this);
        if (sqlTableType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSetType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSqlMapType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

