/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.couchbase;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.couchbase.CouchbaseReservedKeywords;
import com.intellij.sql.dialects.couchbase.CouchbaseTokens;
import com.intellij.sql.dialects.couchbase.CouchbaseTypeSystem;
import com.intellij.sql.dialects.couchbase.CouchbaseTypes;
import com.intellij.sql.dialects.couchbase.psi.DasVirtualColumnSymbol;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CouchbaseDialect
extends SqlLanguageDialectEx {
    public static final CouchbaseDialect INSTANCE = new CouchbaseDialect();

    public CouchbaseDialect() {
        super("CouchbaseQuery");
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        CouchbaseTypeSystem couchbaseTypeSystem = CouchbaseTypeSystem.INSTANCE;
        if (couchbaseTypeSystem == null) {
            CouchbaseDialect.$$$reportNull$$$0(0);
        }
        return couchbaseTypeSystem;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        Collection res2 = super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            res2.add(ObjectKind.COLUMN);
        }
        return (T)res2;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        ASTNode node;
        SqlJoinExpression join;
        if (expectedTypes == null) {
            CouchbaseDialect.$$$reportNull$$$0(1);
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN) && symbol != null && (join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)symbol.getContextElement(), SqlJoinExpression.class)) != null && (node = join.getOpSignElement().getNode()).getElementType() == CouchbaseTypes.COUCH_UNNEST) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CouchbaseDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        if (dbms == null) {
            CouchbaseDialect.$$$reportNull$$$0(3);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"JSON", (String)"json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"ID", (String)"identifier", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"ATOM", (String)"atomic", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CouchbaseDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CouchbaseDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CouchbaseDialect.$$$reportNull$$$0(6);
        }
        return set;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state2, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            CouchbaseDialect.$$$reportNull$$$0(7);
        }
        if (state2 == null) {
            CouchbaseDialect.$$$reportNull$$$0(8);
        }
        if (ref2 == null) {
            CouchbaseDialect.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            CouchbaseDialect.$$$reportNull$$$0(10);
        }
        if (SqlImplUtil.isProcessingOneOf((SqlScopeProcessor)processor, (ObjectKind[])new ObjectKind[]{ObjectKind.COLUMN}) && PsiTreeUtil.getParentOfType((PsiElement)ref2.getElement(), SqlSetClause.class) != null) {
            DasVirtualColumnSymbol symbol;
            SqlElement element = (SqlElement)ObjectUtils.tryCast((Object)ref2.getElement(), SqlElement.class);
            if (element == null) {
                return super.processQualifiedResolve(processor, state2, ref2, qualifier);
            }
            SqlSetAssignment assignment = (SqlSetAssignment)PsiTreeUtil.getParentOfType((PsiElement)element, SqlSetAssignment.class);
            if ((assignment == null || PsiTreeUtil.isAncestor((PsiElement)assignment.getLValue(), (PsiElement)element, (boolean)false)) && !processor.execute((DasSymbol)(symbol = new DasVirtualColumnSymbol(ref2.getReferenceName(), element)), state2)) {
                return false;
            }
        }
        return super.processQualifiedResolve(processor, state2, ref2, qualifier);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o2, InspectionManager manager, boolean onTheFly, boolean pl) {
        return PsiUtilCore.getElementType((PsiElement)o2.getFirstChild()) == CouchbaseReservedKeywords.COUCH_SYSTEM && SqlImplUtil.isQualifier((PsiElement)o2.getParent(), (ObjectKind)ObjectKind.TABLE) ? null : super.checkIdentifierIsKeyword(o2, manager, onTheFly, pl);
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/couchbase/CouchbaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CouchbaseTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = ContainerUtil.set((Object[])new IElementType[]{SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_GT, SqlCommonKeywords.SQL_NOT, SqlCommonKeywords.SQL_IN, SqlCommonTokens.SQL_OP_MODULO});
            ourClosingTokens = SqlCommonTokens.STATEMENT_SEPARATORS;
            ourKeywords = SqlTokenRegistry.getTokens(CouchbaseTokens.class);
            ourReservedKeywords = SqlTokenRegistry.getTokens(CouchbaseReservedKeywords.class);
        }
    }
}

