/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.MongoJSSyntaxHighlighter;
import com.intellij.sql.dialects.mongo.js.MongoJsParsingHelper;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReference;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSUseStatement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getIdentifierKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.database.dialects.mongo"})
public final class MongoJSAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        TextAttributesKey keys;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)element);
        TextAttributesKey textAttributesKey = keys = Intrinsics.areEqual((Object)iElementType, (Object)JSElementTypes.IDENTIFIER) ? this.getIdentifierKey(element) : null;
        if (keys != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(keys).create();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TextAttributesKey getIdentifierKey(PsiElement element) {
        TextAttributesKey textAttributesKey;
        PsiElement parent2 = element.getParent();
        if (MongoJSPsiUtilKt.isPropertyKey(element)) {
            textAttributesKey = MongoJSSyntaxHighlighter.Companion.getPROPERTY();
            return textAttributesKey;
        }
        PsiElement psiElement = parent2;
        if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)JSElementTypes.SHOW_STATEMENT)) {
            PsiElement psiElement2 = parent2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            if (Intrinsics.areEqual((Object)psiElement2.getFirstChild(), (Object)element) || ArraysKt.contains((Object[])MongoJsParsingHelper.Companion.getSHOW_COMMANDS(), (Object)element.getText())) {
                textAttributesKey = MongoJSSyntaxHighlighter.Companion.getKEYWORD();
                return textAttributesKey;
            }
        }
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)JSElementTypes.IDENTIFIER) && parent2 instanceof MongoJSReferenceExpression) {
            MongoJSReferenceExpression $this$isDbReference$iv = (MongoJSReferenceExpression)parent2;
            boolean $i$f$isDbReference = false;
            MongoJSReference mongoJSReference = $this$isDbReference$iv.getReference();
            Intrinsics.checkNotNullExpressionValue((Object)mongoJSReference, (String)"reference");
            if (!MongoJSPsiUtilKt.isDbReference(mongoJSReference) && !(((MongoJSReferenceExpression)parent2).getParent() instanceof MongoJSUseStatement)) {
                textAttributesKey = MongoJSSyntaxHighlighter.Companion.getIDENT();
                return textAttributesKey;
            }
            textAttributesKey = MongoJSSyntaxHighlighter.Companion.getDB();
            return textAttributesKey;
        }
        PsiElement psiElement3 = parent2;
        if (!Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)JSElementTypes.USE_STATEMENT)) return null;
        textAttributesKey = MongoJSSyntaxHighlighter.Companion.getKEYWORD();
        return textAttributesKey;
    }
}

